<?php if (!defined('ABSPATH')) die;

if (!is_admin() || p3_check_file()) {
	return;
}

require_once dirname( __FILE__ ) . '/tgm.php';

function pipdig_plugins_install() {

    $plugins = array(
		array(
			'name' => 'Regenerate Thumbnails',
			'slug' => 'regenerate-thumbnails',
			'required' => true,
		),
		array(
			'name' => 'Meta Box',
			'slug' => 'meta-box',
			'required' => true,
		),
		array(
			'name' => 'pipdig Power Pack (p3)',
			'slug' => 'p3',
			'source' => 'https://bitbucket.org/pipdig/p3/get/master.zip',
			'required' => true,
		),
    );
	
	if (!defined('PIPDIG_P3_V') && get_option('p3_demo_imported') != 1) {
		$posts = wp_count_posts();
		$posts_count = $posts->publish + $posts->draft;
		if ($posts_count < 2) {
			
			$plugins[] = array(
				'name' => 'Demo Content Importer',
				'slug' => 'one-click-demo-import',
				'required' => true,
			);
			/*
			$plugins[] = array(
				'name' => 'Imsanity',
				'slug' => 'imsanity',
				'required' => true,
			);
			$plugins[] = array(
				'name' => 'Yoast SEO',
				'slug' => 'wordpress-seo',
				'required' => true,
			);
			*/
		}
	}
	
	$p3_text = '';
	if (class_exists('RWMB_Autoloader') && class_exists('RegenerateThumbnails') && !defined('PIPDIG_P3_V')) {
		$p3_text = '<br /><h2>Having problems installing the pipdig Power Pack? Please <a href="https://go.pipdig.co/open.php?id=p3-manual" target="_blank">click here</a> to install manually</h2>';
	}

	$config = array(
		'id' => 'pipdig-textdomain',
		'default_path' => '',
		'menu' => 'pipdig-install-plugins',
		'parent_slug' => 'themes.php',
		'capability' => 'edit_theme_options',
		'is_automatic' => true, // Automatically activate
		'strings' => array(
			'notice_can_install_required' => _n_noop(
				'This theme requires the following plugin: %1$s.'.$p3_text,
				'This theme requires the following plugins: %1$s.',
				'pipdig-textdomain'
			),
		),
		
	);

	tgmpa( $plugins, $config );

}
add_action( 'tgmpa_register', 'pipdig_plugins_install' );
