<?php
$posts_carousel_title = strip_tags(get_theme_mod('posts_carousel_title'));
if (empty($posts_carousel_title)) {
	$posts_carousel_title = __('Where to next?', 'pipdig-textdomain');
}

$shape = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQAQMAAABI+4zbAAAAA1BMVEUAAACnej3aAAAAAXRSTlMAQObYZgAAADRJREFUeNrtwQENAAAAwiD7p7bHBwwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAgKQDdsAAAWZeCiIAAAAASUVORK5CYII='; // landscape
		
$image_shape = get_theme_mod('posts_carousel_shape');
		
if ($image_shape == 2) {
	$shape = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAWgAAAHgAQMAAACyyGUjAAAAA1BMVEUAAACnej3aAAAAAXRSTlMAQObYZgAAACxJREFUeNrtwTEBAAAAwiD7p7bGDmAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkHVZAAAFam5MDAAAAAElFTkSuQmCC'; // portrait
} elseif ($image_shape == 3) {
	$shape = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAfQAAAH0AQMAAADxGE3JAAAAA1BMVEUAAACnej3aAAAAAXRSTlMAQObYZgAAADVJREFUeNrtwTEBAAAAwiD7p/ZZDGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOX0AAAEidG8rAAAAAElFTkSuQmCC'; // square
}

?>

<div class="carousel-footer">
<h3 class="p_post_titles_font"><?php echo $posts_carousel_title; ?></h3>
<div id="owl-footer" class="owl-carousel">
<?php
//if ( false === ( $carousel_posts = get_transient( 'pipdig_carousel_footer' ) ) ) { // check for transient value
	$date_range = get_theme_mod( 'posts_carousel_dates', '1 year ago' );
	$carousel_posts = new WP_Query( array(
		'post_type'             => 'post',
		'showposts'             => 15,
		'ignore_sticky_posts'   => true,
		'orderby'               => 'rand',
		'order'                 => 'dsc',
		'date_query' => array(
			array(
				'after' => $date_range,
				),
			),
		)
	);
	//set_transient( 'pipdig_carousel_footer', $carousel_posts, 24 * HOUR_IN_SECONDS ); // set transient value
//} ?>

<?php while ( $carousel_posts->have_posts() ): $carousel_posts->the_post();
		$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'p3_medium' );
		if($thumb){
			$bg = esc_url($thumb['0']);
		} else {
			$bg = pipdig_catch_that_image();
		}
	?>
	<div class="owl-height-wrapper">
		<a href="<?php the_permalink() ?>" class="p3_slide_img" style="display: block; width: 100%; height: 100%;background-image:url(<?php echo $bg; ?>);">
			<img src="<?php echo esc_attr($shape); ?>" alt="<?php the_title_attribute(); ?>" class="p3_invisible" data-pin-nopin="true"/>
		</a>
		<h4 class="carousel-footer-title p_post_titles_font"><?php $title = get_the_title(); echo pipdig_truncate($title, 4); ?></h4>
	</div>
<?php endwhile; ?>
</div>
</div>

<script>
	jQuery(document).ready(function($) {
		$("#owl-footer").owlCarousel({
			items : 5,
			itemsDesktop : [1199,5],
			itemsDesktopSmall : [980,4],
			itemsTablet: [768,3],
			itemsMobile : [479,1],
			slideSpeed : 800,
			paginationSpeed : 1200,
			rewindSpeed : 1800,
			autoPlay : true,
			baseClass : "owl-carousel",
			theme : "owl-theme",
			lazyLoad : false,
		})
	});
</script>