<?php if (!defined('ABSPATH')) die; ?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<?php if(!get_theme_mod('disable_responsive')) { ?><meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no"><?php } ?>
	<?php wp_head(); ?>
	<?php
	/*************************************
	**
	**  DO NOT EDIT THIS FILE
	**  You can add code by using the
	**  the 'pipdig > Theme Hooks' page
	**
	**************************************/
	?>
</head>

<body <?php body_class(); ?>>

	<?php
	// If the "pipdig Power Pack" plugin is not installed, this theme won't work in the Customizer
	if (is_customize_preview() && !defined('PIPDIG_P3_V')) {
		
		if (p3_check_file()) {
			wp_die("Sorry! There has been an unknown error loading the theme. Please contact support@pipdig.co.uk so we can check this for you.");
		} else {
			wp_die("This theme must be fully installed and activated before viewing in the Customizer.<br /><br />If you are installing a new theme, please follow the steps in <a href='https://go.pipdig.co/open.php?id=4b9b4nuonrinrgf5dggery' target='_blank' rel='noopener'>this guide</a> (Especially the section at the end of step 2).<br /><br />If you are seeing this error message and you have been using the theme for some time, please complete section 3 of <a href='https://go.pipdig.co/open.php?id=4b9b4nuonrinrgf5dggery22' target='_blank' rel='noopener'>this guide</a>.<br /><br />If you need any help you are welcome to email support@pipdig.co.uk.");
		}
		
	}
	?>

	<?php do_action( 'before' ); ?>
	
	<header class="site-header nopin">
		<div class="clearfix container">
			<div class="site-branding">
		<?php
			$heading_tag = ( is_home() || is_front_page() ) ? 'h1' : 'div';
			if (get_theme_mod('logo_image')) {
		?>
				<<?php echo $heading_tag; ?> class="site-title">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
						<img data-pin-nopin="true" src="<?php echo str_replace('http:', '', esc_url(get_theme_mod('logo_image'))); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" />
					</a>
				</<?php echo $heading_tag; ?>>
			<?php } else { ?>
				<<?php echo $heading_tag; ?> class="site-title">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
						<?php bloginfo( 'name' ); ?>
					</a>
				</<?php echo $heading_tag; ?>>
			<?php } ?>
				<?php if(get_bloginfo('description') && (false == get_theme_mod('hide_tagline'))){ ?><div class="site-description"><?php bloginfo('description'); ?></div><?php } // end if ?>
			</div>
		</div>
	</header><!-- .site-header -->

	<div class="site-top">
		<?php do_action('p3_site_top_start'); ?>
		<div class="clearfix container">
			<nav id="main_menu_under_header" class="site-menu">
				<?php wp_nav_menu( array( 'container_class' => 'clearfix menu-bar', 'theme_location' => 'primary' ) ); ?>
			</nav><!-- .site-menu -->
		</div>
		<?php do_action('p3_site_top_after'); // depreciate and replace with p3_site_top_end below ?>
		<?php do_action('p3_site_top_end'); ?>
	</div><!-- .site-top -->
	
	<?php // ad-area-1 widget was here ?>

	<div class="site-main">
	
		<?php //do_action('p3_top_site_main'); ?>

		<?php
		if (get_theme_mod('header_full_width_slider') ) {
			 if (is_singular() && !get_theme_mod('header_full_width_slider_home')) {
				get_template_part('inc/sliders/singular');
			} elseif ((is_category() || is_tag()) && !get_theme_mod('header_full_width_slider_home') ) {
				get_template_part('inc/sliders/category_tag');
			} elseif (!get_theme_mod('header_full_width_slider_home') || is_front_page() || is_home() ) {
				get_template_part('inc/sliders/home');
			}
		}
		?>
		
			
		<?php if ( is_active_sidebar( 'ad-area-1' ) ) { ?>
			<div id="ad-area-1" class="clearfix container textalign-center">
				<div class="col-xs-12">
					<?php dynamic_sidebar( 'ad-area-1' ); ?>
				</div>
			</div>
		<?php } // end if ?>
		
		<?php do_action('p3_top_site_main'); // move this back to above full width slider.  just moved here for instagram ?>
		
		<div class="clearfix container">
		
			<?php do_action('p3_top_site_main_container'); ?>
			
			<?php if (is_active_sidebar('header-1') && is_front_page()) { ?>
				<div id="header-1-widget-section" class="row">
					<div class="col-xs-12">
						<div class="header-1-bordering">
							<?php dynamic_sidebar( 'header-1' ); ?>
						</div>
					</div>
				</div>
			<?php } ?>