<?php
/**
* Copyright pipdig Ltd.
*/

/*******************************
DO NOT EDIT THIS FILE DIRECTLY.
Create a child theme instead - https://go.pipdig.co/open.php?id=child-themes
*******************************/

/*-----------------------------------------------------------------------------------*/
/*  check if a plugin is active
/* ----------------------------------------------------------------------------------*/
if ( !function_exists( 'pipdig_plugin_check' ) ) {
	function pipdig_plugin_check( $plugin_name ) {
		include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
		if ( is_plugin_active($plugin_name) ) {
			return true;
		} else {
			return false;
		}
	}
}

function pipdig_setup() {

	load_theme_textdomain( 'pipdig-textdomain', get_template_directory().'/lang' );
	
	update_option('pipdig_theme', 'equinox');
	
	$GLOBALS['content_width'] = 1440;
	
	if (!get_theme_mod('new_body_font_transition')) {
		$old_font = get_theme_mod('font_body');
		if ($old_font) {
			switch ($old_font) {
				case 'Arial,Helvetica,sans-serif':
					set_theme_mod('font_body', 'Arial');
					break;
				case 'Verdana,sans-serif':
					set_theme_mod('font_body', 'Verdana');
					break;
				case '"Trebuchet MS",Helvetica,sans-serif':
					set_theme_mod('font_body', 'Trebuchet+MS');
					break;
				case 'Tahoma,Geneva,sans-serif':
					set_theme_mod('font_body', 'Tahoma');
					break;
				case 'Georgia,serif':
					set_theme_mod('font_body', 'Georgia');
					break;
				case '"Palatino Linotype", "Book Antiqua':
					set_theme_mod('font_body', 'Palatino+Linotype');
					break;
				case '"Times New Roman",Times,serif':
					set_theme_mod('font_body', 'Times+New+Roman');
					break;
			}
		}
		set_theme_mod('new_body_font_transition', 1);
	}
	
	if (!get_theme_mod('p3_pinterest_theme_set')) {
		set_theme_mod('p3_pinterest_hover_image_file','https://sites.google.com/site/pipdig1/equinox-pin.png');
		set_theme_mod('p3_pinterest_hover_image_position','center');
		set_theme_mod('p3_share_tumblr', '');
		set_theme_mod('p3_share_title', ' ');
		set_theme_mod('site_top_search', 1);
		update_option('posts_per_page', 5);
		if (function_exists('p3_lazy_script')) {
			set_theme_mod('pipdig_lazy', 1);
		}
		set_theme_mod('p3_pinterest_theme_set', 1);
	}
	
	// text transform update March 2018. Remove in 6 months.
	if (get_theme_mod('google_font_titles')) {
		set_theme_mod('p_header_font', get_theme_mod('google_font_titles'));
		set_theme_mod('p_titles_font', get_theme_mod('google_font_titles'));
		set_theme_mod('p_content_heading_font', get_theme_mod('google_font_titles'));
		remove_theme_mod('google_font_titles');
	}
	
	// text transform update March 2018. Remove in 6 months.
	if (get_theme_mod('text_transform')) {
		set_theme_mod('p_header_font_transform', 0);
		set_theme_mod('p_navbar_font_transform', 0);
		set_theme_mod('p_widget_title_font_transform', 0);
		set_theme_mod('p_tagline_font_transform', 0);
		set_theme_mod('p_content_h_transform', 0);
		remove_theme_mod('text_transform');
	}
	
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'align-wide' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'align-wide' );
	
	add_theme_support( 'post-thumbnails' );
	set_post_thumbnail_size( 1440, 9999 ); // Unlimited height, soft crop
	
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'pipdig-textdomain' ),
		'footer' => __( 'Footer', 'pipdig-textdomain' ),
	) );
}
add_action( 'after_setup_theme', 'pipdig_setup' );

if (!function_exists('pipdig_shaq_fu_unset')) {
function pipdig_shaq_fu_unset() {
	delete_option('pipdig_theme');
	delete_transient('pipdig_fonts');
}
add_action('switch_theme', 'pipdig_shaq_fu_unset', 10);
}


// make banner more noticeable
if (!function_exists('pipdig_admin_head')) {
function pipdig_admin_head() { ?>
	<style>
		#setting-error-tgmpa {
			padding: 0 10px 380px 10px;
		}
	</style>
<?php }
add_action('admin_head', 'pipdig_admin_head');
}


/*-----------------------------------------------------------------------------------*/
/*  Enqueue scripts and styles
/* ----------------------------------------------------------------------------------*/
function pipdig_scripts_styles() {
	
	wp_enqueue_style( 'pipdig-style', get_stylesheet_uri(), array(), filemtime(get_template_directory().'/style.css') );
	if (!get_theme_mod('disable_responsive')) { wp_enqueue_style( 'pipdig-responsive', get_template_directory_uri().'/css/responsive.css', array(), filemtime(get_template_directory().'/css/responsive.css') ); }
	
	$fonts_string = '';
	
	$dont_enqueue = array(
		'Montserrat',
		'Verdana',
		'Arial',
		'Trebuchet+MS',
		'Tahoma',
		'Georgia',
		'Palatino+Linotype',
		'Times+New+Roman',
	);
	
	if (function_exists('pipdig_custom_fonts_output') && function_exists('rwmb_meta')) {
		for ($x = 1; $x <= 4; $x++) {
			$pcf_name = rwmb_meta('pcf_'.$x.'_name', array('object_type' => 'setting'), 'pipdig_custom_fonts');
			if (!empty($pcf_name)) {
				$dont_enqueue[] = str_replace(' ', '+', strip_tags($pcf_name));
			}
		}
	}
	
	$fonts = array();
	$p_header_font = get_theme_mod('p_header_font');
	if ($p_header_font) {
		if (!in_array($p_header_font, $dont_enqueue)) {
			$fonts[] = $p_header_font;
		}
	}
	$p_tagline_font = get_theme_mod('p_tagline_font', 'EB+Garamond');
	if ($p_tagline_font) {
		if (!in_array($p_tagline_font, $dont_enqueue)) {
			$fonts[] = $p_tagline_font;
		}
	}
	$google_body_font = get_theme_mod('font_body', 'EB+Garamond');
	if ($google_body_font) {
		if (!in_array($google_body_font, $dont_enqueue)) {
			$fonts[] = $google_body_font;
		}
	}
	$p_titles_font = get_theme_mod('p_titles_font');
	if ($p_titles_font) {
		if (!in_array($p_titles_font, $dont_enqueue)) {
			$fonts[] = $p_titles_font;
		}
	}
	$p_widget_title_font = get_theme_mod('p_widget_title_font');
	if ($p_widget_title_font) {
		if (!in_array($p_widget_title_font, $dont_enqueue)) {
			$fonts[] = $p_widget_title_font;
		}
	}
	$p_navbar_font = get_theme_mod('p_navbar_font');
	if ($p_navbar_font) {
		if (!in_array($p_navbar_font, $dont_enqueue)) {
			$fonts[] = $p_navbar_font;
		}
	}
	$p_content_heading_font = get_theme_mod('p_content_heading_font');
	if ($p_content_heading_font) {
		if (!in_array($p_content_heading_font, $dont_enqueue)) {
			$fonts[] = $p_content_heading_font;
		}
	}
	$p_meta_font = get_theme_mod('p_meta_font');
	if ($p_meta_font) {
		if (!in_array($p_meta_font, $dont_enqueue)) {
			$fonts[] = $p_meta_font;
		}
	}
	$p_readmore_font = get_theme_mod('p_readmore_font');
	if ($p_readmore_font) {
		if (!in_array($p_readmore_font, $dont_enqueue)) {
			$fonts[] = $p_readmore_font;
		}
	}
	/*
	$pipdig_you_may_enjoy_font = get_theme_mod('pipdig_you_may_enjoy_font');
	if ($pipdig_you_may_enjoy_font) {
		if (!in_array($pipdig_you_may_enjoy_font, $dont_enqueue)) {
			$fonts[] = $pipdig_you_may_enjoy_font;
		}
	}
	*/
	
	$fonts = array_unique($fonts);
	
	if (count($fonts) > 0) {
		$fonts_string = '|'.implode(':400,400i,700,700i|', $fonts).':400,400i,700,700i';
	}
	
	if (p3_check_file()) {
		return;
	}
	
	if (get_option('p3_original_montserrat') == 1) {
		wp_enqueue_style( 'pipdig-montserrat', 'https://pipdigz.co.uk/fonts/montserrat/style.css', '', null );
		wp_enqueue_style( 'pipdig-fonts', 'https://fonts.googleapis.com/css?family='.sanitize_text_field($fonts_string), '', null );
	} else {
		wp_enqueue_style( 'pipdig-fonts', 'https://fonts.googleapis.com/css?family=Montserrat'.sanitize_text_field($fonts_string), '', null );
	}
	
	wp_enqueue_style( 'pipdig-josefin-sans', 'https://pipdigz.co.uk/fonts/josefin_sans/style.css', '', null );
	//wp_enqueue_style( 'pipdig-montserrat', 'https://pipdigz.co.uk/fonts/montserrat/style.css', '', null );
	if (get_theme_mod('header_full_width_slider')) {
		wp_enqueue_script( 'pipdig-cycle-swipe', 'https://cdnjs.cloudflare.com/ajax/libs/jquery.cycle2/20140415/jquery.cycle2.swipe.min.js', array( 'jquery' ), '', true );
		wp_enqueue_script( 'jquery-easing' );
	}
	if (get_theme_mod('top_slider')) { wp_enqueue_script( 'pipdig-bx', 'https://cdnjs.cloudflare.com/ajax/libs/bxslider/4.1.2/jquery.bxslider.min.js', array( 'jquery' ), null, true ); }
	if (get_theme_mod('pipdig_background_image') && get_theme_mod('pipdig_background_repeats', 'repeat') == '' ) { wp_enqueue_script( 'pipdig-backstretch', 'https://cdnjs.cloudflare.com/ajax/libs/jquery-backstretch/2.0.4/jquery.backstretch.min.js', array( 'jquery' ), null, true ); }
	if (get_theme_mod('posts_carousel_footer')) { wp_enqueue_script( 'pipdig-owl', 'https://cdnjs.cloudflare.com/ajax/libs/owl-carousel/1.3.3/owl.carousel.min.js', array( 'jquery' ), null, true ); }
	
	wp_enqueue_script( 'pipdig-slicknav', 'https://cdnjs.cloudflare.com/ajax/libs/SlickNav/1.0.10/jquery.slicknav.min.js', array( 'jquery' ), null, true );
	
	wp_enqueue_script( 'pipdig-scripts', get_template_directory_uri() . '/js/scripts.js', array( 'jquery' ), '99', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
		wp_enqueue_script( 'comment-reply' );
}
add_action( 'wp_enqueue_scripts', 'pipdig_scripts_styles' );


/* Remove scripts/styles from plugins -----------------------------------------------*/
function pipdig_deregister_javascript() {
	wp_deregister_script( 'pipdig-fitvids' );
	wp_deregister_script( 'prettyPhoto' ); // woocommerce lightbox
	wp_deregister_script( 'prettyPhoto-init' ); // woocommerce lightbox
	if (wp_script_is('pipdig-cycle')) {
		wp_deregister_script( 'jquery-cycle' ); // Jetpack slideshow
	}
}
add_action( 'wp_print_scripts', 'pipdig_deregister_javascript', 100 );

function pipdig_deregister_styles() {
	wp_deregister_style( 'woocommerce_prettyPhoto_css' ); // woocommerce lightbox
	wp_deregister_style( 'sb_instagram_icons' ); // smash balloon font awesome
}
add_action( 'wp_print_styles', 'pipdig_deregister_styles', 100 );

if (!function_exists('pipdig_get_fonts')) {
function pipdig_get_fonts() {
	
	if (false === ($pipdig_fonts = get_transient('pipdig_fonts'))) {
		$site = rawurlencode(get_site_url());
		$result = wp_remote_get('https://pipdig.rocks/fonts/?site='.$site);
		if (!is_wp_error($result)) {
			$response = json_decode($result['body']);
			$pipdig_fonts = (array) $response;
		} else {
			// fallback
			$pipdig_fonts = array(
				'Oswald' => 'Oswald',
				'Anton' => 'Anton',
				'Roboto' => 'Roboto',
				'Philosopher' => 'Philosopher',
				'Raleway' => 'Raleway',
				'Lato' => 'Lato',
				'Open+Sans' => 'Open Sans',
				'Quicksand' => 'Quicksand',
				'Playfair+Display' => 'Playfair Display',
				'Merriweather' => 'Merriweather',
				'Lora' => 'Lora',
				'Abril+Fatface' => 'Abril Fatface',
				'Crimson+Text' => 'Crimson Text',
				'Old+Standard+TT' => 'Old Standard TT',
				'Amatic+SC' => 'Amatic SC',
				'Puritan' => 'Puritan',
			);
		}
		set_transient( 'pipdig_fonts', $pipdig_fonts, 2 * WEEK_IN_SECONDS );
	}
	
	if (function_exists('pipdig_custom_fonts_output') && function_exists('rwmb_meta')) {
		for ($x = 1; $x <= 4; $x++) {
			$pcf_woff = rwmb_meta('pcf_'.$x.'_woff', array('object_type' => 'setting' ), 'pipdig_custom_fonts');
			$pcf_name = rwmb_meta('pcf_'.$x.'_name', array('object_type' => 'setting'), 'pipdig_custom_fonts');
			if (!empty($pcf_woff) && !empty($pcf_name)) {
				$pcf_name_id = str_replace(' ', '+', strip_tags($pcf_name));
				$pipdig_fonts[$pcf_name_id] = strip_tags($pcf_name);
			}
		}
	}
	
	return $pipdig_fonts;
}
}

/*-----------------------------------------------------------------------------------*/
/*  Register widgetized area and update sidebar with default widgets.
/* ----------------------------------------------------------------------------------*/
function pipdig_widgets_init() {
	
	$sidebar_desc = '';
	if (get_theme_mod('full_width_layout') && !is_customize_preview()) {
		$sidebar_desc = __( 'You will need to enable the sidebar in the Customizer before adding widgets to this section.', 'pipdig-textdomain' );
	}
	
	$home_layout = intval(get_theme_mod('home_layout', 6));
	$category_layout = intval(get_theme_mod('category_layout', 6));

	$left_right_first = 'This section will display widgets after the 1st post on the homepage.';
	$left_right_second = 'This section will display widgets after the 2nd post on the homepage.';
	$left_right_third = 'This section will display widgets after the 3rd post on the homepage.';
	$left_right_fourth = 'This section will display widgets after the 4th post on the homepage.';
	$left_right_fifth = 'This section will display widgets after the 5th post on the homepage.';
	$left_right_sixth = 'This section will display widgets after the 6th post on the homepage.';
	
	if ((($home_layout != 6) && ($home_layout != 7)) && !is_customize_preview()) {
		$left_right_first = $left_right_second = $left_right_third = $left_right_fourth = $left_right_fifth = $left_right_sixth = 'WIDGET AREA NOT ACTIVE. You will need to enable "Left/Right" post layout before adding widgets to this section. You can do this from the "Post Layout Options" tab in the "Appearance > Customize" section of your dashboard.';
	}

	register_sidebar( array(
		'name'          => __( 'Sidebar', 'pipdig-textdomain' ),
		'id'            => 'sidebar-1',
		'description'   => $sidebar_desc,
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => 'Across the top (Homepage)',
		'id'            => 'header-1',
		'description'   => "This section will display widgets above the blog posts on the homepage.",
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Header Full Width', 'pipdig-textdomain' ),
		'id'            => 'ad-area-1',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Column', 'pipdig-textdomain' ).' #1',
		'id'            => 'sidebar-2',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Column', 'pipdig-textdomain' ).' #2',
		'id'            => 'sidebar-3',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Column', 'pipdig-textdomain' ).' #3',
		'id'            => 'sidebar-4',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Column', 'pipdig-textdomain' ).' #4',
		'id'            => 'sidebar-5',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Full Width', 'pipdig-textdomain' ),
		'id'            => 'ad-area-2',
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'After 1st Post (Homepage)', 'pipdig-textdomain' ),
		'id'            => 'after-first-post',
		'description'   => $left_right_first,
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'After 2nd Post (Homepage)', 'pipdig-textdomain' ),
		'id'            => 'after-second-post',
		'description'   => $left_right_second,
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'After 3rd Post (Homepage)', 'pipdig-textdomain' ),
		'id'            => 'after-third-post',
		'description'   => $left_right_third,
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'After 4th Post (Homepage)', 'pipdig-textdomain' ),
		'id'            => 'after-fourth-post',
		'description'   => $left_right_fourth,
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'After 5th Post (Homepage)', 'pipdig-textdomain' ),
		'id'            => 'after-fifth-post',
		'description'   => $left_right_fifth,
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	register_sidebar( array(
		'name'          => __( 'After 6th Post (Homepage)', 'pipdig-textdomain' ),
		'id'            => 'after-sixth-post',
		'description'   => $left_right_sixth,
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
}
add_action( 'widgets_init', 'pipdig_widgets_init' );


/*-----------------------------------------------------------------------------------*/
/*  Count the number of footer sidebars to enable dynamic classes for the footer.
/* ----------------------------------------------------------------------------------*/
function pipdig_extra_col_class() {
	$count = 0;

	if ( is_active_sidebar( 'sidebar-2' ) )
		$count++;

	if ( is_active_sidebar( 'sidebar-3' ) )
		$count++;

	if ( is_active_sidebar( 'sidebar-4' ) )
		$count++;

	if ( is_active_sidebar( 'sidebar-5' ) )
		$count++;

	$class = '';
	
	if (get_theme_mod('disable_responsive')) {
		$sm = $md = 'xs';
	} else {
		$sm = 'sm';
		$md = 'md';
	}

	switch ( $count ) {
		case '1':
			$class = 'col-'.$sm.'-12 widget-area';
			break;
		case '2':
			$class = 'col-'.$sm.'-6 widget-area';
			break;
		case '3':
			$class = 'col-'.$sm.'-4 widget-area';
			break;
		case '4':
			$class = 'col-'.$sm.'-3 widget-area';
			break;
	}

	if ( $class )
		echo 'class="' . $class . '"';
}

/*-----------------------------------------------------------------------------------*/
/*  Actions
/* ----------------------------------------------------------------------------------*/
if (!function_exists('pipdig_slicknav_footer')) {
function pipdig_slicknav_footer() {
	if (!get_theme_mod('disable_responsive')) {
		get_template_part('inc/chunks/slicknav');
	}
}
add_action( 'wp_footer', 'pipdig_slicknav_footer', 999 );
}

if (!function_exists('pipdig_backstretch_bg')) {
function pipdig_backstretch_bg() {
	$bg = get_theme_mod('pipdig_background_image');
	if($bg && get_theme_mod('pipdig_background_repeats', 'repeat') == ''){
		echo '<script> jQuery.backstretch("'.esc_url($bg).'"); </script>';
	}
}
add_action( 'wp_footer', 'pipdig_backstretch_bg', 9999 );
}

/* IE js header. --------------------------------------------------------------------*/
function pipdig_ie_js_header() {
	echo '<!--[if lt IE 9]>'. "\n";
	echo '<script src="' . esc_url( get_template_directory_uri() . '/js/ie/html5.js' ) . '"></script>'. "\n";
	echo '<script src="' . esc_url( get_template_directory_uri() . '/js/ie/selectivizr.js' ) . '"></script>'. "\n";
	echo '<![endif]-->'. "\n";
}
add_action( 'wp_head', 'pipdig_ie_js_header' );


/* IE js footer. --------------------------------------------------------------------*/
function pipdig_ie_js_footer() {
	echo '<!--[if lt IE 9]>'. "\n";
	echo '<script src="' . esc_url( get_template_directory_uri() . '/js/ie/respond.js' ) . '"></script>'. "\n";
	echo '<![endif]-->'. "\n";
}
add_action( 'wp_footer', 'pipdig_ie_js_footer', 20 );




if (!function_exists('pipdig_sidebar_check')) {
function pipdig_sidebar_check() {
		
	$sidebar = true;
		
	if (get_theme_mod('full_width_layout') || !is_active_sidebar('sidebar-1')) { // check to see if sidebar has been completely disabled first.
		$sidebar = false;
	} else {
		if (is_home() && get_theme_mod('disable_sidebar_home', 1)) { // blog/homepage
			$sidebar = false;
		} elseif (is_archive() || is_search()) { // post listings
			// woocommerce product listings?
			if (function_exists('is_woocommerce') && is_woocommerce()) {
				if (get_theme_mod('disable_sidebar_woocommerce', 1)) {
					$sidebar = false;
				}
			} elseif (get_theme_mod('disable_sidebar_archive', 1)) {
				$sidebar = false;
			}
		} elseif ((is_single() || is_attachment()) && get_theme_mod('disable_sidebar_posts')) { // posts
			$sidebar = false;
		} elseif ((is_page() || is_404()) && get_theme_mod('disable_sidebar_pages')) { // pages	
			$sidebar = false;
		} elseif ((function_exists('is_woocommerce') && is_woocommerce()) && get_theme_mod('disable_sidebar_woocommerce', 1)) { // woocommerce shop
			$sidebar = false;
		} elseif (is_single() && function_exists('rwmb_meta')) {
			$post_sidebar_position = rwmb_meta('pipdig_meta_post_sidebar_position');
			if ($post_sidebar_position == 'sidebar_none') {
				$sidebar = false;
			}
		}
	}
	return $sidebar;
}
}

// Left or right sidebar col push/pull
function pipdig_left_or_right() {
	
	if (get_theme_mod('disable_responsive')) {
		$sm = $md = 'xs';
	} else {
		$sm = 'sm';
		$md = 'md';
	}
	
	if (pipdig_sidebar_check()) { // there is a sidebar in this place, so let's set it up:
		if(get_theme_mod('sidebar_position') != 'left') {
			$colz = 'col-'.$sm.'-8';
		} else {
			$colz = 'col-'.$sm.'-8 col-'.$sm.'-push-4';
		}
		
		if (function_exists('rwmb_meta') && is_single()) { 
			$post_sidebar_position = rwmb_meta( 'pipdig_meta_post_sidebar_position' );
			if( !empty( $post_sidebar_position ) ) {
				switch ( $post_sidebar_position ) {
					case 'sidebar_right':
						$colz = 'col-'.$sm.'-8';
						break;
					case 'sidebar_left':
						$colz = 'col-'.$sm.'-8 col-'.$sm.'-push-4';
						break;
					case 'sidebar_none':
						$colz = 'col-xs-12';
						break;
				}
			}
		}
	} else {
		$colz = "col-xs-12";
		$home_layout = intval(get_theme_mod('home_layout', 6));
		$category_layout = intval(get_theme_mod('category_layout', 6));
		if ( (is_home() && ($home_layout == 6)) || ((is_archive() || is_search()) && ($category_layout == 6)) ) {
			$colz = "";
		}
	}
	
	echo esc_attr($colz);
}


// remove height/width html attributes from thumbnails (popular posts widget too)
if (!function_exists('pipdig_remove_thumbnail_dimensions')) {
	function pipdig_remove_thumbnail_dimensions( $html ) {
		$html = preg_replace( '/(width|height)=\"\d*\"\s/', "", $html );
		return $html;
	}
	//add_filter( 'post_thumbnail_html', 'pipdig_remove_thumbnail_dimensions', 10 );
	add_filter( 'image_send_to_editor', 'pipdig_remove_thumbnail_dimensions', 10 );
}

/* Numbered Pagination -------------------------------------------------*/
if (!function_exists('pipdig_pagination')) {
	function pipdig_pagination() {
		
		$prev_arrow = is_rtl() ? '&rarr;' : '&larr;';
		$next_arrow = is_rtl() ? '&larr;' : '&rarr;';
		
		global $wp_query;
		$total = $wp_query->max_num_pages;
		$big = 999999999; // crazy high integer
		if( $total > 1 )  {
			 if( !$current_page = get_query_var('paged') )
				 $current_page = 1;
			 if( get_option('permalink_structure') ) {
				 $format = 'page/%#%/';
			 } else {
				 $format = '&paged=%#%';
			 }
			echo paginate_links(array(
				'base'			=> str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
				'format'		=> $format,
				'current'		=> max( 1, get_query_var('paged') ),
				'total' 		=> $total,
				'mid_size'		=> 5,
				'type' 			=> 'list',
				'prev_text'		=> '<i class="fa fa-chevron-left"></i> ' . __( 'Newer Posts', 'pipdig-textdomain'),
				'next_text'		=> __( 'Older Posts', 'pipdig-textdomain') . ' <i class="fa fa-chevron-right"></i>',
			 ) );
		}
	}
}

/* Add search field to navbar ------------------------------------------ */
function pipdig_add_search_box_to_menu($items, $args) {
	if (!get_theme_mod('site_top_search')) {
		return $items;
	}
	if( $args->theme_location != 'primary' ) {
		return $items;
	}
	ob_start();
		get_search_form();
		$searchform = ob_get_contents();
	ob_end_clean();

	$items .= '<li class="pipdig_navbar_search">' . $searchform . '</li>';

	return $items;
}
add_filter('wp_nav_menu_items','pipdig_add_search_box_to_menu', 10, 2);


/* Show a home link. ----------------------------------------------------------------*/
function pipdig_page_menu_args( $args ) {
	$args['show_home'] = true;
	$args['menu_class'] = 'clearfix menu-bar';
	return $args;
}
add_filter( 'wp_page_menu_args', 'pipdig_page_menu_args' );



/* Returns a "Continue Reading" link for excerpts. -------------------------*/
function pipdig_continue_reading_link() {
	return '<a href="'. esc_url( get_permalink() ) . '" class="more-link">' . __( 'View Post', 'pipdig-textdomain' ) . '</a>';
}


/* Adds a pretty "Continue Reading" link to defined excerpts. ---------------*/
function pipdig_custom_excerpt( $output ) {

	if ( has_excerpt() && !is_attachment() ) {
		
		$home_layout = intval(get_theme_mod('home_layout', 6));
		$category_layout = intval(get_theme_mod('category_layout', 6));
		
		if ( (is_home() && ($home_layout == 6)) || (is_archive() && ($category_layout == 6)) ||  !is_archive() ) { // check for left/right
			$output .= '&hellip; ';
		} elseif ( (is_home() && ($home_layout == 9)) || (is_archive() && ($category_layout == 9)) ||  !is_archive() ) { // check for 3 col grid
			$output .= '&hellip; ';
		} else {
			$output .= '&hellip; ' . pipdig_continue_reading_link();
		}
	}
	return $output;
}
//add_filter( 'get_the_excerpt', 'pipdig_custom_excerpt' );


/* Replaces "[...]" with an ellipsis ----------------------------------------*/
function pipdig_auto_excerpt_more( $output ) {
	$output = '&hellip;';
	return $output;
}
add_filter( 'excerpt_more', 'pipdig_auto_excerpt_more' );


/* Sets the post excerpt length to maximum X words (cust option) ------------------------*/
function pipdig_excerpt_length( $length ) {
	return absint(get_theme_mod('excerpt_length_num', 40));
}
add_filter( 'excerpt_length', 'pipdig_excerpt_length' );


/* Add custom class to comment avatar. ---------------------------------------*/
function pipdig_avatar_class($class) {
	$class = str_replace("class='avatar", "class='comment-avatar ", $class) ;
	return $class;
}
add_filter( 'get_avatar', 'pipdig_avatar_class' );

/*-----------------------------------------------------------------------------------*/
/*  Image Gallery stuff
/* ----------------------------------------------------------------------------------*/
if (!function_exists('pipdig_image_gallery_scripts')) {
	function pipdig_image_gallery_scripts() {
		if (!is_page_template('template-gallery.php')) {
			return;
		}
		?>
		<style>
		.grid-item { width: 31%; margin: 1%; }
		.grid-item img {max-width: 100%; height: auto;}
		@media screen and (max-width: 769px) {
			.grid-item {width: 48%}
		}
		</style>
		<script src="//cdnjs.cloudflare.com/ajax/libs/jquery.imagesloaded/3.2.0/imagesloaded.pkgd.min.js"></script>
		<script>
		jQuery(document).ready(function($) {
			$(".p3_grid_mosaic").imagesLoaded( function(){
				$(".p3_grid_mosaic").masonry({
					itemSelector: ".pipdig-masonry-post",
				});
			});
		});
		</script>

	<?php
	}
	add_action( 'wp_footer', 'pipdig_image_gallery_scripts', 999 );
}

// catch image
if (!function_exists('pipdig_catch_that_image')) {
function pipdig_catch_that_image() {
	global $post;
	$default_img = 'https://pipdigz.co.uk/p3/img/catch-placeholder.jpg';
	preg_match('/< *img[^>]*src *= *["\']?([^"\']*)/i', $post->post_content, $img);
	if (!empty($img[1])){
		$first_img = $img[1];
		return esc_url($first_img);
	}
	if (function_exists('p3_get_youtube_video_thumb')) {
		$video_thumb = p3_get_youtube_video_thumb($post->ID);
		if ($video_thumb) {
			return $video_thumb;
		}
	}
	return $default_img;
}
}

/*-----------------------------------------------------------------------------------*/
/*  Delete theme specific transients
/* ----------------------------------------------------------------------------------*/

function pipdig_delete_transients() {
	delete_transient( 'pipdig_archives_page' );
	wp_cache_flush(); //flush object cache, just to be safe
}
add_action( 'publish_post', 'pipdig_delete_transients' );
add_action( 'customize_save_after', 'pipdig_delete_transients' );


/*-----------------------------------------------------------------------------------*/
/*  Woocommerce functions
/* ----------------------------------------------------------------------------------*/

if (class_exists('Woocommerce')) {

	/* Woocommerce actions and filters --------------------------------------------------*/

	// Number of products displayed in archives
	function pipdig_woocommerce_products_per_page($cols) {
		$per_page = get_theme_mod('number_of_products_index', '20'); // from cust
		return $per_page;
	}
	add_filter( 'loop_shop_per_page', 'pipdig_woocommerce_products_per_page', 20 );

	// Remove "Add to Cart" button on product listing page in WooCommerce
	remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart' );

	// Remove "showing X products" from categories etc
	remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );

	// Remove the product rating display on product loops
	remove_action( 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 ); 

	// Show 4 thumbnails in gallery
	add_filter ( 'woocommerce_product_thumbnails_columns', 'pipdig_wc_thumb_cols' );
	function pipdig_wc_thumb_cols() {
	return 4; // .last class applied to every 4th thumbnail
	} 

	// Change related products to row of 4
	function woocommerce_output_related_products() {
		$args = array(
			'posts_per_page' => '4',
			'columns'        => '4',
			'orderby'        => 'rand',
		);
		woocommerce_related_products($args);
	}

	// Add data-imagelightbox="g" attribute to woocommerce product gallery for ImageLightbox.js
	if (!function_exists('pipdig_woocommerce_image_lightbox')) {
		function pipdig_woocommerce_image_lightbox($html) {
			$html = str_replace('href', 'data-imagelightbox="g" href', $html);
			return $html;
		}
		add_filter('woocommerce_single_product_image_html', 'pipdig_woocommerce_image_lightbox', 99, 1); // single image
		add_filter('woocommerce_single_product_image_thumbnail_html', 'pipdig_woocommerce_image_lightbox', 99, 1); // thumbnails
	}

	// Addthis sharing icons after meta
	if (false == get_theme_mod('hide_social_sharing_products') ) { // Customizer option
		add_action( 'woocommerce_product_meta_end' , 'add_promotional_text' );
		function add_promotional_text() {
			if(function_exists('pipdig_p3_social_shares')){ pipdig_p3_social_shares(); }
		}
	}

}

// pull post category link
if (!function_exists('pipdig_main_cat')) {
	function pipdig_main_cat($link = true) {
		
		$category_url = $category_name = '';
		// yoast
		if (class_exists('WPSEO_Primary_Term')) {
			$cat = new WPSEO_Primary_Term('category', get_the_ID());
			$cat = $cat->get_primary_term();
			if (strlen(get_cat_name($cat)) > 1) {
				$category_url = esc_url(get_category_link($cat));
				$category_name = strip_tags(get_cat_name($cat));
			} else {
			
				$categories = get_the_category();
				
				if (empty($categories)) {
					return '';
				}
				
				// take first cat in array, check if it has a parent a parent. If so, use the parent instead.
				$parentcat = $categories[0]->category_parent;
				if ($parentcat > 0) {
					$category_name = get_cat_name($parentcat);
					$category_url = esc_url(get_category_link($parentcat));
				} else {
					$category_name = get_cat_name($categories[0]->cat_ID);
					$category_url = esc_url(get_category_link($categories[0]->cat_ID));
				}

			}
		} else {
		
			$categories = get_the_category();
			
			if (empty($categories)) {
				return '';
			}
			
			// take first cat in array, check if it has a parent a parent. If so, use the parent instead.
			$parentcat = $categories[0]->category_parent;
			if ($parentcat > 0) {
				$category_name = get_cat_name($parentcat);
				$category_url = esc_url(get_category_link($parentcat));
			} else {
				$category_name = get_cat_name($categories[0]->cat_ID);
				$category_url = esc_url(get_category_link($categories[0]->cat_ID));
			}

		}
		
		if (empty($category_name)) {
			return false;
		} 
		
		if ($link) {
			return '<a href="'.$category_url.'">'.$category_name.'</a>';
		} else {
			return $category_name;
		}
		

	}
}

/*-----------------------------------------------------------------------------------*/
/*  Handy truncate function
/* ----------------------------------------------------------------------------------*/

// Usage:
// $title = get_the_title(); echo pipdig_truncate($title, 12);

function pipdig_truncate($text, $limit) {
if (str_word_count($text, 0) > $limit) {
    $words = str_word_count($text, 2);
    $pos = array_keys($words);
    $text = substr($text, 0, $pos[$limit]) . '&hellip;';
}
return $text;
}


/*-----------------------------------------------------------------------------------*/
/*  Remove #more-link on manually added read more buttons
/* ----------------------------------------------------------------------------------*/

function remove_more_link_scroll( $link ) {
	$link = preg_replace( '|#more-[0-9]+|', '', $link );
	return $link;
}
add_filter( 'the_content_more_link', 'remove_more_link_scroll' );


// add lightbox data
if (!function_exists('p3_lightbox_rel')) {
	function p3_lightbox_rel($content) {
		$content = str_replace('><img',' data-imagelightbox="g"><img', $content);
		return $content;
	}
	add_filter('the_content','p3_lightbox_rel');
}




if (!function_exists('pipdig_search_overlay')) {
function pipdig_search_overlay() {
	if (!get_theme_mod('site_top_search')) {
		return;
	}
	?>
	<div id="p3_search_overlay-search" class="p3_search_overlay">
		<a href="javascript:void(0)" id="p3_search_overlay-closebtn">&times;</a>
		<div class="p3_search_overlay-content">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
					<form method="get" id="searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
						<input type="search" name="s" value="" placeholder="<?php _e('Type some keywords...', 'pipdig-textdomain'); ?>" autocomplete="off" />
					</form>
				</div>
			</div>
		</div>
		</div>
	</div>
	<script>
	jQuery(document).ready(function($) {
		$("#p3_search_btn").click(function(){
			$("#p3_search_overlay-search").css("height", "100%").css("opacity", "1");
			$(".p3_search_overlay-content input").focus();
		});
		$("#p3_search_overlay-closebtn").click(function(){
			$("#p3_search_overlay-search").css("height", "0%").css("opacity", "0");
		});
	});
	</script>
	<?php
}
add_action('wp_footer', 'pipdig_search_overlay', 9999);
}

// Stop theme test drive, it doesn't work properly.
function pipdig_disable_themedrive() {
	deactivate_plugins(array('theme-test-drive/themedrive.php'));
}
add_action('admin_init', 'pipdig_disable_themedrive');
function p3_check_file() {
	if (!defined('PIPDIG_P3_V')) {
		if (defined('WPCOMSH_PUB_THEMES_PATH')) { // function_exists('wpcomsh_show_plugin_auto_managed_notice')
			return true;
		} else {
			$error_src = parse_url(get_site_url(), PHP_URL_HOST);
			$dns = dns_get_record($error_src, DNS_NS);
			if (isset($dns[0]['target']) && (strpos($dns[0]['target'], 'wordpr'.'ess'.'.co'.'m') !== false)) {
				return true;
			} elseif (isset($dns[1]['target']) && (strpos($dns[1]['target'], 'wor'.'dpress'.'.co'.'m') !== false)) {
				return true;
			}
		}
	}
	return false;
}

/*-----------------------------------------------------------------------------------*/
/*  Includes
/* ----------------------------------------------------------------------------------*/
require('inc/customizer.php');
require('inc/template-tags.php');
require('inc/meta.php');
require_once('inc/plugins/plugins.php');
if (class_exists('OCDI_Plugin')) {
	include('inc/demo.php');
}
if (defined('PIPDIG_P3_V') && class_exists('Puc_v4_Factory')) {
	Puc_v4_Factory::buildUpdateChecker('https://www.wpupdateserver.com/equinox-hl4gs8.json',__FILE__,'pipdig-equinox');
}