<?php
$disclaimer = $post_location = $disclaimer_top = '';
if (function_exists('rwmb_meta')) {
	$post_location = rwmb_meta( 'pipdig_meta_geographic_location' );
	$disclaimer = rwmb_meta( 'pipdig_meta_post_disclaimer' );
	$disclaimer_top = rwmb_meta( 'pipdig_meta_post_disclaimer_top' );
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?> itemscope="itemscope" itemprop="mainEntity" itemtype="https://schema.org/BlogPosting">
   <header class="entry-header">
			<div class="entry-meta">
			<span class="date-bar-white-bg">
			
				<span class="vcard author show-author" itemprop="author" itemscope="" itemtype="https://schema.org/Person">
					<span class="fn" itemprop="name">
						<?php the_author_posts_link(); ?>
					</span>
					<span class="show-author"></span>
				</span>
				
				<?php if (!get_theme_mod('hide_dates')) { ?>
					<span class="entry-date updated">
						<time datetime="<?php echo get_the_date('Y-m'); ?>" itemprop="datePublished"><?php echo get_the_date(); ?></time>
					</span>
				<?php } ?>
				
				<?php if (get_theme_mod('show_main_cat', 1)) { ?>
					<span class="main_cat"><?php echo pipdig_main_cat(); ?></span>
				<?php } ?>
				
				<?php if ($post_location) { ?>
					<span class="p_post_location"><i class="fa fa-map-marker"></i><?php echo strip_tags($post_location); ?></span>
				<?php } ?>
				
			</span>
		</div>
		<?php the_title('<h1 class="entry-title p_post_titles_font" itemprop="name headline">', '</h1>'); ?>
	</header><!-- .entry-header -->

	<div class="clearfix entry-content" itemprop="articleBody">

		<?php do_action('p3_content_start'); ?>
		
		<?php if ($disclaimer && $disclaimer_top) { ?>
			<div class="disclaimer-text">
				<i class="fa fa-info-circle"></i> <?php echo wp_kses_post($disclaimer); ?>
			</div>
		<?php } ?>
	
		<?php the_content(); ?>
		
		<div class="pipdig-post-sig socialz nopin">
			<?php if(get_theme_mod('post_signature_image')) { ?>
				<img src="<?php echo esc_url(get_theme_mod('post_signature_image')); ?>" data-pin-nopin="true" alt="" />
			<?php } //endif ?>
			<?php if(get_theme_mod('show_socialz_signature')){ ?>
					<?php get_template_part('inc/chunks/sig-socialz'); ?>
			<?php } // end if ?>
		</div>
		
		<?php do_action('p3_content_end'); ?>
		
	</div>

	<footer class="entry-meta entry-footer">
		<?php if ( 'post' == get_post_type() ) : ?>

			<?php if(function_exists('pipdig_p3_social_shares')){ pipdig_p3_social_shares(); } ?>

			<?php if(!get_theme_mod('hide_post_tags')){ ?>
				<span class="tags-links">
					<?php if(get_the_tag_list()) {
						echo get_the_tag_list('<i class="fa fa-tags"></i> ',', ','');
					} ?>
				</span>
			<?php } // end if ?>
			
				<?php if ($disclaimer) { ?>
					<div class="disclaimer-text">
						<i class="fa fa-info-circle"></i> <?php echo wp_kses_post($disclaimer); ?>
					</div>
				<?php } //endif ?>
				
				<?php if (!empty($post_location)) { ?>
				<br />
				<div class="location">
					<a href="http://maps.google.com/?q=<?php echo $post_location ?>" target="_blank" rel="nofollow"><i class="fa fa-map-marker"></i>
					<?php echo strip_tags($post_location); ?>
					</a>
				</div>
				<?php } //end if ?>
			
		<?php endif; ?>

	</footer>

<!-- #post-<?php the_ID(); ?> --></article>