<?php
$sm = 'sm';
if (get_theme_mod('disable_responsive')) {
	$sm = 'xs';
}

$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'p3_medium' );
if ($thumb){
	$bg = esc_url($thumb['0']);
} else {
	$bg = pipdig_catch_that_image();
}

?>

<div id="post-<?php the_ID(); ?>" class="col-<?php echo $sm; ?>-4 pipdig_3_col_grid_item" itemprop="blogPost" itemscope="itemscope" itemtype="https://schema.org/BlogPosting">
	
		<?php if (get_theme_mod('pipdig_lazy')) { ?>
			<a href="<?php the_permalink() ?>" class="p3_cover_me pipdig_lazy" data-src="<?php echo $bg; ?>">
		<?php } else { ?>
			<a href="<?php the_permalink() ?>" class="p3_cover_me" style="background-image:url(<?php echo $bg; ?>);">
		<?php } ?>
		<div class="post-listing-img nopin" style="background-image:url(<?php echo $bg; ?>);">
			<?php if (!is_category() && !get_theme_mod('hide_dates')) { ?>
				<div class="left-right-date pipdig_meta"><time datetime="<?php echo get_the_date('Y-m'); ?>" itemprop="datePublished"><?php echo get_the_date(); ?></time></div>
			<?php } ?>
			<img class="p3_invisible" src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAfQAAAH0AQMAAADxGE3JAAAAA1BMVEUAAACnej3aAAAAAXRSTlMAQObYZgAAADVJREFUeNrtwTEBAAAAwiD7p/ZZDGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOX0AAAEidG8rAAAAAElFTkSuQmCC" alt="" data-pin-nopin="true" />
		</div>
	</a>
		
	<div class="pipdig_3_col_grid_info">
		
	<div class="entry-meta entry-line" style="display:none">
		<span class="date-bar-white-bg"><span class="vcard author show-author"><span class="fn" itemprop="name"><?php the_author_posts_link(); ?></span><span class="show-author"> / </span></span><span class="entry-date updated"><time datetime="<?php echo get_the_date('Y-m'); ?>" itemprop="datePublished"><?php echo get_the_date(); ?></time></span></span>
	</div>
		
	<?php
	$geo_tag = $category = '';
	
	if (get_theme_mod('show_main_cat', 1)) {
		$category = pipdig_main_cat();
	}
	
	$tugger ='';
	if (!get_theme_mod('hide_dates')) {
		$tugger = '<time datetime="'.get_the_date('Y-m').'" itemprop="datePublished">'.get_the_date().'</time>';
	}
	if (function_exists('rwmb_meta')) {
		$geo_tag = esc_html(rwmb_meta('pipdig_meta_geographic_location'));
		if (!empty($geo_tag)) {
			$tugger = $geo_tag;
		} elseif (!is_category() && $category) {
			$tugger = $category;
		}
	} elseif (!is_category() && $category) {
		$tugger = $category;
	}
	?>

	<div class="pipdig_geo_tag pipdig_meta">
		<?php if($geo_tag) { ?>
			<i class="fa fa-map-marker"></i>
		<?php } ?>
		<span <?php if ($geo_tag) echo 'style="top:-20px"'; ?>>
		<?php echo $tugger; ?>
		</span>
	</div>
		
	<h2 class="entry-title p_post_titles_font" itemprop="headline"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php echo pipdig_truncate(get_the_title(), get_theme_mod('post_title_length_limit', 7)) ?></a></h2>
	
	<?php
	if ((get_theme_mod('grid_excerpts', 1)) && (get_theme_mod('excerpt_length_num', 40) !== 0)) {
		the_excerpt();
	}
	?>
	
	<?php if(!get_theme_mod('hide_comments_link')){ ?>
		<div class="listing-comments pipdig_meta"><a href="<?php the_permalink(); ?>" data-disqus-url="<?php the_permalink(); ?>"><i class="fa fa-comments"></i> <?php echo get_comments_number(); ?> <?php _e('Comments', 'pipdig-textdomain'); ?></a></div>
	<?php } ?>
	</div>
	
	<?php if (function_exists('p3_schema_publisher')) p3_schema_publisher(); ?>
	
</div><!-- #post-<?php the_ID(); ?> -->

<?php

$this_post = $wp_query->current_post;

if ($this_post == 2 || $this_post == 5 || $this_post == 8 || $this_post == 11 || $this_post == 14 || $this_post == 17 || $this_post == 20 || $this_post == 23 || $this_post == 26 || $this_post == 29) {
	?><div class="pipdig_3_col_grid_breaker clearfix"></div><?php
}