<?php
if (!defined('ABSPATH')) die;

// Filter Functions with Hooks
function shopr_mce_button() {
	// Check if user have permission
	if ( !current_user_can('edit_posts') && !current_user_can('edit_pages') ) {
		return;
	}
	// Check if WYSIWYG is enabled
	if ( get_user_option('rich_editing') == true ) {
		add_filter( 'mce_external_plugins', 'shopr_tinymce_plugin' );
		add_filter( 'mce_buttons', 'shopr_register_mce_button' );
	}
}
add_action('admin_head', 'shopr_mce_button');

// Function for new button
function shopr_tinymce_plugin( $plugin_array ) {
	$plugin_array['shopr_mce_button'] = plugins_url( '/assets/editor.js',__FILE__);
	return $plugin_array;
}

// Register new button in the editor
function shopr_register_mce_button( $buttons ) {
	array_push( $buttons, 'shopr_mce_button' );
	return $buttons;
}



function shopr_editor_localize_script() {
	
	$terms_list = array();
	
	$tax_terms = get_terms( array(
		'taxonomy' => 'shopr_category',
		'hide_empty' => false,
	) );
	
	if ($tax_terms && !is_wp_error($tax_terms)) {
		foreach ($tax_terms as $tax_term) {
			// build our own basic array to send to editor.js
			$terms_list[] = array(
				'text' => $tax_term->name,
				'value' => $tax_term->slug,
			);
		}
	}
	?>
	<script>
	var shopr_data = {
		'terms': <?php echo json_encode($terms_list); ?>
	};
	</script>
   <?php
}
add_action( "admin_head-post.php", 'shopr_editor_localize_script' );
add_action( "admin_head-post-new.php", 'shopr_editor_localize_script' );