<?php
if (!defined('ABSPATH')) die;

class Shopr_Customize {
	
	public static function register($wp_customize) {
		/*
		$wp_customize->add_panel( 'shopr_panel', array(
			'priority'       => 20,
			'capability'     => 'edit_theme_options',
			'theme_supports' => '',
			'title'          => 'Shopr Options',
			'description'    => 'Use these options to enable/disable all kinds of extra pipdig features.',
		) );
		*/
		$wp_customize->add_section( 'shopr_section', 
			array(
				'title' => 'Shopr Options',
				'description' => 'Use these settings to style your Shopr page.',
				'capability' => 'edit_theme_options',
				//'panel' => 'shopr_panel',
				'priority' => 1,
			)
		);

		// =========================================================================================
		
		// Show filters
		$wp_customize->add_setting('shopr_show_filters',
			array(
				'default' => 1,
				'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control('shopr_show_filters',
			array(
				'type' => 'checkbox',
				'label' => 'Show "Collection" tabs',
				'section' => 'shopr_section',
			)
		);
		
		// Collections filters position
		$wp_customize->add_setting( 'shopr_filters_position',
			array(
				'default' => 1,
				'capability' => 'edit_theme_options',
				'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control( 'shopr_filters_position',
			array(
				'type' => 'radio',
				'section' => 'shopr_section',
				'label' => 'Collection tabs position',
				'description' => 'This will only work when the option above is enabled.',
				'choices' => array(
					1 => 'Left',
					2 => 'Top',
				),
			)
		);
		
		// Collections filters position
		$wp_customize->add_setting( 'shopr_columns',
			array(
				'default' => 4,
				'capability' => 'edit_theme_options',
				'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control( 'shopr_columns',
			array(
				'type' => 'select',
				'section' => 'shopr_section',
				'label' => 'Number of columns in the grid',
				'choices' => array(
					4 => '4',
					5 => '5',
					6 => '6',
					7 => '7',
					8 => '8',
				),
			)
		);
		
		// Product titles
		$wp_customize->add_setting('shopr_show_titles',
			array(
				'default' => 0,
				'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control('shopr_show_titles',
			array(
				'type' => 'checkbox',
				'label' => 'Show product titles',
				'section' => 'shopr_section',
			)
		);
		
		// Product subtitles
		$wp_customize->add_setting('shopr_show_subtitles',
			array(
				'default' => 0,
				'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control('shopr_show_subtitles',
			array(
				'type' => 'checkbox',
				'label' => 'Show product subtitles',
				'section' => 'shopr_section',
			)
		);
		
		// Product price
		$wp_customize->add_setting('shopr_show_prices',
			array(
				'default' => 0,
				'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control('shopr_show_prices',
			array(
				'type' => 'checkbox',
				'label' => 'Show product prices',
				'section' => 'shopr_section',
			)
		);
		
		// shopnow buttons
		$wp_customize->add_setting('shopr_show_shopnow',
			array(
				'default' => 0,
				'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control('shopr_show_shopnow',
			array(
				'type' => 'checkbox',
				'label' => 'Show "Shop Now" button on hover',
				'section' => 'shopr_section',
			)
		);
		
		// Text Size ==========================================================================
		
		// product title size
		$wp_customize->add_setting( 'shopr_grid_prod_title_size', array(
			'default' => 14,
			'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control( 'shopr_grid_prod_title_size', array(
			'type' => 'number',
			'label' => 'Product title text size',
			'section' => 'shopr_section',
			'input_attrs' => array(
				'min' => 8,
				'max' => 100,
				'step' => 1,
				),
			)
		);
		
		// product title size
		$wp_customize->add_setting( 'shopr_grid_prod_subtitle_size', array(
			'default' => 12,
			'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control( 'shopr_grid_prod_subtitle_size', array(
			'type' => 'number',
			'label' => 'Product subtitle text size',
			'section' => 'shopr_section',
			'input_attrs' => array(
				'min' => 8,
				'max' => 100,
				'step' => 1,
				),
			)
		);
		
		// product title size
		$wp_customize->add_setting( 'shopr_grid_prod_price_size', array(
			'default' => 12,
			'sanitize_callback' => 'absint',
			)
		);
		$wp_customize->add_control( 'shopr_grid_prod_price_size', array(
			'type' => 'number',
			'label' => 'Product price text size',
			'section' => 'shopr_section',
			'input_attrs' => array(
				'min' => 8,
				'max' => 100,
				'step' => 1,
				),
			)
		);
		
		// Colors ==========================================================================
		
		// grid shortcode filter tabs background color
		$wp_customize->add_setting('shopr_grid_tabs_background_color',
			array(
				'default' => '#111111',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shopr_grid_tabs_background_color',
			array(
				'label' => 'Filter tabs background color',
				'section' => 'shopr_section',
				'settings' => 'shopr_grid_tabs_background_color',
			)
			)
		);
		
		// grid shortcode filter tabs text color
		$wp_customize->add_setting('shopr_grid_tabs_text_color',
			array(
				'default' => '#ffffff',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shopr_grid_tabs_text_color',
			array(
				'label' => 'Filter tabs text color',
				'section' => 'shopr_section',
				'settings' => 'shopr_grid_tabs_text_color',
			)
			)
		);
		
		// grid shortcode product border color
		$wp_customize->add_setting('shopr_grid_product_border_color',
			array(
				'default' => '#e6e6e6',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shopr_grid_product_border_color',
			array(
				'label' => 'Product border color',
				'section' => 'shopr_section',
				'settings' => 'shopr_grid_product_border_color',
			)
			)
		);
		
		// grid shortcode product title color
		$wp_customize->add_setting('shopr_grid_product_title_color',
			array(
				'default' => '#222222',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shopr_grid_product_title_color',
			array(
				'label' => 'Product title color',
				'section' => 'shopr_section',
				'settings' => 'shopr_grid_product_title_color',
			)
			)
		);
		
		// grid shortcode product subtitle color
		$wp_customize->add_setting('shopr_grid_product_subtitle_color',
			array(
				'default' => '#666666',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shopr_grid_product_subtitle_color',
			array(
				'label' => 'Product subtitle color',
				'section' => 'shopr_section',
				'settings' => 'shopr_grid_product_subtitle_color',
			)
			)
		);
		
		// grid shortcode product subtitle color
		$wp_customize->add_setting('shopr_grid_product_price_color',
			array(
				'default' => '#666666',
				'sanitize_callback' => 'sanitize_hex_color',
			)
		);
		$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'shopr_grid_product_price_color',
			array(
				'label' => 'Product price color',
				'section' => 'shopr_section',
				'settings' => 'shopr_grid_product_price_color',
			)
			)
		);

	}

	/*
	public static function live_preview() {
		wp_enqueue_script('shop-customizer', plugins_url( '/assets/customizer.css', __FILE__ ), array('jquery', 'customize-preview' ), '', true);
	}
	*/

}
add_action( 'customize_register' , array( 'Shopr_Customize' , 'register' ) );
//add_action( 'customize_preview_init' , array( 'Shopr_Customize' , 'live_preview' ) ); // customizer script



function shopr_sanitize_text_html($input) {
    return wp_kses_post(force_balance_tags($input));
}



function shopr_head_styles() {
	?>
	<!-- Shopr -->
	<style>
	.shopr_grid_filters li a, .shopr_grid_filters li a:hover, .entry-content .shopr_grid_filters li a, .entry-content .shopr_grid_filters li a:hover, .shopr_carousel_widget_button, .shopr_carousel_widget_button:hover {
		background: <?php echo sanitize_hex_color(get_theme_mod('shopr_grid_tabs_background_color', '#111111')); ?>;
		color: <?php echo sanitize_hex_color(get_theme_mod('shopr_grid_tabs_text_color', '#ffffff')); ?>;
	}
	.shopr_mosaic .shopr_product {
		border: 1px solid <?php echo sanitize_hex_color(get_theme_mod('shopr_grid_product_border_color', '#e6e6e6')); ?>;
	}
	.shopr_mosaic .shopr_product_title {
		color: <?php echo sanitize_hex_color(get_theme_mod('shopr_grid_product_title_color', '#222222')); ?>;
	}
	.shopr_mosaic .shopr_product_subtitle {
		color: <?php echo sanitize_hex_color(get_theme_mod('shopr_grid_product_subtitle_color', '#666666')); ?>;
	}
	.shopr_mosaic .shopr_product_price {
		color: <?php echo sanitize_hex_color(get_theme_mod('shopr_grid_product_price_color', '#666666')); ?>;
	}
	.shopr_grid_layout_left_filters {
		border-color: <?php echo sanitize_hex_color(get_theme_mod('shopr_grid_tabs_background_color', '#111111')); ?>;
	}
	.shopr_filters_title {
		background: <?php echo sanitize_hex_color(get_theme_mod('shopr_grid_tabs_background_color', '#111111')); ?>;
		color: <?php echo sanitize_hex_color(get_theme_mod('shopr_grid_tabs_text_color', '#ffffff')); ?>;
	}
	.shopr_mosaic .shopr_product_title {
		font-size: <?php echo absint(get_theme_mod('shopr_grid_prod_title_size', 14)); ?>px;
		line-height: 1.1;
	}
	.shopr_mosaic .shopr_product_subtitle {
		font-size: <?php echo absint(get_theme_mod('shopr_grid_prod_subtitle_size', 12)); ?>px;
		line-height: 1.25;
	}
	.shopr_mosaic .shopr_product_price {
		font-size: <?php echo absint(get_theme_mod('shopr_grid_prod_price_size', 12)); ?>px;
		line-height: 1.25;
	}
	</style>
	<!-- /Shopr -->
	<?php
}
add_action( 'wp_footer', 'shopr_head_styles', 9999 );
