<?php
if (!defined('ABSPATH')) die;

// enqueue admin scripts
function shopr_admin_scripts( $hook ) {
	if ( $hook == 'post-new.php' || $hook == 'post.php' ) {
		global $post;
		if ($post->post_type != 'shopr_product') {
			return;
		}

		$product_exist = get_posts('post_type=shopr_product&post_status=any');
		if (empty($product_exist) || isset($_GET['shopr_intro'])) {
			wp_enqueue_style( 'shopr-intro-css', 'https://cdnjs.cloudflare.com/ajax/libs/intro.js/2.5.0/introjs.min.css' );
			wp_enqueue_script( 'shopr-intro-js', 'https://cdnjs.cloudflare.com/ajax/libs/intro.js/2.5.0/intro.min.js', '', null, true );
			wp_enqueue_script( 'shopr-intro-init', plugins_url( '/assets/intro-init.js', __FILE__), '', SHOPR_VERSION, true );
		}

		wp_register_script( 'shopr-product-script', plugins_url('/assets/admin-product.js', __FILE__), array('jquery'), SHOPR_VERSION, true );

		// send thumbnail info to script
		$thumbnail_set = 0;
		if (has_post_thumbnail()) {
			$thumbnail_set = 1;
		}
		$data_array = array(
			'thumbnail_set' => $thumbnail_set
		);
		wp_localize_script( 'shopr-product-script', 'shopr_data', $data_array );

		wp_enqueue_script( 'shopr-product-script');

	}
}
add_action( 'admin_enqueue_scripts', 'shopr_admin_scripts' );


// Register Custom Post Type
function shopr_create_post_type() {

	$labels = array(
		'name'					=> _x( 'Products', 'Post Type General Name', 'shopr' ),
		'singular_name'			=> _x( 'Product', 'Post Type Singular Name', 'shopr' ),
		'menu_name'				=> 'Shopr',
		'name_admin_bar'		=> __( 'Shopr Products', 'shopr' ),
		'parent_item_colon'		=> __( 'Parent:', 'shopr' ),
		'all_items'				=> __( 'All Products', 'shopr' ),
		'add_new_item'			=> __( 'Add New Product', 'shopr' ),
		'add_new'				=> __( 'Add New Product', 'shopr' ),
		'new_item'				=> __( 'New Product', 'shopr' ),
		'edit_item'				=> __( 'Edit Product', 'shopr' ),
		'update_item'			=> __( 'Update Product', 'shopr' ),
		'view_item'				=> __( 'View Product', 'shopr' ),
		'search_items'			=> __( 'Search Item', 'shopr' ),
		'not_found'				=> __( 'Not found', 'shopr' ),
		'not_found_in_trash'	=> __( 'Not found in Trash', 'shopr' ),
	);
	$args = array(
		'label'					=> __( 'shopr_product', 'shopr' ),
		'labels'				=> $labels,
		'supports'				=> array( 'title', 'thumbnail' ),
		'taxonomies'			=> array( 'shopr_category' ),
		'hierarchical'			=> false,
		'public'				=> true,
		'show_ui'				=> true,
		'show_in_menu'			=> true,
		//'menu_position'		=> 101,
		'menu_icon'				=> 'dashicons-cart',
		'show_in_admin_bar'		=> false,
		'show_in_nav_menus'		=> false,
		'can_export'			=> true,
		'has_archive'			=> false,
		'exclude_from_search'	=> true,
		'publicly_queryable'	=> false,
		'rewrite'				=> false,
		'capability_type'		=> 'page',
	);
	register_post_type( 'shopr_product', $args );

}
add_action( 'init', 'shopr_create_post_type', 0 );


// Register Custom Taxonomy
function shopr_category() {

	$labels = array(
		'name'							=> _x( 'Collections', 'Taxonomy General Name', 'shopr' ),
		'singular_name'					=> _x( 'Collection', 'Taxonomy Singular Name', 'shopr' ),
		'menu_name'						=> __( 'Product Collections', 'shopr' ),
		'all_items'						=> __( 'All Collections', 'shopr' ),
		'parent_item'					=> __( 'Parent Collection', 'shopr' ),
		'parent_item_colon'				=> __( 'Parent Collection:', 'shopr' ),
		'new_item_name'					=> __( 'New Collection', 'shopr' ),
		'add_new_item'					=> __( 'Add New Collection', 'shopr' ),
		'edit_item'						=> __( 'Edit Collection', 'shopr' ),
		'update_item'					=> __( 'Update Collection', 'shopr' ),
		'view_item'						=> __( 'View Collection', 'shopr' ),
		'separate_items_with_commas'	=> __( 'Separate Collections with commas', 'shopr' ),
		'add_or_remove_items'			=> __( 'Add or remove Collections', 'shopr' ),
		'choose_from_most_used'			=> __( 'Choose from the most used', 'shopr' ),
		'popular_items'					=> __( 'Popular Collections', 'shopr' ),
		'search_items'					=> __( 'Search Collections', 'shopr' ),
		'not_found'						=> __( 'Not Found', 'shopr' ),
	);
	$args = array(
		'labels'				=> $labels,
		'hierarchical'			=> false,
		'public'				=> true,
		'show_ui'				=> true,
		'show_admin_column'		=> true,
		'show_in_nav_menus'		=> false,
		'show_tagcloud'			=> false,
		'rewrite'				=> false,
	);
	register_taxonomy( 'shopr_category', array( 'shopr_product' ), $args );

}
add_action( 'init', 'shopr_category', 0 );


function shopr_category_intro_description() {
	?>
	<style>
	.term-slug-wrap, .term-name-wrap p { display: none; }
	.form-wrap h2 { margin-top: 25px; }
	</style>
	<p>A "Collection" is a group of products. For example, you may wish to show items of clothing you're wearing in a particular post. In this case, you would create a Collection for the outfit.</p>
	<p>Collections can also be used to create different sections on your shop page. For example, you could have a Collection for Spring, Summer and Winter. Or you could have a Collection for Shoes, Dresses and Bags. <a href="https://support.pipdig.co/articles/shopr-product-collections/" target="_blank">Click here</a> for more information.</p>
	<!--<p>After adding some products to a Collection, you can use <a href="<?php echo admin_url('edit.php?post_type=shopr_product&page=shortcodes'); ?>">this tool</a> to create your shop page.</p>-->
	<?php
};
add_action( 'shopr_category_pre_add_form', 'shopr_category_intro_description' );


// remove all meta boxes, only add ours
// https://wordpress.stackexchange.com/a/176856
function shopr_remove_the_meta_boxes() {
	global $wp_meta_boxes;

	// get contents of each meta box array first, so we can re-add
	$submitdiv = $wp_meta_boxes['shopr_product']['side']['core']['submitdiv'];
	$tagsdiv_shopr_category = $wp_meta_boxes['shopr_product']['side']['core']['tagsdiv-shopr_category'];

	// Just in case theme does not offer add_theme_support('post-thumbnails')
	$postimagediv = '';
	if (isset($wp_meta_boxes['shopr_product']['side']['low']['postimagediv'])) {
		$postimagediv = $wp_meta_boxes['shopr_product']['side']['low']['postimagediv'];
	}

	$shopr_product_meta_fields = $wp_meta_boxes['shopr_product']['normal']['high']['shopr_product_meta_fields'];

	$wp_meta_boxes['shopr_product'] = array(
		'normal' => array(
			'high' => array(
				'shopr_product_meta_fields' => $shopr_product_meta_fields,
				'postimagediv' => $postimagediv,
				'tagsdiv-shopr_category' => $tagsdiv_shopr_category,
			),
		),
		'side' => array(
			'core' => array(
				'submitdiv' => $submitdiv,
			),
		),
	);

	return array();
}
function shopr_remove_meta_boxes() {
	add_filter('get_user_option_meta-box-order_shopr_product', 'shopr_remove_the_meta_boxes', 99999);
}
add_action('admin_init', 'shopr_remove_meta_boxes');



// Hide the description field when editing a shopr category term
function shopr_hide_term_description_field() {
	if (!isset($_GET['post_type']) || ($_GET['post_type'] != 'shopr_product')) {
		return;
	}
	?>
	<style>.term-description-wrap{display:none}</style>
	<?php
}
add_action('admin_head', 'shopr_hide_term_description_field', 10, 2 );


// Change title placeholder on products
/*
function shopr_change_title_placeholder($title){
	$screen = get_current_screen();
	if ($screen->post_type == 'shopr_product') {
		$title = 'Enter the product name here';
	}
	return $title;
}
add_filter( 'enter_title_here', 'shopr_change_title_placeholder' );
*/

/*
function shopr_tag_column_content( $content, $column_name, $term_id ){

	if( $column_name !== 'shortcode' ){
		return $content;
	}

	$term = get_term( $term_id, 'shopr_tag' );
	$slug = $term->slug;

	$content .= "<input type='text' class='widefat' onClick='this.select();' value='[shopr_shopthepost tag=\"".esc_attr($slug)."\"]' />";

	return $content;
}
add_filter('manage_shopr_tag_custom_column', 'shopr_tag_column_content', 10, 3 );
*/

// Don't use Gutenberg https://make.wordpress.org/core/2018/10/30/block-editor-filters/
function shopr_products_dont_use_gutenberg($use_block_editor, $post_type) {
	if ($post_type === 'shopr_product') {
		return false;
	}
	return $use_block_editor;
}
add_filter( 'use_block_editor_for_post_type', 'shopr_products_dont_use_gutenberg', 10, 2 );

class Shopr_Product_Metaboxes {

	public function init() {
		add_action( 'add_meta_boxes', array( $this, 'product_meta_boxes' ) );
		add_action( 'save_post_shopr_product', array( $this, 'save_meta_boxes' ),  10, 2 );
	}

	/**
	 * Register the metaboxes to be used for the team post type
	 */
	public function product_meta_boxes() {
		add_meta_box(
			'shopr_product_meta_fields',
			__('Product Details', 'shopr'),
			array( $this, 'render_meta_boxes' ),
			'shopr_product',
			'normal',
			'high',
			array('__block_editor_compatible_meta_box' => false) // no need for Gutenberg
		);
	}

   /**
	* The HTML for the form fields
	*/
	function render_meta_boxes( $post ) {

		$meta = get_post_custom( $post->ID );

		$shopr_product_link = $shopr_product_subtitle = $shopr_product_price = '';

		$shopr_product_link = ! isset( $meta['shopr_product_link'][0] ) ? '' : $meta['shopr_product_link'][0];
		$shopr_product_linked_img = ! isset( $meta['shopr_product_linked_img'][0] ) ? '' : $meta['shopr_product_linked_img'][0];
		$shopr_product_subtitle = ! isset( $meta['shopr_product_subtitle'][0] ) ? '' : $meta['shopr_product_subtitle'][0];
		$shopr_product_price = ! isset( $meta['shopr_product_price'][0] ) ? '' : $meta['shopr_product_price'][0];

		wp_nonce_field( basename( __FILE__ ), 'shopr_product_meta_fields' ); ?>
		<style>
		/* hide title field */
		#post-body-content {
			display: none;
		}
		/*
		#postimagediv {
			display: none;
		}
		*/

		#shopr_new_image_button {
			margin-left: 5px;
		}

		/* START merge meta boxes */
		#shopr_product_meta_fields {
			margin-bottom: 0;
			border-bottom: 0;
			box-shadow: none;
		}
		#postimagediv {
			margin-bottom: 0;
			border-bottom: 0;
			box-shadow: none;
			padding-top: 5px;
		}
		#tagsdiv-shopr_tag {
			margin-bottom: 0;
			border-bottom: 0;
			box-shadow: none;
			padding-top: 5px;
		}
		#tagsdiv-shopr_category {
			padding-top: 5px;
		}
		#postimagediv h2.hndle, #tagsdiv-shopr_category h2.hndle, #tagsdiv-shopr_tag h2.hndle {
			border: 0;
			padding-bottom: 0;
		}
		/* END merge meta boxes */

		#postimagediv .inside img {
			width: 175px;
		}
		.shopr_scraped_img {
			max-width: 100%;
			width: 110px;
			margin: 5px;
			padding: 2px;
			border: 4px solid #fff;
			background: #fff !important;
			cursor: pointer;
		}
		.shopr_scraped_img_active {
			border-color: #0073aa;
		}
		#shopr_scrape_img_result {
			margin-top: 10px;
		}
		#shopr_scrape_img_result p {
			margin-bottom: 10px;
		}

		#set-ngg-post-thumbnail {
			display: none;
		}

		#shopr_image_buttons {
			margin-top: 10px;
		}

		.dashicons.spin {
			animation: dashicons-spin 1.8s infinite;
			animation-timing-function: linear;
		}
		@keyframes dashicons-spin {
			0% {
				transform: rotate( 0deg );
			}
			100% {
				transform: rotate( 360deg );
			}
		}
		</style>
		<!--<p>Clicks: <?php echo get_post_meta($post->ID, 'shopr_product_clicks', true); ?></p>-->

		<table class="form-table">
		<tr id="intro_product_title">
			<th scope="row"><label for="shopr_product_title">Product Title</label></th>
			<td><input type="text" name="shopr_product_title" id="shopr_product_title" class="widefat" value="<?php the_title_attribute(); ?>"></td>
		</tr>
		<tr id="intro_product_subtitle">
			<th scope="row"><label for="shopr_product_subtitle">Product Subtitle</label></th>
			<td><input type="text" name="shopr_product_subtitle" id="shopr_product_subtitle" class="widefat" placeholder="e.g. Love these shoes!" value="<?php echo esc_attr($shopr_product_subtitle); ?>"></td>
		</tr>
		<tr id="intro_product_price">
			<th scope="row"><label for="shopr_product_price">Product Price</label></th>
			<td><input type="text" name="shopr_product_price" id="shopr_product_price" class="widefat" placeholder="e.g. $49" value="<?php echo esc_attr($shopr_product_price); ?>"></td>
		</tr>
		<tr id="intro_product_link">
			<th scope="row"><label for="shopr_product_link">Product Link <em>(required)</em></label></th>
			<td>
			<input type="url" name="shopr_product_link" id="shopr_product_link" class="widefat" placeholder="e.g. http://rstyle.me/~5zeWe" value="<?php echo esc_attr($shopr_product_link); ?>" required>
			<!--
			<div id="shopr_scrape_img_result"></div>
			<div id="shopr_image_buttons" style="display:none">
			<div id="shopr_new_image_button" class="button">Search link for new images</div>
			<div id="shopr_custom_image_button" class="button" style="">Upload custom image</div>
			<div class="clear"></div>
			</div>
			-->
			</td>
		</tr>
		<tr id="shopr_product_img_src" style="display: none">
			<th scope="row"><label for="shopr_product_linked_img">Product Image Src</label></th>
			<td>
			<input type="url" name="shopr_product_linked_img" id="shopr_product_linked_img" class="widefat" value="<?php echo esc_attr($shopr_product_linked_img); ?>">
			</td>
		</tr>
		</table>
	<?php }

   /**
	* Save metaboxes
	*/
	function save_meta_boxes( $post_id ) {

		global $post;

		// Verify nonce
		if ( !isset( $_POST['shopr_product_meta_fields'] ) || !wp_verify_nonce( $_POST['shopr_product_meta_fields'], basename(__FILE__) ) ) {
			return $post_id;
		}

		// Check permissions
		if ( !current_user_can( 'edit_post', $post->ID ) ) {
			return $post_id;
		}

		$meta['shopr_product_link'] = ( isset( $_POST['shopr_product_link'] ) ? esc_url( $_POST['shopr_product_link'] ) : '' );
		$meta['shopr_product_linked_img'] = ( isset( $_POST['shopr_product_linked_img'] ) ? esc_url( $_POST['shopr_product_linked_img'] ) : '' );
		$meta['shopr_product_subtitle'] = ( isset( $_POST['shopr_product_subtitle'] ) ? strip_tags( $_POST['shopr_product_subtitle'] ) : '' );
		$meta['shopr_product_price'] = ( isset( $_POST['shopr_product_price'] ) ? strip_tags( $_POST['shopr_product_price'] ) : '' );

		foreach ( $meta as $key => $value ) {
			update_post_meta( $post->ID, $key, $value );
		}

	}

}
// Initialize metaboxes
$post_type_metaboxes = new Shopr_Product_Metaboxes;
$post_type_metaboxes->init();


// Ajax function attached to product link input field
function shopr_product_link_scrape() {

	$link = $_POST['link'];

	$output = $images_output = '';

	// if link entered is not valid, bail
	if (!filter_var($link, FILTER_VALIDATE_URL) !== false) {
		wp_die();
	}

	$site_url = get_site_url();
	$domain = str_replace('http://', '', $site_url);
	$domain = str_replace('https://', '', $domain);
	$domain = str_replace('www.', '', $domain);
	$request_array['domain'] = $domain;
	$request_array['tempToken'] = 'dcx15';
	$request_array['link'] = rawurlencode($link);

	$url = add_query_arg($request_array, 'https://pipdig.rocks/shopr/img');

	$args = array(
		'timeout' => 20,
	);
	$response = wp_safe_remote_get($url, $args);

	if (is_wp_error($response)) {
		wp_die();
	}

	$images = json_decode(wp_remote_retrieve_body($response), true);

	if (is_array($images)) {
		$i = 1;
		foreach ($images as $image_src) {
			if ($i == 1) {
				$images_output .= '<img src="'.esc_url($image_src).'" class="shopr_scraped_img shopr_scraped_img_active" alt="">';
			} else {
				$images_output .= '<img src="'.esc_url($image_src).'" class="shopr_scraped_img" alt="">';
			}
			$i++;
		}
	}

	if ($images_output) { // there were images or pg:image found on the page
		$output .= '<p>The following images were provided by that page. Select one by clicking it.</p><p>Are the images below not suitable? You can upload your own image using the button above.</p><p>'.$images_output.'</p>';
	} else { // so there's no images or og:image
		$output .= '<p class=""><span class="dashicons dashicons-warning"></span> This website is blocking the search for images (boo!). You could download an image from the page and then upload it to this product using the button above.</p>';
	}

	echo $output;
	wp_die();
}
add_action( 'wp_ajax_shopr_product_link_scrape', 'shopr_product_link_scrape' );


// Hide "View" quick button from post listing page
function shopr_remove_row_actions( $actions ) {
	if (get_post_type() === 'shopr_product') {
		unset( $actions['view'] );
	}
	return $actions;
}
add_filter( 'post_row_actions', 'shopr_remove_row_actions', 10, 1 );


// remove Slug metabox from post editor
function shopr_remove_default_post_screen_metaboxes() {
	remove_meta_box( 'slugdiv','shopr_product','normal' );
}
add_action('admin_menu','shopr_remove_default_post_screen_metaboxes');


// Hide preview and slug in post editor
function shopr_editor_css() {
	if (get_post_type() === 'shopr_product') {
		echo '<style>#edit-slug-box,#view-post-btn,#post-preview,.updated p a{display: none!important;}.view{display:none!important;}</style>';
	}
}
add_action('admin_head', 'shopr_editor_css');


// shopr_product columns
function shopr_product_columns($columns){

	// remove all columns except for system "checkbox" (cb) one
	foreach($columns as $key => $val) {
	    if ($key !== 'cb') {
	      unset($columns[$key]);
	    }
	}
	$shopstyle_active = false;
	$options = get_option('shopr_options');
	if (!empty($options['shopstyle_key'])) {
		$shopstyle_active = true;
	}

	// Then add the ones we want
	$columns['title'] = 'Title';
	$columns['image'] = 'Image';
	$columns['taxonomy-shopr_category'] = 'Collections';
	$columns['link'] = 'Share Link';
	//$columns['date'] = 'Date';
	$columns['clicks'] = 'Clicks';

	return $columns;
}
add_filter('manage_edit-shopr_product_columns', 'shopr_product_columns', 9 );

function shopr_display_product_columns_data($column, $post_id) {
	global $post;

	$link = get_post_meta($post->ID, 'shopr_product_link', true);
	$clicks = get_post_meta($post->ID, 'shopr_product_clicks', true);

	switch($column) {

		case 'link':
			if ($link) {
				echo '<input type="text" class="widefat" onClick="this.select();" value="'.esc_url($link).'" /><br />';
				echo '<a href="'.esc_url($link).'" target="_blank" rel="noopener">Open Link</a>';
			}
			break;

		case 'image':
			if (get_the_post_thumbnail($post->ID,'shopr-product')) {
				$image = get_the_post_thumbnail_url($post->ID,'shopr-product');
			} else {
				$image = get_post_meta($post->ID, 'shopr_product_linked_img', true);
			}
			if ($image) {
				echo '<a href="'.admin_url('post.php?post='.$post->ID.'&action=edit').'"><img src="'.esc_url($image).'" style="max-width:100%; width: 120px;" alt=""/></a>';
			}
			break;

		case 'clicks':
			if ($clicks) {
				echo absint($clicks);
			}
			break;

	}
}
add_action( 'manage_shopr_product_posts_custom_column', 'shopr_display_product_columns_data', 10, 2 );


// shopr_category term columns
function shopr_term_columns($columns) {

	// remove all columns except ones we want to keep
	foreach($columns as $key => $val) {
	    if ( ($key !== 'cb') && ($key !== 'name') && ($key !== 'posts') ) {
	     unset($columns[$key]);
	    }
	}

	// Then add extra ones we want
	$columns['shortcode'] = 'Shortcode';
	
	/*
	if ($shopstyle_active) {
		$columns['shopstyle'] = 'Shopstyle';
	}
	$columns['rewardstyle'] = 'rewardStyle';
	*/
	return $columns;
}
add_filter('manage_edit-shopr_category_columns', 'shopr_term_columns' );
//add_filter('manage_edit-shopr_tag_columns', 'shopr_term_columns' );


function shopr_category_column_content($content, $column_name, $term_id) {

	if ($column_name == 'shortcode') {
		$term = get_term($term_id, 'shopr_category');
		$slug = $term->slug;
		$content .= "<input type='text' class='widefat' onClick='this.select();' value='[shopr collection=\"".esc_attr($slug)."\"]' />";
	}/* elseif ($column_name == 'shopstyle') {
		$content .= sanitize_text_field(get_term($term_id, 'shopstyle'));
	} elseif ($column_name == 'rewardstyle') {
		$content .= sanitize_text_field(get_term($term_id, 'rewardstyle'));
	}*/

	return $content;
}
add_filter('manage_shopr_category_custom_column', 'shopr_category_column_content', 10, 3 );


// add Shopstyle ID field to Add Collection screen for shopr_category
function shopr_category_term_meta_add_form() {
    wp_nonce_field(basename( __FILE__ ), 'shopr_term_shopstyle_nonce');
		?>
    <div class="form-field">
        <label for="shopr-term-shopstyle">Shopstyle Collective List ID (?)</label>
        <input type="number" name="shopr_term_shopstyle" id="shopr-term-shopstyle" value="<?php echo sanitize_text_field($shopstyle_id); ?>" />
    </div>
<?php }
//add_action( 'shopr_category_add_form_fields', 'shopr_category_term_meta_add_form' );

// add Shopstyle ID field to Edit Collection screen for shopr_category
function shopr_category_term_meta_edit_form($term) {

	$shopstyle_id = get_term_meta( $term->term_id, 'shopstyle', true );
	$rewardstyle_id = get_term_meta( $term->term_id, 'rewardstyle', true );

	if (!$shopstyle_id) {
		$shopstyle_id = '';
	}
	if (!$rewardstyle_id) {
		$rewardstyle_id = '';
	}

	$options = get_option('shopr_options');

	?>
	<tr class="form-field">
		<th scope="row"><label for="shopr-term-shopstyle">Shopstyle Collective List ID <a href="https://support.pipdig.co/articles/shopr-shopstyle-collective-list/" target="_blank" rel="noopener" style="text-decoration: none"><span class="dashicons dashicons-editor-help"></span></a></label></th>
		<td>
			<?php wp_nonce_field(basename( __FILE__ ), 'shopr_term_shopstyle_nonce'); ?>
			<?php if (!empty($options['shopstyle_key'])) {  ?>
				<input type="number" name="shopr_term_shopstyle" id="shopr-term-shopstyle" value="<?php echo sanitize_text_field($shopstyle_id); ?>" />
				<p class="description">Automatically display products from a Shopstyle list in this collection. Whenever you add products to the List in your Shopstyle account, the products will also be added to this Collection automatically. <a href="https://support.pipdig.co/articles/shopr-shopstyle-collective-list/" target="_blank" rel="noopener" style="text-decoration: none">Click here for more information</a>.</p>
			<?php } else { ?>
				<input type="number" name="" id="" value="" disabled />
				<p class="description">Automatically display products from Shopstyle in this collection. Please connect your site to Shopstyle by adding your UID/API Key on <a href="<?php echo admin_url('edit.php?post_type=shopr_product&page=settings'); ?>">this page</a> first.</p>
			<?php } ?>
		</td>
    </tr>
	<tr class="form-field">
		<th scope="row"><label for="shopr-term-rewardstyle">rewardStyle Boutique ID <a href="https://support.pipdig.co/articles/shopr-rewardstyle-products/" target="_blank" rel="noopener" style="text-decoration: none"><span class="dashicons dashicons-editor-help"></span></a></label></th>
		<td>
			<?php wp_nonce_field(basename( __FILE__ ), 'shopr_term_rewardstyle_nonce'); ?>
			<input type="number" name="shopr_term_rewardstyle" id="shopr-term-rewardstyle" value="<?php echo sanitize_text_field($rewardstyle_id); ?>" />
			<p class="description">Automatically display products from a rewardStyle Boutique widget. Whenever you add products to the Boutique widget in rewardStyle, they will also be displayed in this Collection too. <a href="https://support.pipdig.co/articles/shopr-rewardstyle-products/" target="_blank" rel="noopener" style="text-decoration: none">Click here for more information</a>.</p>
		</td>
    </tr>

	<style>
	/* Dirty hack to hide Yoast SEO */
	#edittag #wpseo_meta {
		display: none;
	}
	</style>

<?php }
add_action( 'shopr_category_edit_form_fields', 'shopr_category_term_meta_edit_form', 10, 2 );

// Save Shopstyle ID in term meta for shopr_category
function shopr_category_term_meta_update($term_id) {

	if ( !isset($_POST['shopr_term_shopstyle_nonce']) || !wp_verify_nonce($_POST['shopr_term_shopstyle_nonce'], basename(__FILE__)) )
		return;

	if ( !isset($_POST['shopr_term_rewardstyle_nonce']) || !wp_verify_nonce($_POST['shopr_term_rewardstyle_nonce'], basename(__FILE__)) )
		return;

	$old_shopstyle_id = get_term_meta( $term_id, 'shopstyle', true );
	$new_shopstyle_id = isset($_POST['shopr_term_shopstyle']) ? sanitize_text_field($_POST['shopr_term_shopstyle']) : '';

	if ($old_shopstyle_id && '' === $new_shopstyle_id) {
		delete_term_meta($term_id, 'shopstyle');
	} elseif ($old_shopstyle_id !== $new_shopstyle_id) {
		update_term_meta( $term_id, 'shopstyle', $new_shopstyle_id );
	}

	$old_rewardstyle_id = get_term_meta( $term_id, 'rewardstyle', true );
	$new_rewardstyle_id = isset($_POST['shopr_term_rewardstyle']) ? sanitize_text_field($_POST['shopr_term_rewardstyle']) : '';

	if ($old_rewardstyle_id && '' === $new_rewardstyle_id) {
		delete_term_meta($term_id, 'rewardstyle');
	} elseif ($old_rewardstyle_id !== $new_rewardstyle_id) {
		update_term_meta( $term_id, 'rewardstyle', $new_rewardstyle_id );
	}

	wp_redirect(admin_url('edit-tags.php?taxonomy=shopr_category&post_type=shopr_product'));
	die;
}
add_action( 'edit_shopr_category',   'shopr_category_term_meta_update' );
//add_action( 'create_shopr_category', 'shopr_category_term_meta_update' );
