//console.log(shopr_data.terms);
(function() {
	tinymce.PluginManager.add('shopr_mce_button', function(editor, url) {
		editor.addButton('shopr_mce_button', {
			//icon: 'wp_code',
			text: 'Shopr',
			title: 'Add a Shopr "Shop the Post" widget',
			onclick: function() {

				var termsArray = shopr_data.terms; // grab terms sent from php

				if (termsArray.length > 0) {
					var collectionField = {
						type: 'listbox',
						name: 'collectionSlug',
						label: 'Collection',
						values: termsArray
					};
				} else {
					var collectionField = {
						type: 'container',
						html: 'You have not created any product collections yet.<br />This feature will not work yet.',
						label: 'Collection'
					};
				}

				editor.windowManager.open({
					title: "Shop The Post",
					//width: 340,
					//height: 140,
					body: [
						{
							type: 'textbox',
							name: 'widgetTitle',
							label: 'Title (optional)',
							value: ''
						}
						/*,{
							type: 'listbox',
							name: 'widgetType',
							label: 'Display Type',
							values: [
								{text: 'Carousel', value: 'carousel'},
								{text: 'Grid', value: 'grid'}
							]
						}*/
						,collectionField
						,{
							type: 'listbox',
							name: 'imageSize',
							label: 'Image Size',
							values: [
								{text: 'Small (default)', value: 'small'},
								{text: 'Medium', value: 'medium'},
								{text: 'Large', value: 'large'}
							]
						}
						,{
							type: 'checkbox',
							name: 'showProductTitle',
							label: 'Show product titles',
							
						}
						,{
							type: 'checkbox',
							name: 'showProductPrice',
							label: 'Show product price',
							
						}
/*
						{
							type: 'container',
							html: 'Optional: You can display products from rewardStyle<br />or Shopstyle using the options below.',
						},{
							type: 'textbox',
							name: 'shopstyle',
							label: 'Shopstyle List ID',
							value: ''
						},{
							type: 'textbox',
							name: 'rewardstyle',
							label: 'rewardStyle Boutique ID',
							value: ''
						}
*/
					],
					onsubmit: function(e) {

						var widgetTitleOut = '';
						var widgetTitleString = e.data.widgetTitle.replace(/["]+/g, ''); // remove double quotes
						if (widgetTitleString.length > 1) {
							var widgetTitleOut = ' title="'+widgetTitleString+'"';
						}

						var shoprCollectionOut = '', shoprTag = '';
						if (typeof e.data.collectionSlug !== 'undefined') {
							var shoprTag = e.data.collectionSlug;
						}
						if (shoprTag.length > 0) {
							var shoprCollectionOut = ' collection="'+shoprTag+'"';
						}

						var imageSizeOut = '';
						if (typeof e.data.imageSize !== 'undefined') {
							var imageSize = e.data.imageSize;
						}
						if (imageSize.length > 0) {
							if (imageSize != 'small') {
								var imageSizeOut = ' size="'+imageSize+'"';
							}
						}
						
						var showProductTitleOut = '';
						if (e.data.showProductTitle) {
							var showProductTitleOut = ' show_product_title="yes"';
						}
						
						var showProductPriceOut = '';
						if (e.data.showProductPrice) {
							var showProductPriceOut = ' show_product_price="yes"';
						}

						var shopstyleOut = '';
						/*
						var shopstyleID = e.data.shopstyle.replace(/\D/g, ''); // take only numbers
						if (shopstyleID.length > 4) {
							var shopstyleOut = ' shopstyle="'+shopstyleID+'"';
						}
						*/

						var rewardstyleOut = '';
						/*
						var rewardstyleID = e.data.rewardstyle.replace(/\D/g, ''); // take only numbers
						if (rewardstyleID.length > 4) {
							var rewardstyleOut = ' rewardstyle="'+rewardstyleID+'"';
						}
						*/
						
						
						var widgetTypeOut = '_shopthepost';
						/*
						if (typeof e.data.widgetType !== 'undefined') {
							var widgetType = e.data.widgetType;
						}
						if (widgetType.length > 0) {
							if (widgetType == 'grid') {
								var widgetTypeOut = '';
							}
						}
						*/
						
						editor.insertContent(
							'[shopr'+widgetTypeOut+shoprCollectionOut+imageSizeOut+widgetTitleOut+shopstyleOut+rewardstyleOut+showProductTitleOut+showProductPriceOut+']'
						);

					}
				});
			}
		});
	});
})();
