( function( editor, components, i18n, element ) {
	var el = element.createElement;
	var registerBlockType = wp.blocks.registerBlockType;
	var InspectorControls = wp.editor.InspectorControls;
	var TextControl = wp.components.TextControl;
	var SelectControl = wp.components.SelectControl;
	//var ServerSideRender = wp.components.ServerSideRender;
	
	var termsArray = shopr_gb_data.terms; // grab terms sent from old school php

	registerBlockType( 'shopr/carousel', {
		
		title: 'Shopr - Carousel',
		description: i18n.__( 'Display products in a sliding carousel.' ),
		icon: 'cart', // Dashicon icon for our block. Custom icons can be added using inline SVGs.
		category: 'common',

		edit: function( props ) {
			return [
			/*
				el( ServerSideRender, {
					block: 'shopr/carousel',
					attributes: props.attributes,
				} ),
			*/
				// Inspector Controls
				el( InspectorControls, { key: 'inspector' }, // Display the block options in the Inspector panel.
					el( components.PanelBody, {
							title: i18n.__('Options'),
							className: 'shopr-carousel-block-options',
							initialOpen: true,
						},
						el( 'p', {}, 'Use the options below to select a collection of products to display. You will need to add some products to a collection before using this feature, if you have not already done so.' ),
						el( TextControl, {
							type: 'text',
							label: i18n.__( 'Title' ),
							value: props.attributes.title,
							onChange: function( newTitle ) {
								props.setAttributes( { title: newTitle } );
							},
						} ),
						el( SelectControl, {
							type: 'text',
							label: i18n.__( 'Show products from' ),
							value: props.attributes.collection,
							options: termsArray,
							onChange: function( newCollection ) {
								props.setAttributes( { collection: newCollection } );
							},
						} ),
						el( SelectControl, {
							type: 'text',
							label: i18n.__( 'Image Size' ),
							value: props.attributes.size,
							options: [
								{value: 'small', label: i18n.__('Small')},
								{value: 'medium', label: i18n.__('Medium')},
								{value: 'large', label: i18n.__('Large')}
							],
							onChange: function( newSize ) {
								props.setAttributes( { size: newSize } );
							},
						} ),
					),
				),
				// Editor content
				el( 'p', {}, 'Shopr carousel will be displayed here. Click this text and use the options on the right of the screen to change the options.' ),
			];
		},

		save: function() {
			return null;
		}
		
	} );

} )(
	window.wp.editor,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
);



// Grid block
( function( editor, components, i18n, element ) {
	var el = element.createElement;
	var registerBlockType = wp.blocks.registerBlockType;
	var InspectorControls = wp.editor.InspectorControls;
	var TextControl = wp.components.TextControl;
	var SelectControl = wp.components.SelectControl;
	
	var termsArray = shopr_gb_data.terms; // grab terms sent from old school php

	registerBlockType( 'shopr/grid', {
		
		title: 'Shopr - Grid',
		description: i18n.__( 'Display products in a grid.' ),
		icon: 'cart', // Dashicon icon for our block. Custom icons can be added using inline SVGs.
		category: 'common',

		edit: function( props ) {
			return [
				// Inspector Controls
				el( InspectorControls, { key: 'inspector' }, // Display the block options in the Inspector panel.
					el( components.PanelBody, {
							title: i18n.__('Product Options'),
							className: 'shopr-grid-block-options',
							initialOpen: true,
						},
						el( 'p', {}, 'Use the options below to select a collection of products to display. If you don\'t select a specific collection, all products will be displayed.' ),
						el( SelectControl, {
							type: 'text',
							label: i18n.__( 'Show products from' ),
							value: props.attributes.collection,
							options: termsArray,
							onChange: function( newCollection ) {
								props.setAttributes( { collection: newCollection } );
							},
						} ),
						el( SelectControl, {
							type: 'text',
							label: i18n.__( 'Don\'t show products from' ),
							value: props.attributes.exclude,
							options: termsArray,
							onChange: function( newExclude ) {
								props.setAttributes( { exclude: newExclude } );
							},
						} ),
						el( 'p', {}, 'You can also override the default text labels for this feature using the options below.' ),
					),
				),
				el( InspectorControls, { key: 'inspector' }, // Display the block options in the Inspector panel.
					el( components.PanelBody, {
							title: i18n.__('Text Labels'),
							className: 'shopr-grid-block-label-options',
							initialOpen: false,
						},
						el( TextControl, {
							type: 'text',
							label: i18n.__( '"Browse Collection" title text' ),
							value: props.attributes.labelBrowseCollection,
							onChange: function( newLabelBrowseCollection ) {
								props.setAttributes( { labelBrowseCollection: newLabelBrowseCollection } );
							},
						} ),
						el( TextControl, {
							type: 'text',
							label: i18n.__( '"Shop Now" title text' ),
							value: props.attributes.labelShopNow,
							onChange: function( newLabelShopNow ) {
								props.setAttributes( { labelShopNow: newLabelShopNow } );
							},
						} ),
						el( TextControl, {
							type: 'text',
							label: i18n.__( '"Show All" title text' ),
							value: props.attributes.labelShowAll,
							onChange: function( newLabelShowAll ) {
								props.setAttributes( { labelShowAll: newLabelShowAll } );
							},
						} ),
					),
				),
				// Editor content
				el( 'p', {}, 'Shopr grid will be displayed here. Click this text and use the options on the right of the screen to change the options.' ),
			];
		},

		save: function() {
			return null;
		}
		
	} );

} )(
	window.wp.editor,
	window.wp.components,
	window.wp.i18n,
	window.wp.element,
);