<?php
if (!defined('ABSPATH')) die;

function shopr_admin_settings_func() {
	?>
	<style>
	
	.notice {
		display: none !important;
	}
	
	.switch {
		position: relative;
		display: inline-block;
		width: 60px;
		height: 34px;
	}

	.switch input {display:none;}

	.slider {
		position: absolute;
		cursor: pointer;
		top: 0;
		left: 0;
		right: 0;
		bottom: 0;
		background-color: #ccc;
		-webkit-transition: .4s;
		transition: .4s;
		border-radius: 34px;
	}

	.slider:before {
		position: absolute;
		content: "";
		height: 26px;
		width: 26px;
		left: 4px;
		bottom: 4px;
		background-color: white;
		-webkit-transition: .4s;
		transition: .4s;
		border-radius: 50%;
	}

	input:checked + .slider {
		background-color: #0085BA;
	}

	input:focus + .slider {
		box-shadow: 0 0 1px #0085BA;
	}

	input:checked + .slider:before {
		-webkit-transform: translateX(26px);
		-ms-transform: translateX(26px);
		transform: translateX(26px);
	}

	.shopr_question {
		color: #000;
		text-decoration: none;
	}

	.shopr_active {
		padding: 5px 10px 5px 5px;
		display: inline-block;
		border: 2px solid green;
		border-radius: 2px;
		background: #e5fddc;
	}
	.shopr_not_active {
		padding: 5px 10px 5px 5px;
		display: inline-block;
		border: 2px solid #ed6a6a;
		border-radius: 2px;
		background: #ffe4e4;
	}
	
	#shopr_click_remove_key {
		text-align: right;
		font-size: 80%;
	}
	#shopr_click_remove_key span {
		color: red;
		cursor: pointer;
	}
	
	.shopr_infotab_reveal {
		display: none;
		background: #f4f4f4;
		padding: 8px;
		border-radius: 6px;
	}
	.shopr_infotab_icon {
		cursor: pointer;
	}
	
	#shopr_click_import_data span {
		cursor: pointer;
	}
	.dashicons.spin {
		animation: dashicons-spin 2s infinite;
		animation-timing-function: linear;
	}
	@keyframes dashicons-spin {
		0% {
			transform: rotate( 0deg );
		}
		100% {
			transform: rotate( 360deg );
		}
	}
	
	</style>
	<div class="wrap">
		<div class="card">
		<h1 class="title">Shopr Settings</h1>
		
		<?php if (is_shopr_active()) { ?>
			<p class="shopr_active"><span class="dashicons dashicons-yes"></span> Shopr has been successfully activated!</p>
		<?php } else { ?>
			<p class="shopr_not_active"><span class="dashicons dashicons-no"></span> Shopr has not been activated!</p>
		<?php } ?>
		<p><a href="https://support.pipdig.co/articles/shopr-license-key/" target="_blank" rel="noopener">Click here</a> for information about where to find your Shopr license key.</p>
		
		<form method="post" action="options.php">
			<?php
			settings_fields('section');
			do_settings_sections('shopr_section_1');
			submit_button();
			delete_transient('shopr_active');
			?>
		</form>
		
		<?php $products = wp_count_posts($post_type = 'shopr_product'); ?>
		
		<?php if (absint($products->publish) < 5) { ?>
		<hr />
		<h2>Import Demo Products</h2>
		<p id="shopr_click_import_data"><span id="shopr_click_import_data_click"><span class="dashicons dashicons-migrate"></span> Click here to import demo data</span></p>
		<?php } ?>
		
		<div id="shopr_remove_key_result"></div>
		
		<script>
		jQuery(document).ready(function($) {
			
			<?php if (absint($products->publish) < 5) { ?>
			$('#shopr_click_import_data_click').click(function(){
				
				var confirmImport = confirm('This will import the Shopr demo products and collections. Are you sure?');
				if (confirmImport) {
					
					$(this).html('<p id="shopr_click_import_data"><span class="dashicons dashicons-update spin"></span> Importing, please wait...</p>');
					
					var data = {
						action: 'shopr_import_data',
					};
					$.post(ajaxurl, data, function(response) {
						//alert(response);
						$('#shopr_click_import_data').html(response);
					});
					
				}
				
			});
			<?php } ?>
			
			/*
			$('#shopr_click_remove_key span').click(function(){
				var data = {
					action: 'shopr_reset_key',
				};
				$.post(ajaxurl, data, function(response) {
					alert(response);
					$('#shopr_remove_key_result').html(response);
				});
			});
			*/
			$('.shopr_infotab_icon').toggle(function() {
				$(this).closest('tr').find('.shopr_infotab_reveal').slideDown(250);
			}, function() {
				$(this).closest('tr').find('.shopr_infotab_reveal').slideUp(250);
			});
			
		});
		</script>
		
		
		</div>
	</div>
	<?php
}
function shopr_settings_page() {
	add_settings_section('section', '', null, 'shopr_section_1');
	add_settings_field('license_key', 'Plugin License Key <a href="https://support.pipdig.co/articles/shopr-license-key/" target="_blank" rel="noopener" class="shopr_question"><span class="dashicons dashicons-editor-help"></span></a>', 'shopr_display_license_enqueue_field', 'shopr_section_1', 'section');
	add_settings_field('shopstyle', 'Shopstyle UID/API Key <span class="dashicons dashicons-editor-help shopr_infotab_icon"></span>', 'shopr_display_shopstyle_field', 'shopr_section_1', 'section');
	register_setting('section', 'shopr_options');
}

function shopr_display_license_enqueue_field() {
	$value = '';
	$options = get_option('shopr_options');
	if (isset($options['license_key'])) {
		$value = sanitize_text_field($options['license_key']);
	}
	?>
	<input type="text" class="widefat" id="license_key" name="shopr_options[license_key]" value="<?php echo $value; ?>">
	<br /><span style="font-size: 80%">Note: you do not need to add a license key for development/staging sites.</span>
	<?php if ($value) { ?>
	<!-- <br /><div id="shopr_click_remove_key"><span>Click here</span> to remove the key from this site</div> -->
	<?php } ?>
	<?php
}

add_action('admin_init', 'shopr_settings_page');


function shopr_display_shopstyle_field() {
	$value = '';
	$options = get_option('shopr_options');
	if (isset($options['shopstyle_key'])) {
		$value = sanitize_text_field($options['shopstyle_key']);
	}
	?>
	<input type="text" class="widefat" id="shopstyle_key" name="shopr_options[shopstyle_key]" value="<?php echo $value; ?>">
	<p class="shopr_infotab_reveal">If you use Shopstyle Collective to display products, you can add your API key here. You can find your API key on <a href="https://www.shopstylecollective.com/account/profile" target="_blank" rel="noopener">this page</a>.</p>
	<?php
}


/*
function shopr_reset_key_callback() {
	
	$options = get_option('shopr_options');
	if (empty($options['license_key'])) {
		echo 'There was no key in the options to reset.';
		wp_die();
	} else {
		$key = strip_tags(trim($options['license_key']));
	}
	
	$$request_array = array();
	$request_array['action'] = 'remove';
	$request_array['domain'] = get_site_url();
	$request_array['tempToken'] = 'dcx15';
	$request_array['key'] = $key;

	$url = add_query_arg($request_array, 'https://www.pipdig.co/shopr_validate.php');

	$args = array(
		'timeout' => 9,
	);

	$response = wp_safe_remote_get($url, $args);

	if (!is_wp_error($response)) {
		$result = absint($response['body']);
		if ($results === 9) {
			echo 'Key successfully removed from this domain. You can now use it on your new site.';
			$options['license_key'] = '';
			update_option('shopr_options', $options);
		} else {
			echo 'Error: there was no key set for this domain.';
		}
	}

	wp_die();
}
add_action( 'wp_ajax_shopr_reset_key', 'shopr_reset_key_callback' );
*/



function shopr_import_data_callback() {
	
	wp_insert_term('Clothes', 'shopr_category');
	wp_insert_term('Shoes', 'shopr_category');
	wp_insert_term('Tops', 'shopr_category');
	wp_insert_term('Denim', 'shopr_category');
	wp_insert_term('Books', 'shopr_category');
	
	$products = array(
	
		// Product 1
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'shoes'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2rHPFvj',
				'shopr_product_linked_img' => 'https://media.missguided.com/s/missguided/F1606572_set/1/black-pearl-detail-platform-heels.jpg?$facebook__og-image--std$',
				'shopr_product_subtitle' => 'This is a subtitle',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 2
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'shoes'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2t0FYvR',
				'shopr_product_linked_img' => 'https://images.topshop.com/i/TopShop/TS42A03LCAM_F_1.jpg?$Large$',
				'shopr_product_subtitle' => 'This is a subtitle',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 3
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'shoes'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2rHS0GF',
				'shopr_product_linked_img' => 'https://images.topshop.com/i/TopShop/TS32W08LYLW_F_1.jpg?$Large$',
				'shopr_product_subtitle' => 'Here is a subtitle',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 4
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'shoes'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2t0rJXO',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/new-look-metallic-low-heeled-mule/7792101-1-gold',
				'shopr_product_subtitle' => 'This is a subtitle',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 5
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'shoes'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2rHCryt',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/adidas-country-og-trainers/7563032-1-utiivyftwwht',
				'shopr_product_subtitle' => 'Here\'s a subtitle',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 6
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'shoes'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'https://amzn.to/2QixEAC',
				'shopr_product_linked_img' => 'https://images-na.ssl-images-amazon.com/images/I/31oOLDcmaIL.jpg',
				'shopr_product_subtitle' => 'Subtitle here',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 7
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'tops'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2t0vJre',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/new-look-petite-gingham-ruffle-tiered-top/7851602-1-bluepattern',
				'shopr_product_subtitle' => 'Subtitle here',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 8
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'tops'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2qwmoCH',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/asos-ribbed-midi-cardigan/7595850-1-oatmeal',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 9
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'tops'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2qwhdCI',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/levis-sweatshirt-with-vintage-logo-and-raw-hem/8119652-1-marshmellowcream',
				'shopr_product_subtitle' => 'This is the subtitle',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 10
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'tops'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2pPvRZv',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/yas-alche-summer-bow-top/7742599-1-starwhite',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 11
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'tops'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2qwnyOC',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/asos-off-shoulder-top-with-broderie-and-pep-hem/7777445-1-white',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 12
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'denim'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2rHNKGU',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/cheap-monday-mid-rise-girlfriend-jean/7781291-1-lightstone',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 13
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'denim'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2t0AHVd',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/asos-ridley-skinny-jeans-in-lela-wash-with-busted-knees-and-raw-hem/7129361-1-midwashblue',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 14
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'denim'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2pPJQig',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/asos-denim-dungaree-dress-in-off-white-with-tobacco-stitch/7699090-1-white',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 15
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'denim'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2qwzMXE',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/asos-denim-dungaree-dress-in-mid-wash-blue/7454177-1-blue',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 16
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'denim'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2pPAJy1',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/levis-trucker-jacket/8119653-1-dreamoflifeblue',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 17
		array(
			'tax_input' => array( 
				'shopr_category' => array('clothes', 'denim'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'http://bit.ly/2qwvyPM',
				'shopr_product_linked_img' => 'https://images.asos-media.com/products/dr-denim-nora-mom-jean/8093363-1-midretro',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$'.rand(20, 99),
			),
		),
		
		// Product 18
		array(
			'tax_input' => array( 
				'shopr_category' => array('books'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'https://www.amazon.co.uk/gp/product/B07DGLW6P4/ref=as_li_tl?ie=UTF8&camp=1634&creative=6738&creativeASIN=B07DGLW6P4&linkCode=as2&tag=tanyaburr07d-21&linkId=bc7a4942620c22586c84db36fedc6ba5',
				'shopr_product_linked_img' => 'https://images-eu.ssl-images-amazon.com/images/I/51gzeynnm0L.jpg',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$9',
			),
		),
		
		// Product 19
		array(
			'tax_input' => array( 
				'shopr_category' => array('books'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'https://www.amazon.co.uk/gp/product/0261103253/ref=as_li_tl?ie=UTF8&camp=1634&creative=6738&creativeASIN=0261103253&linkCode=as2&tag=tanyaburr07d-21&linkId=53b81ee6b7abf93f5ba9d689d0a30e19',
				'shopr_product_linked_img' => 'https://images-eu.ssl-images-amazon.com/images/I/41HlaiDp5UL.jpg',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$11',
			),
		),
		
		// Product 20
		array(
			'tax_input' => array( 
				'shopr_category' => array('books'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'https://www.amazon.co.uk/gp/product/0241217938/ref=as_li_tl?ie=UTF8&camp=1634&creative=6738&creativeASIN=0241217938&linkCode=as2&tag=tanyaburr07d-21&linkId=acc7c9fb968adc02b607202ce73e71ff',
				'shopr_product_linked_img' => 'https://images-eu.ssl-images-amazon.com/images/I/51lkZbOi7VL.jpg',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$5',
			),
		),
		
		// Product 21
		array(
			'tax_input' => array( 
				'shopr_category' => array('books'), // array of tax names
			),
			'meta_input' => array( 
				'shopr_product_link' => 'https://www.amazon.co.uk/gp/product/1509836098/ref=as_li_ss_tl?pf_rd_m=A3P5ROKL5A1OLE&pf_rd_s=merchandised-search-8&pf_rd_r=99P7E2NS9GZA7ZANTXH8&pf_rd_r=99P7E2NS9GZA7ZANTXH8&pf_rd_t=101&pf_rd_p=c7dc4228-815a-57b9-a7c7-fb83db0160a1&pf_rd_p=c7dc4228-815a-57b9-a7c7-fb83db0160a1&pf_rd_i=74&linkCode=ll1&tag=tanyaburr07d-21&linkId=9b712b04fab08db05d9512dcb2d6567a&language=en_GB',
				'shopr_product_linked_img' => 'https://images-na.ssl-images-amazon.com/images/I/51F5HjaGymL.jpg',
				'shopr_product_subtitle' => '',
				'shopr_product_price' => '$5',
			),
		),
		
	);
	
	// mix em up
	shuffle($products);
	
	$x = 1;
	foreach ($products as $product) {
		$args = array(
			'post_title' => 'Example Product '.$x,
			'post_type' => 'shopr_product',
			'post_status' => 'publish',
			'tax_input' => $product['tax_input'],
			'meta_input' => $product['meta_input'],
		);
		wp_insert_post($args);
		$x++;
	}
	
	echo '<span class="dashicons dashicons-yes"></span> Products have been successfully imported! <a href="'.admin_url('edit.php?post_type=shopr_product').'">Click here</a> to access them.';

	wp_die();
}
add_action( 'wp_ajax_shopr_import_data', 'shopr_import_data_callback' );