<?php
get_header();
$home_layout = intval(get_theme_mod('home_layout', 6));
$category_layout = intval(get_theme_mod('category_layout', 6));
?>

	<?php if (get_theme_mod('top_slider') && (is_home() && !is_paged()) ) { ?>
		<?php get_template_part('inc/chunks/top-slider'); ?>
	<?php } // end if ?>

	<div class="row">
	
		<?php do_action('p3_main_row_start'); ?>
	
		<div id="content" class="<?php pipdig_left_or_right(); ?> content-area" role="main">
		
		<?php do_action('p3_posts_column_start'); ?>
		
		<?php if (is_category() && category_description()) { ?>
			<h1 class="entry-title"><?php echo single_cat_title(); ?></h1>
			<div class="cat_desk">
				<?php echo category_description(); ?>
			</div>
		<?php } ?>

		<?php if ( have_posts() ) { ?>
		
			<?php if ( (is_home() && ($home_layout == 6)) || ((is_archive() || is_search()) && ($category_layout == 6)) ) { // left/right ?>
			
				<?php while ( have_posts() ) : the_post(); ?>
					<?php get_template_part('content-left-right', get_post_format()); ?>
				<?php endwhile; ?>

			<?php } elseif ( (is_home() && ($home_layout == 3 || $home_layout == 5)) || ((is_archive() || is_search()) && ($category_layout == 3 || $category_layout == 5)) ) { // kensington ?>
				
				<?php while ( have_posts() ) : the_post(); ?>
					<?php if( $wp_query->current_post == 0 ) { ?>
						<?php get_template_part('content', get_post_format()); ?>
						<?php do_action( 'after_first_post' ); // after first post hook ?>
					<?php } else { ?>
						<?php get_template_part('content-grid', get_post_format()); ?>
					<?php } ?>
				<?php endwhile; ?>
				
			<?php } elseif ( (is_home() && ($home_layout == 10 || $home_layout == 10)) || ((is_archive() || is_search()) && ($category_layout == 10 || $category_layout == 10)) ) { // excerpt then left/right ?>
				
				<?php while ( have_posts() ) : the_post(); ?>
					<?php if( $wp_query->current_post == 0 ) { ?>
						<?php get_template_part('content', get_post_format()); ?>
						<?php do_action( 'after_first_post' ); // after first post hook ?>
					<?php } else { ?>
						<?php get_template_part('content-left-right', get_post_format()); ?>
					<?php } ?>
				<?php endwhile; ?>
			
			<?php } elseif ( (is_home() && ($home_layout == 4)) || ((is_archive() || is_search()) && ($category_layout == 4)) ) { // 2 col grid? ?>
				
				<?php while ( have_posts() ) : the_post(); ?>
					<?php get_template_part('content-grid', get_post_format()); ?>
				<?php endwhile; ?>
				
			<?php } elseif ( (is_home() && ($home_layout == 9)) || ((is_archive() || is_search()) && ($category_layout == 9)) ) { // 3 col grid? ?>
				
				<?php while ( have_posts() ) : the_post(); ?>
					<?php get_template_part('content-grid-2', get_post_format()); ?>
				<?php endwhile; ?>
				
			<?php } elseif ( (is_home() && ($home_layout == 8)) || ((is_archive() || is_search()) && ($category_layout == 8)) ) { // mosaic layout? not live ?>
				
				<?php while ( have_posts() ) : the_post(); ?>
					<?php get_template_part('content-mosaic', get_post_format()); ?>
				<?php endwhile; ?>
					
			<?php } elseif ( (is_home() && ($home_layout == 7)) || ((is_archive() || is_search()) && ($category_layout == 7)) ) { // floated summary layout? ?>
				
				<?php while ( have_posts() ) : the_post(); ?>
					<?php get_template_part('content-floated-summary', get_post_format()); ?>
				<?php endwhile; ?>
					
			<?php } else { ?>
				
				<?php while ( have_posts() ) : the_post(); ?>
					<?php get_template_part('content', get_post_format()); ?>					
					<?php if( $wp_query->current_post == 0 ) { // after first post hook ?>
						<?php do_action( 'after_first_post' ); ?>
					<?php } //end if ?>
				<?php endwhile; ?>
					
			<?php } // end if ?>

			
			<div class="clearfix"></div>
			<div class="next-prev-hider"><?php pipdig_content_nav('nav-below'); ?></div>
			<?php pipdig_pagination(); ?>

		<?php } else { ?>

			<?php get_template_part( 'content', 'none' ); ?>

		<?php } //endif ?>
		
		<?php do_action('p3_posts_column_end'); ?>

		</div><!-- .content-area -->

		<?php get_sidebar(); ?>
		
		<?php do_action('p3_main_row_end'); ?>

	</div>

<?php get_footer(); ?>
