<?php
if (!function_exists('pipdig_meta_boxes')) {
function pipdig_meta_boxes( $meta_boxes ) {
	$prefix = 'pipdig_meta_';

	// "Post Extras" Meta Box
	$meta_boxes[] = array(
		'id'       => 'post_extras',
		'title'    => __('Extra Post Options', 'pipdig-textdomain').' (pipdig)',
		'pages'    => 'post',
		'context'  => 'normal',
		'priority' => 'high',
		'fields' => array(
			array( // slider image
				'name'  => 'Image to use in the slider/banner',
				'desc'  => 'This image is displayed in the <a href="'.admin_url('customize.php?autofocus[section]=pipdig_header_full_width_slider').'">Full Width Slider</a> or <a href="'.admin_url('customize.php?autofocus[section]=pipdig_top_slider').'">Large Feature Slider</a>.<br />If no image is selected, then the <a href="https://support.pipdig.co/articles/wordpress-how-to-select-a-featured-image-for-a-post" target="_blank">Featured Image</a> for this post will be used instead.',
				'id'    => $prefix.'slider_image',
				'type'  => 'image_advanced',
				'max_file_uploads' => 1,
			),
			array( // sidebar
				'name'  => __('Sidebar position', 'pipdig-textdomain'),
				'id'    => $prefix.'post_sidebar_position',
				'type'  => 'image_select',
				'options' => array(
					'sidebar_right' => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHoAAAB6AgMAAAANN693AAAADFBMVEXn6Oj////t7u7z9PQ7CQrXAAAAUUlEQVRIx2MIxQsCCMrH/8cHAhgCGPCBUflR+VH5oSwftQofCKCwfMFu/nU4C7v7psFZo/Kj8qPyo/Kj8qPyo/Kj8qPyI00eW//0OpxFcfsUAPRDFitp8MRMAAAAAElFTkSuQmCC',
					'sidebar_left'  => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHoAAAB6AgMAAAANN693AAAADFBMVEXn6Oj////t7u7z9PQ7CQrXAAAAVUlEQVRIx2MIxQsCCMrH/8cHAhgCGPCBUflR+VH5oSwftQofCKC0fEGYv7YKm/kI93EmYHHfqPyo/Kj8qPyo/Kj8qPyo/Kj8SJOH90//1v/HBBS3TwFEJQc6A3xK1gAAAABJRU5ErkJggg==',
					'sidebar_none'  => 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAHoAAAB6AgMAAAANN693AAAADFBMVEXn6Oj////z9PTt7u5M1tw/AAAAQUlEQVRIx+3WoREAIBADwZQYg8HQH01CB0G8YGDu7Ko3P1GL+eh9piwrheP4yz5WysX/cv8+HMdxHMdx/C8v7tMNa4G2Y2L7ihAAAAAASUVORK5CYII=',
				),
			),
			array( // post location
				'name'  => __('Post Location', 'pipdig-textdomain'),
				'id'    => $prefix.'geographic_location',
				'placeholder' => __('e.g. London', 'pipdig-textdomain'),
				'type'  => 'text',
			),
			array( // post excerpt extra
				'name'  => __('Extra Post Excerpt ("Left/Right" or "Excerpt" Post Layout only)', 'pipdig-textdomain'),
				'desc'  => 'You can use this field to display extra information in the Left/Right post layout.<br />For example, you may wish to display a <a href="'.esc_url('https://support.pipdig.co/articles/blogger-how-do-i-setup-a-shop-the-post-feature-or-ecommerce/').'" target="_blank">Shop the Post widget</a> on your homepage for this post (<a href="'.esc_url('http://imgur.com/a/QMmoB').'" target="_blank">example here</a>). This field can include HTML/Javascript or Shortcodes.',
				'id'    => $prefix.'extra_excerpt',
				'type'  => 'textarea',
			),
			array(
			'name'  => __('Disclaimer to display in footer', 'pipdig-textdomain'),
			'id'    => $prefix.'post_disclaimer',
			'type'  => 'wysiwyg',
			'raw'	=> true,
			'options' => array(
					'media_buttons' => false,
					'dfw'  => false,
					'quicktags'  => false,
					'teeny'  => true,
					'textarea_rows'  => 2,
				),
			),
			array(
				'name'  => "Also display the disclaimer at the top of the post",
				'id'    => $prefix.'post_disclaimer_top',
				'type'  => 'checkbox',
			),
		)
	);
		
	return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'pipdig_meta_boxes' );
}

// image gallery meta
if (!function_exists('pipdig_meta_boxes_pages')) {
function pipdig_meta_boxes_pages( $meta_boxes ) {
	
	$prefix = 'pipdig_meta_';

	// "Post Extras" Meta Box
	$meta_boxes[] = array(
		'id'		=> 'page_extras',
		'title'		=> 'Image Gallery',
		'pages'		=> 'page',
		'include'	=> array(
			'template' => 'template-gallery.php',
		),
		'context'	=> 'normal',
		'priority'	=> 'high',
		'fields'	=> array(
			array(
				'name'  => 'Gallery images for this page',
				//'desc'  => '',
				'id'    => $prefix.'gallery_images',
				'type'  => 'image_advanced',
				//'max_file_uploads' => 1,
			),
		)
	);
	
	return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'pipdig_meta_boxes_pages' );
}

// function to return rs category featured image - param = rs category slug
if (!function_exists('pipdig_cat_image_src')) {
function pipdig_cat_image_src($cat_slug) {
	
	// get reward style category ID	from slug - https://codex.wordpress.org/Function_Reference/get_term_by
	$term_data = get_term_by('slug', $cat_slug, 'category', 'ARRAY_A' );
	
	// take ID from array of results
	$rs_cat_id = absint($term_data['term_id']);
	
	// get image ID from reward style category ID.
	// https://metabox.io/docs/mb-term-meta/
    $image_id = get_term_meta( $rs_cat_id, 'cat_image', true );
	
	// use image ID to grab image src
	$image_data = wp_get_attachment_image_src( $image_id, 'large' );
    $image_src = esc_url($image_data[0]);
	
	return $image_src;
}
}



if (!function_exists('pipdig_post_meta_boxes_shopr')) {
function pipdig_post_meta_boxes_shopr( $meta_boxes ) {
	
	if (!function_exists('is_shopr_active')) {
		return $meta_boxes;
	}
	
	$prefix = 'pipdig_meta_';
	
	$meta_boxes[] = array(
		'id'       => 'post_shopr',
		'title'    => 'Shopr Products',
		'pages'    => 'post',
		'context'  => 'side',
		'priority' => 'low',
		'fields' => array(
			array(
				'name'  => "Product Collection",
				'desc'  => 'Display products from this collection in a "Shop the post" carousel on the homepage. <a href="https://i.imgur.com/JSBp9kQ.png" target="_blank" rel="noopener">Click here</a> for an example.',
				'id'    => $prefix.'shopr_collection',
				'taxonomy' => 'shopr_category',
				'type'  => 'taxonomy_advanced',
			),
			array(
				'name'  => "Widget Title",
				'id'    => $prefix.'shopr_title',
				'type'  => 'text',
			),
		)
	);
		
	return $meta_boxes;
}
add_filter( 'rwmb_meta_boxes', 'pipdig_post_meta_boxes_shopr' );
}