<?php

if (!defined('ABSPATH')) die;

function pipdig_deactivate_ocdi() {
	if (!class_exists('OCDI_Plugin')) {
		return;
	}
	if ( (get_option('p3_demo_imported') == 1) && (get_option('p3_demo_imported_override') != 1) ) {
		deactivate_plugins('one-click-demo-import/one-click-demo-import.php');
		update_option('p3_demo_imported_override', 1);
	}
}
add_action('admin_init', 'pipdig_deactivate_ocdi');

// import config
function pipdig_oneclick_import_files() {
	$message = "We recommend that you only import the demo content if you are starting a brand new site. Are you sure?";
	return array(
		array(
			'import_file_name' => 'Basic Demo Content',
			'import_file_url' => 'https://www.dropbox.com/s/g1d0cbx0ss11rlz/20%20posts.xml?dl=1',
			'import_widget_file_url' => 'https://www.dropbox.com/s/jeql8l3vxycvf0z/standard-widgets.wie?dl=1',
			//'import_customizer_file_url' => 'https://www.dropbox.com/s/znoilzctov8pev9/customizer.dat?dl=1',
			//'import_preview_image_url' => 'https://www.pipdig.co/delta/uploads/wordpress_theme_equinox-2-1-540x540.jpg',
			'import_notice'	=> $message,
			'preview_url' => 'https://equinox.pipdig.co/',
		)
	);
}
add_filter( 'pt-ocdi/import_files', 'pipdig_oneclick_import_files' );

// set some options before import starts
function pipdig_ocdi_before_import() {
	
	// remove theme mods
	remove_theme_mods();
	
	// deactivate widgets (move them to inactive area)
	update_option('sidebars_widgets', array());

}
add_action( 'pt-ocdi/before_content_import', 'pipdig_ocdi_before_import' );

// set some options after import compeltes
function pipdig_ocdi_after_import_setup() {
	
	// remove current menus
	remove_theme_mod('nav_menu_locations');
	
	// set demo menus
	$primary_menu = get_term_by('name', 'Primary', 'nav_menu');
	//$footer_menu = get_term_by('name', 'Footer', 'nav_menu');
	set_theme_mod('nav_menu_locations', array(
			'primary' => $primary_menu->term_id,
			//'footer' => $footer_menu->term_id,
		)
	);
	
	set_theme_mod('header_full_width_slider', 1);
	set_theme_mod('header_full_width_slider_home', 1);
	set_theme_mod('p3_instagram_footer', 1);
	
	set_theme_mod('pipdig_lazy', 1);
	set_theme_mod('p3_pinterest_hover_image_file','https://sites.google.com/site/pipdig1/equinox-pin.png');
	set_theme_mod('p3_pinterest_hover_image_position','center');
	set_theme_mod('p3_share_tumblr', '');
	set_theme_mod('p3_share_title', ' ');
	set_theme_mod('site_top_search', 1);
	
	// remove any homepage settings
	update_option('show_on_front', 'posts');
	delete_option('page_on_front');
	delete_option('page_for_posts');
	update_option('posts_per_page', 5);
	
	global $wp_rewrite;
	$wp_rewrite->set_permalink_structure('/%postname%/');
	flush_rewrite_rules();
	
	update_option('p3_auto_updates_on', 1);
	update_option('p3_demo_imported', 1);
	update_option('p3_demo_imported_override', 0);

}
add_action( 'pt-ocdi/after_import', 'pipdig_ocdi_after_import_setup' );

// intro text
function ocdi_plugin_intro_text($default_text) {
	$default_text = '
	<div style="background: #fff; margin: 30px 0; padding: 5px 20px; border: 1px solid #ddd">
	<p>You can use the options below to import the content from our preview sites. <a href="https://go.pipdig.co/open.php?id=demo-content" target="_blank" rel="noopener">Click here</a> for more information.</p>
	</div>';
	return $default_text;
}
add_filter( 'pt-ocdi/plugin_intro_text', 'ocdi_plugin_intro_text' );

function pipdig_ocdi_plugin_page_setup($default_settings) {
	$default_settings['parent_slug'] = 'themes.php';
	$default_settings['page_title'] = 'Import Demo Content';
	$default_settings['menu_title'] = 'Import Demo Content';
	$default_settings['capability'] = 'import';
	$default_settings['menu_slug'] = 'pipdig-demo-import';
	return $default_settings;
}
add_filter( 'pt-ocdi/plugin_page_setup', 'pipdig_ocdi_plugin_page_setup' );

// remove branding
add_filter( 'pt-ocdi/disable_pt_branding', '__return_true' );

// stop generation of thumbnails. quicker imports.
add_filter( 'pt-ocdi/regenerate_thumbnails_in_content_import', '__return_false' );