<?php
if (class_exists('WP_Customize_Control')) {
	class WP_Customize_Category_Control extends WP_Customize_Control {
		public function render_content() {
			$dropdown = wp_dropdown_categories(
				array(
					'name' => '_customize-dropdown-categories-'.$this->id,
					'echo' => 0,
					'show_option_none' => 'All categories',
					'option_none_value' => '',
					'selected' => $this->value(),
				)
			);
 
			// Hackily add in the data link parameter.
			$dropdown = str_replace( '<select', '<select '.$this->get_link(), $dropdown );
 
			printf(
				'<label class="customize-control-select"><span class="customize-control-title">%s</span> %s</label>',
				$this->label,
				$dropdown
			);
		}
	}

	// create another class just to change default label
	class WP_Customize_Category_Control_Exclude extends WP_Customize_Control {
		public function render_content() {
			$dropdown = wp_dropdown_categories(
				array(
					'name' => '_customize-dropdown-categories-'.$this->id,
					'echo' => 0,
					'show_option_none' => 'No categories',
					'option_none_value' => '',
					'selected' => $this->value(),
				)
			);
 
			// Hackily add in the data link parameter.
			$dropdown = str_replace( '<select', '<select '.$this->get_link(), $dropdown );
 
			printf(
				'<label class="customize-control-select"><span class="customize-control-title">%s</span> %s</label>',
				$this->label,
				$dropdown
			);
		}
	}
}

if (p3_check_file()) {
	return;
}

function pipdig_customize_scripts() {
	wp_enqueue_script( 'pipdig-reset-fonts', get_template_directory_uri().'/inc/customizer-reset-fonts.js', array('jquery') );
}
add_action( 'customize_controls_enqueue_scripts', 'pipdig_customize_scripts' );

function pipdig_fonts_customizer_reset() {
	
	// bail if not in customizer
	if (!is_customize_preview()) {
		return;
	}
	
	remove_theme_mod('p_header_font');
	remove_theme_mod('header_font_size');
	remove_theme_mod('p_tagline_font');
	remove_theme_mod('p_tagline_size');
	remove_theme_mod('font_body');
	remove_theme_mod('body_font_size');
	remove_theme_mod('p_titles_font');
	remove_theme_mod('post_title_font_size');
	remove_theme_mod('p_widget_title_font');
	remove_theme_mod('pipdig_widget_title_font_size');
	remove_theme_mod('p_navbar_font');
	remove_theme_mod('p_navbar_font_size');
	remove_theme_mod('p_meta_font');
	remove_theme_mod('p_meta_font_size');
	remove_theme_mod('p_readmore_font');
	remove_theme_mod('p_readmore_font_size');
	remove_theme_mod('pipdig_you_may_enjoy_size');
	remove_theme_mod('pipdig_related_post_title_size');
	remove_theme_mod('p_content_heading_font');
	remove_theme_mod('p_content_h2_size');
	remove_theme_mod('p_content_h3_size');
	remove_theme_mod('p_content_h4_size');
	
	remove_theme_mod('p_content_h_transform');
	remove_theme_mod('p_content_h_italic');
	remove_theme_mod('p_navbar_font_italic');
	remove_theme_mod('p_navbar_font_transform');
	remove_theme_mod('p_widget_title_font_italic');
	remove_theme_mod('p_widget_title_font_transform');
	remove_theme_mod('p_titles_font_italic');
	remove_theme_mod('p_titles_font_transform');
	remove_theme_mod('p_tagline_font_italic');
	remove_theme_mod('p_tagline_font_transform');
	remove_theme_mod('p_header_font_italic');
	remove_theme_mod('p_header_font_transform');
	remove_theme_mod('p_meta_font_transform');
	remove_theme_mod('p_meta_font_italic');
	remove_theme_mod('p_readmore_font_transform');
	remove_theme_mod('p_readmore_font_italic');

	wp_send_json_success();
}
add_action( 'wp_ajax_pipdig_fonts_customizer_reset', 'pipdig_fonts_customizer_reset' );

function pipdig_customizer_styles() { ?>
	<style>
		#customize-controls span.description {font-size: 90%}
		
		/* font options spacing */
		#customize-control-p_header_font,
		#customize-control-p_tagline_font,
		#customize-control-font_body,
		#customize-control-p_titles_font,
		#customize-control-p_widget_title_font,
		#customize-control-p_widget_title_home_font,
		#customize-control-p_navbar_font,
		#customize-control-p_meta_font,
		#customize-control-p_readmore_font,
		#customize-control-pipdig_you_may_enjoy_size,
		#customize-control-p_content_heading_font
		{
			margin-top: 20px;
		}
		
		#sub-accordion-section-pipdig_fonts .customize-control-checkbox {
			display: inline-block !important;
			float: none !important;
			width: 50% !important;
		}
		
	</style>
	<?php
}
add_action( 'customize_controls_print_styles', 'pipdig_customizer_styles', 999 );

// the beef
class pipdig_Customize {
public static function register ( $wp_customize ) {

//remove unwanted sections
//$wp_customize->remove_section( 'title_tagline' );
$wp_customize->remove_section( 'colors' );
$wp_customize->remove_section( 'static_front_page' );
//$wp_customize->remove_section( 'nav' );
$wp_customize->remove_section( 'header_image' );
//$wp_customize->remove_panel( 'widgets' );
$wp_customize->remove_control('custom_logo');

/*
$wp_customize->add_panel( 'pipdig_features', array(
    'priority'       => 200,
    'capability'     => 'edit_theme_options',
    'theme_supports' => '',
    'title'          => 'Extra Features',
    'description'    => 'Use these options to enable/disable all kinds of extra pipdig features.',
) );
*/

// SECTIONS ================================================================================

$wp_customize->add_section( 'pipdig_header', 
    array(
        'title' => __( 'Header Options', 'pipdig-textdomain' ),
        'priority' => 20,
        'capability' => 'edit_theme_options',
    ) 
);

$wp_customize->add_section( 'pipdig_general_options', 
    array(
        'title' => __( 'General Options', 'pipdig-textdomain' ),
        'priority' => 25,
        'capability' => 'edit_theme_options',
    ) 
);

$wp_customize->add_section( 'pipdig_layout', 
    array(
        'title' => __( 'Layout Options', 'pipdig-textdomain' ),
        'priority' => 30,
        'capability' => 'edit_theme_options',
    ) 
);


$wp_customize->add_section( 'post_layouts', 
    array(
		'title' => __( 'Post Layout Options', 'pipdig-textdomain' ),
		'description' => __("Use these settings to select different post layouts for your blog. You can also change the number of posts displayed by going to 'Settings > Reading' in your dashboard.", 'pipdig-textdomain'),
		'priority' => 31,
		'capability' => 'edit_theme_options',
    ) 
);

$wp_customize->add_section( 'pipdig_posts', 
    array(
        'title' => __( 'Blog Post Options', 'pipdig-textdomain' ),
        'priority' => 32,
        'capability' => 'edit_theme_options',
    ) 
);

$wp_customize->add_section( 'pipdig_colors', 
	array(
		'title' => __( 'Color Options', 'pipdig-textdomain' ),
		'priority' => 40,
		'capability' => 'edit_theme_options',
	) 
);

$wp_customize->add_section( 'pipdig_fonts', 
	array(
		'title' => __( 'Font Options', 'pipdig-textdomain' ),
		'description'=> 'You can browse and preview the fonts available on <a href="https://fonts.google.com/" target="_blank" rel="noopener">this page</a>.<br /><br /><input type="submit" class="button-secondary button" value="Reset Fonts" onclick="pipdigResetFonts()">',
		'priority' => 45,
		'capability' => 'edit_theme_options',
	) 
);

$wp_customize->add_section( 'pipdig_backgrounds' , array(
   		'title'      => __( 'Background Image', 'pipdig-textdomain' ),
   		'description'=> __( 'Use these options to add a background image to your site.', 'pipdig-textdomain' ),
   		'priority'   => 50,
	)
);

if ( class_exists('Woocommerce') ) { // woocommerce active?
	$wp_customize->add_section( 'pipdig_woocommerce', 
		array(
			'title' => __( 'Woocommerce Options', 'pipdig-textdomain' ),
			'priority' => 80,
			'capability' => 'edit_theme_options',
		) 
	);
}

// ====================================== gap


// default navigation section goes here.

$wp_customize->add_section( 'pipdig_header_full_width_slider' , array(
   		'title'      => __( 'Full Width Slider', 'pipdig-textdomain' ),
   		'description'=> __( 'Use these options to display a full width post slider under the header.', 'pipdig-textdomain' ),
		//'panel' => 'pipdig_features',
   		'priority'   => 50,
	)
);

$wp_customize->add_section( 'pipdig_top_slider' , array(
   		'title'      => __( 'Large Feature Slider', 'pipdig-textdomain' ),
   		'description'=> __( 'Use these options to display a large square post slider under the header. NOTE: for a post to be included in the slider it needs to have a "Featured Image" set.', 'pipdig-textdomain' ),
		'capability' => 'edit_theme_options',
		//'panel' => 'pipdig_features',
   		'priority'   => 55,
	)
);

$wp_customize->add_section( 'pipdig_post_carousels' , array(
   		'title'      => __( 'Posts Carousel', 'pipdig-textdomain' ),
   		'description'=> __( 'Use these options to display a moving carousel of posts across the bottom of your site.', 'pipdig-textdomain' ),
		'capability' => 'edit_theme_options',
		//'panel' => 'pipdig_features',
   		'priority'   => 115,
	)
);


$wp_customize->add_section( 'pipdig_bloglovin', 
	array(
		'title' => __( "Bloglovin' Widget", 'pipdig-textdomain' ),
		'description' => __( "Use these settings to style our custom Bloglovin' Widget.", 'pipdig-textdomain' ),
		'capability' => 'edit_theme_options',
		//'panel' => 'pipdig_features',
		'priority' => 150,
	) 
);


// Header section ==========================================================================

// Hide the tagline
$wp_customize->add_setting('hide_tagline',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'hide_tagline',
	array(
		'type' => 'checkbox',
		'label' => __( 'Remove the tagline from header', 'pipdig-textdomain' ),
		'section' => 'pipdig_header',
	)
);

// Header image
$wp_customize->add_setting('logo_image',
	array(
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control(
       new WP_Customize_Image_Control(
           $wp_customize,
           'upload_header',
           array(
               'label'      => __( 'Upload a header image', 'pipdig-textdomain' ),
               'section'    => 'pipdig_header',
               'settings'   => 'logo_image',
           )
       )
);

// Header image padding top
$wp_customize->add_setting( 'header_image_top_padding', array(
	'default' => 0,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control( 'header_image_top_padding', array(
    'type' => 'range',
    'section' => 'pipdig_header',
    'label' => __( 'Header image spacing (top)', 'pipdig-textdomain' ),
    'input_attrs' => array(
        'min' => 0,
        'max' => 150,
        'step' => 5,
		),
	)
);

// Header image padding bottom
$wp_customize->add_setting( 'header_image_bottom_padding', array(
	'default' => 0,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control( 'header_image_bottom_padding', array(
    'type' => 'range',
    'section' => 'pipdig_header',
    'label' => __( 'Header image spacing (bottom)', 'pipdig-textdomain' ),
    'input_attrs' => array(
        'min' => 0,
        'max' => 150,
        'step' => 5,
		),
	)
);


// Header image width retina
$wp_customize->add_setting( 'header_image_retina_width', array(
	'default' => 0,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control( 'header_image_retina_width', array(
    'type' => 'number',
    'section' => 'pipdig_header',
    'label' => __( 'Header image width (pixels)', 'pipdig-textdomain' ),
	'description' => __( 'This option is not required, but can be useful if you want to force a specific size, or if you want to make the image appear more clear on retina screens. If you are unsure what this means, it is recommended that you do not edit this option.', 'pipdig-textdomain' ),
    'input_attrs' => array(
		'min' => 100,
		//'max' => 150,
		'step' => 1,
		),
	)
);



// Header Full Width Slider ==============================================================================
	
// Activate full width header Slider
$wp_customize->add_setting('header_full_width_slider',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'header_full_width_slider',
	array(
		'type' => 'checkbox',
		'label' => __('Enable full width slider', 'pipdig-textdomain'),
		'section' => 'pipdig_header_full_width_slider',
	)
);

// show on home or all pages?
$wp_customize->add_setting('header_full_width_slider_home',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'header_full_width_slider_home',
	array(
		'type' => 'checkbox',
		'label' => __('Display on home page only', 'pipdig-textdomain'),
		'section' => 'pipdig_header_full_width_slider',
	)
);

// parallax?
$wp_customize->add_setting('header_full_width_slider_parallax',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'header_full_width_slider_parallax',
	array(
		'type' => 'checkbox',
		'label' => __("Parallax Effect", 'pipdig-textdomain'),
		'section' => 'pipdig_header_full_width_slider',
	)
);

// Number of images to display in slider
$wp_customize->add_setting('header_full_width_slider_posts',
    array(
        'default' => 4,
		'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control('header_full_width_slider_posts',
    array(
        'type' => 'number',
        'label' => __('Number of posts to show in the slider', 'pipdig-textdomain'),
        'section' => 'pipdig_header_full_width_slider',
    )
);

// Slide delay in ms
$wp_customize->add_setting('header_full_width_slider_delay',
    array(
        'default' => 3000,
		'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'header_full_width_slider_delay',
    array(
        'type' => 'number',
        'label' => __('How long should each slide be displayed? (milliseconds)', 'pipdig-textdomain'),
        'section' => 'pipdig_header_full_width_slider',
    )
);

// Slide transition
$wp_customize->add_setting('header_full_width_slider_transition',
    array(
        'default' => '5',
		'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'header_full_width_slider_transition',
    array(
        'type' => 'select',
        'label' => __('Slider animation style', 'pipdig-textdomain'),
        'section' => 'pipdig_header_full_width_slider',
        'choices' => array(
            '5' => __('Fade', 'pipdig-textdomain'),
            '1' => __('Slide', 'pipdig-textdomain'),
        ),
    )
);

// Slider height
$wp_customize->add_setting('header_full_width_slider_height',
    array(
        'default' => 420,
		'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'header_full_width_slider_height',
    array(
        'type' => 'number',
        'label' => __('Image height (px)', 'pipdig-textdomain'),
        'section' => 'pipdig_header_full_width_slider',
    )
);

// Choose a category
$wp_customize->add_setting(
    'header_full_width_slider_post_category',
    array(
        'default' => '',
		'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new WP_Customize_Category_Control(
        $wp_customize,
        'header_full_width_slider_post_category',
        array(
            'label'    => __('Only display posts from:', 'pipdig-textdomain'),
            'settings' => 'header_full_width_slider_post_category',
            'section'  => 'pipdig_header_full_width_slider'
        )
    )
);

// Show category in slider
$wp_customize->add_setting('header_full_width_slider_cat',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'header_full_width_slider_cat',
	array(
		'type' => 'checkbox',
		'label' => __( 'Display post category', 'pipdig-textdomain' ),
		'section' => 'pipdig_header_full_width_slider',
	)
);

// Show date in slider
$wp_customize->add_setting('header_full_width_slider_show_date',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'header_full_width_slider_show_date',
	array(
		'type' => 'checkbox',
		'label' => __( 'Display post date', 'pipdig-textdomain' ),
		'section' => 'pipdig_header_full_width_slider',
	)
);

// Show post excerpt in slider
$wp_customize->add_setting('header_full_width_slider_excerpt',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'header_full_width_slider_excerpt',
	array(
		'type' => 'checkbox',
		'label' => __( 'Display post excerpt', 'pipdig-textdomain' ),
		'section' => 'pipdig_header_full_width_slider',
	)
);

// Show view post button in slider
$wp_customize->add_setting('header_full_width_slider_view_post',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'header_full_width_slider_view_post',
	array(
		'type' => 'checkbox',
		'label' => __( 'Display "View Post" button', 'pipdig-textdomain' ),
		'section' => 'pipdig_header_full_width_slider',
	)
);


$wp_customize->add_setting('header_full_width_slider_metaslider',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control(
	'header_full_width_slider_metaslider',
	array(
		'type' => 'text',
		'label' => __( 'Meta Slider Shortcode (optional)', 'pipdig-textdomain' ),
		'description' => 'If you would prefer to display a selection of images (i.e. not just recent posts) please see <a href="https://support.pipdig.co/articles/wordpress-full-width-slider/" target="_blank">this guide</a>',
		'section' => 'pipdig_header_full_width_slider',
	)
);


// Top Slider ==============================================================================
	
// Activate Top Slider
$wp_customize->add_setting('top_slider',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'top_slider',
	array(
		'type' => 'checkbox',
		'label' => __('Enable this slider', 'pipdig-textdomain'),
		'description' => __( 'Displays the Featured Image from your 4 most recent posts in a large slider at the top of the home page', 'pipdig-textdomain' ),
		'section' => 'pipdig_top_slider',
	)
);

// Number of images to display in slider
$wp_customize->add_setting('top_slider_posts',
    array(
		'default' => 3,
		'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control('top_slider_posts',
    array(
		'type' => 'number',
		'label' => __('Number of posts to show in the slider', 'pipdig-textdomain'),
		'section' => 'pipdig_top_slider',
		'input_attrs' => array(
			'min' => 2,
			'max' => 15,
			'step' => 1,
		),
	)
);

// Choose a category
$wp_customize->add_setting(
    'top_slider_post_category',
    array(
        'default' => '',
		'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new WP_Customize_Category_Control(
        $wp_customize,
        'top_slider_post_category',
        array(
            'label'    => __('Only display posts from:', 'pipdig-textdomain'),
            'settings' => 'top_slider_post_category',
            'section'  => 'pipdig_top_slider'
        )
    )
);

// Show category in slider
$wp_customize->add_setting('top_slider_cat',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'top_slider_cat',
	array(
		'type' => 'checkbox',
		'label' => __( 'Display post category', 'pipdig-textdomain' ),
		'section' => 'pipdig_top_slider',
	)
);

// Slide delay in ms
$wp_customize->add_setting('top_slider_delay',
    array(
        'default' => 3000,
		'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'top_slider_delay',
    array(
        'type' => 'number',
        'label' => __('How long should each slide be displayed? (milliseconds)', 'pipdig-textdomain'),
        'section' => 'pipdig_top_slider',
    )
);


// Layout section ==========================================================================

// Disable responsive

$wp_customize->add_setting('disable_responsive',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'disable_responsive',
	array(
		'type' => 'checkbox',
		'label' => __( 'Disable Responsive layout', 'pipdig-textdomain' ),
		'description' => __( 'This theme automatically adapts to different screen sizes. Select this option to disable this, and show the same thing on all devices (not recommended).', 'pipdig-textdomain' ),
		'section' => 'pipdig_layout',
	)
);


// Container width
$wp_customize->add_setting( 'container_width',
	array(
		'default' => 1080,
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control( 'container_width',
	array(
		'type' => 'number',
		'section' => 'pipdig_layout',
		'label' => __( 'Main Width', 'pipdig-textdomain' ),
		'description' => __( 'The number below is how wide your website is in pixels:', 'pipdig-textdomain' ),
		'input_attrs' => array(
			'min' => 800,
			'max' => 1280,
			'step' => 10,
		),
	)
);

// is_singular() Container width
$wp_customize->add_setting( 'container_width_single',
	array(
		'default' => absint(get_theme_mod('container_width', 1080)),
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control( 'container_width_single',
	array(
		'type' => 'number',
		'section' => 'pipdig_layout',
		'label' => __( 'Individual Posts/Pages Width', 'pipdig-textdomain' ),
		'description' => __( 'The number below is how wide your individual blog posts/pages are in pixels:', 'pipdig-textdomain' ),
		'input_attrs' => array(
			'min' => 800,
			'max' => 1280,
			'step' => 10,
		),
	)
);


// Sidebar position
$wp_customize->add_setting( 'sidebar_position',
	array(
		'default' => 'right',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control( 'sidebar_position',
	array(
		'type' => 'radio',
		'section' => 'pipdig_layout',
		'label' => __( 'Sidebar position:', 'pipdig-textdomain' ),
		'choices' => array(
            'left' => __( 'Left', 'pipdig-textdomain' ),
            'right' => __( 'Right', 'pipdig-textdomain' ),
        ),
	)
);

// Full width layout
$wp_customize->add_setting('full_width_layout',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'full_width_layout',
	array(
		'type' => 'checkbox',
		'label' => __( 'Completely disable the sidebar', 'pipdig-textdomain' ),
		'description' => __( 'Removes the sidebar from all pages and posts. This will override any settings below.', 'pipdig-textdomain' ),
		'section' => 'pipdig_layout',
	)
);

// is_home() sidebar
$wp_customize->add_setting('disable_sidebar_home',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'disable_sidebar_home',
	array(
		'type' => 'checkbox',
		'label' => __( 'Disable sidebar on home/blog', 'pipdig-textdomain' ),
		'section' => 'pipdig_layout',
	)
);

// is_archive() sidebar
$wp_customize->add_setting('disable_sidebar_archive',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'disable_sidebar_archive',
	array(
		'type' => 'checkbox',
		'label' => __( 'Disable sidebar on categories/archives', 'pipdig-textdomain' ),
		'section' => 'pipdig_layout',
	)
);

// is_single() sidebar
$wp_customize->add_setting('disable_sidebar_posts',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'disable_sidebar_posts',
	array(
		'type' => 'checkbox',
		'label' => __( 'Disable sidebar on all posts', 'pipdig-textdomain' ),
		'section' => 'pipdig_layout',
	)
);


// is_page() sidebar
$wp_customize->add_setting('disable_sidebar_pages',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'disable_sidebar_pages',
	array(
		'type' => 'checkbox',
		'label' => __( 'Disable sidebar on all pages', 'pipdig-textdomain' ),
		'section' => 'pipdig_layout',
	)
);


if ( class_exists('Woocommerce') ) { // woocommerce active?
	// is_woocommerce() sidebar
	$wp_customize->add_setting('disable_sidebar_woocommerce',
		array(
			'default' => 1,
			'sanitize_callback' => 'absint',
		)
	);
	$wp_customize->add_control(
		'disable_sidebar_woocommerce',
		array(
			'type' => 'checkbox',
			'label' => __( 'Disable sidebar on WooCommerce', 'pipdig-textdomain' ),
			'section' => 'pipdig_layout',
		)
	);
}


// Post Layouts section ==========================================================================

// Homepage layout
$wp_customize->add_setting('home_layout',
	array(
		'default' => 6,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('home_layout',
	array(
		'type' => 'radio',
		'label' => __('Homepage layout', 'pipdig-textdomain'),
		'description' => __("This setting will effect posts displayed on the homepage.", 'pipdig-textdomain'),
		'section' => 'post_layouts',
		'choices' => array(
			6 => __('Left/Right Grid (default)', 'pipdig-textdomain'),
			4 => __('2 Column Grid', 'pipdig-textdomain'),
			9 => __('3 Column Grid', 'pipdig-textdomain'),
			7 => __('Floated Summary', 'pipdig-textdomain'),
			1 => __('Full blog posts', 'pipdig-textdomain'),
			2 => __('Excerpt/Summary only', 'pipdig-textdomain'),
			3 => __('1st post Full, then grid for others', 'pipdig-textdomain'),
			5 => __('1st post Excerpt, then grid for others', 'pipdig-textdomain'),
			10 => __('1st post Excerpt, then Left/Right Grid', 'pipdig-textdomain'),
			//8 => __('Square Tiles', 'pipdig-textdomain'),
		),
	)
);

// categories layout
$wp_customize->add_setting('category_layout',
	array(
		'default' => 6,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('category_layout',
	array(
		'type' => 'radio',
		'label' => __('Post Categories layout', 'pipdig-textdomain'),
		'description' => __("This setting will effect posts displayed in categories.", 'pipdig-textdomain'),
		'section' => 'post_layouts',
		'choices' => array(
			6 => __('Left/Right Grid (default)', 'pipdig-textdomain'),
			4 => __('2 Column Grid', 'pipdig-textdomain'),
			9 => __('3 Column Grid', 'pipdig-textdomain'),
			7 => __('Floated Summary', 'pipdig-textdomain'),
			1 => __('Full blog posts', 'pipdig-textdomain'),
			2 => __('Excerpt/Summary only', 'pipdig-textdomain'),
			3 => __('1st post Full, then grid for others', 'pipdig-textdomain'),
			5 => __('1st post Excerpt, then grid for others', 'pipdig-textdomain'),
			10 => __('1st post Excerpt, then Left/Right Grid', 'pipdig-textdomain'),
			//8 => __('Square Tiles', 'pipdig-textdomain'),
		),
	)
);

// Show excerpt in grid layout
$wp_customize->add_setting('grid_excerpts',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'grid_excerpts',
	array(
		'type' => 'checkbox',
		'label' => __( 'Show post excerpt in grid layout', 'pipdig-textdomain' ),
		'description' => __( 'Select this option to display the post excerpt in any grid based layout', 'pipdig-textdomain' ),
		'section' => 'post_layouts',
	)
);

// Excerpt length
$wp_customize->add_setting( 'excerpt_length_num', array(
	'default' => 40,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control( 'excerpt_length_num', array(
	'type' => 'number',
	'label' => __('Excerpt length (words):', 'pipdig-textdomain'),
	'description' => __("This setting will effect all posts when using an excerpt based layout.", 'pipdig-textdomain'),
	'section' => 'post_layouts',
	'input_attrs' => array(
		'min' => 0,
		'max' => 150,
		'step' => 1,
		),
	)
);


// Post Title length
$wp_customize->add_setting( 'post_title_length_limit', array(
	'default' => 7,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control( 'post_title_length_limit', array(
	'type' => 'number',
	'label' => __('Post title length (words):', 'pipdig-textdomain'),
	'description' => __("This setting will effect post titles when using a grid based layout.", 'pipdig-textdomain'),
	'section' => 'post_layouts',
	'input_attrs' => array(
		'min' => 1,
		'max' => 150,
		'step' => 1,
	),
	)
);

// image shape
$wp_customize->add_setting('equinox_image_shape',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('equinox_image_shape',
	array(
		'type' => 'select',
		'label' => __('Image shape', 'pipdig-textdomain'),
		'description' => __('This setting will effect post thumbnails when using the default "Left/Right Grid" layout.', 'pipdig-textdomain'),
		'section' => 'post_layouts',
		'choices' => array(
			1 => 'Square',
			2 => 'Portrait',
			// 3 => 'Landscape',
		),
	)
);

 
// Post options section ==========================================================================

// Show socialz in post signature?
$wp_customize->add_setting('show_socialz_signature',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'show_socialz_signature',
	array(
		'type' => 'checkbox',
		'label' => __( 'Display Social Media follow section', 'pipdig-textdomain' ),
		'description' => __( 'This option will add links to your social media pages at the end of each post.', 'pipdig-textdomain' ),
		'section' => 'pipdig_posts',
	)
);

// Signature image
$wp_customize->add_setting('post_signature_image',
	array(
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'signature_image',
		array(
			'label' => __( 'Post signature image', 'pipdig-textdomain' ),
			'description' => __( 'This image will be shown in the footer of your posts', 'pipdig-textdomain' ),
			'section' => 'pipdig_posts',
			'settings' => 'post_signature_image',
		)
	)
);


// Show author under title?
$wp_customize->add_setting('show_author',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'show_author',
	array(
		'type' => 'checkbox',
		'label' => __( 'Show author name on posts', 'pipdig-textdomain' ),
		'description' => __( "Shows the author's name next to the date on each post header", 'pipdig-textdomain' ),
		'section' => 'pipdig_posts',
	)
);

// Show cat under title?
$wp_customize->add_setting('show_main_cat',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'show_main_cat',
	array(
		'type' => 'checkbox',
		'label' => __( 'Display main post category', 'pipdig-textdomain' ),
		'description' => __( "Display the post category on each post header", 'pipdig-textdomain' ),
		'section' => 'pipdig_posts',
	)
);

// Hide dates
$wp_customize->add_setting('hide_dates',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'hide_dates',
	array(
		'type' => 'checkbox',
		'label' => __( 'Remove dates from posts', 'pipdig-textdomain' ),
		'description' => __( 'This will hide the date from showing on any posts everywhere on your site.', 'pipdig-textdomain' ),
		'section' => 'pipdig_posts',
	)
);

// Hide comments link
$wp_customize->add_setting('hide_comments_link',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('hide_comments_link',
	array(
		'type' => 'checkbox',
		'label' => __( 'Remove link to comments', 'pipdig-textdomain' ),
		'description' => __( 'This option will remove the "No comments" or "x Comments" link from posts on the home page', 'pipdig-textdomain' ),
		'section' => 'pipdig_posts',
	)
);

// Hide tags
$wp_customize->add_setting('hide_post_tags',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('hide_post_tags',
	array(
		'type' => 'checkbox',
		'label' => __( 'Remove tags from posts', 'pipdig-textdomain' ),
		'description' => __( 'Select this option if you would prefer for your tags not to be shown at the bottom of posts', 'pipdig-textdomain' ),
		'section' => 'pipdig_posts',
	)
);

// Hide read more
$wp_customize->add_setting('show_readmore',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('show_readmore',
	array(
		'type' => 'checkbox',
		'label' => 'Show a "View Post" button on the homepage',
		'section' => 'pipdig_posts',
	)
);




// Post carousels section ==========================================================================

// Enable post carousel Footer
$wp_customize->add_setting('posts_carousel_footer',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'posts_carousel_footer',
	array(
		'type' => 'checkbox',
		'label' => __('Enable post carousel in footer', 'pipdig-textdomain'),
		'description' => __('This will display 15 random posts in the footer of your site. Select a date range from below for posts to include.', 'pipdig-textdomain'),
		'section' => 'pipdig_post_carousels',
	)
);

$wp_customize->add_setting('posts_carousel_title',
	array(
		'sanitize_callback' => 'pipdig_sanitize_text_html',
	)
);
$wp_customize->add_control(
	'posts_carousel_title',
	array(
		'type' => 'text',
		'label' => __( 'Title text:', 'pipdig-textdomain' ),
		'section' => 'pipdig_post_carousels',
		'input_attrs' => array(
			'placeholder' => __('Where to next?', 'pipdig-textdomain'),
		),
	)
);

// Date criteria for posts in carousel
$wp_customize->add_setting('posts_carousel_dates',
    array(
        'default' => '1 year ago',
		'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('posts_carousel_dates',
    array(
        'type' => 'select',
        'label' => __('Date range for posts:', 'pipdig-textdomain'),
        'section' => 'pipdig_post_carousels',
        'choices' => array(
            '1 week ago' => __('1 Week', 'pipdig-textdomain'),
			'1 month ago' => __('1 Month', 'pipdig-textdomain'),
			'3 months ago' => __('3 Months', 'pipdig-textdomain'),
			'6 months ago' => __('6 Months', 'pipdig-textdomain'),
			'1 year ago' => __('1 Year', 'pipdig-textdomain'),
			'' => __('All Time', 'pipdig-textdomain'),
        ),
    )
);

// image shape
$wp_customize->add_setting('posts_carousel_shape',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('posts_carousel_shape',
	array(
		'type' => 'select',
		'label' => __('Image shape', 'pipdig-textdomain'),
		'section' => 'pipdig_post_carousels',
		'choices' => array(
			1 => 'Landscape',
			2 => 'Portrait',
			3 => 'Square',
		),
	)
);



// General Options section ==========================================================================

// Add search toggle to navbar (scotch)
$wp_customize->add_setting('site_top_search',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'site_top_search',
	array(
		'type' => 'checkbox',
		'label' => __( 'Search button', 'pipdig-textdomain' ),
		'section' => 'p3_navbar_icons_section',
		'priority' => 2,
	)
);


// Show socialz in footer with counter?
$wp_customize->add_setting('social_count_footer',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'social_count_footer',
	array(
		'type' => 'checkbox',
		'label' => __( 'Display social counter in the Footer', 'pipdig-textdomain' ),
		'description' => __( 'Select this option to show your social media follower counts at the bottom of your website.', 'pipdig-textdomain' ),
		'section' => 'pipdig_general_options',
	)
);

// Left align menu
$wp_customize->add_setting('left_align_menu',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'left_align_menu',
	array(
		'type' => 'checkbox',
		'label' => __( 'Left-align the navbar', 'pipdig-textdomain' ),
		'description' => __( 'Select this option to align the navbar menu items to the left, rather than in the center.', 'pipdig-textdomain' ),
		'section' => 'pipdig_general_options',
	)
);

$wp_customize->add_setting('pipdig_lazy',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'pipdig_lazy',
	array(
		'type' => 'checkbox',
		'label' => '"Lazy Load" images to speed up your homepage.',
		'section' => 'pipdig_general_options',
	)
);

$wp_customize->add_setting('copyright_statement',
	array(
		'sanitize_callback' => 'pipdig_sanitize_text_html',
	)
);
$wp_customize->add_control(
	'copyright_statement',
	array(
		'type' => 'text',
		'label' => __( 'Copyright text in footer:', 'pipdig-textdomain' ),
		'section' => 'pipdig_general_options',
		'input_attrs' => array(
			'placeholder' => '&copy; '.date('Y').' '.get_bloginfo('name'),
		),
	)
);




// Background Image section ===============================================
	
$wp_customize->add_setting('pipdig_background_image',
	array(
		'sanitize_callback' => 'esc_url_raw',
	)
);
$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'upload_background_image',
		array(
			'label'      => __( 'Upload image', 'pipdig-textdomain' ),
			'section'    => 'pipdig_backgrounds',
			'settings'   => 'pipdig_background_image',
		)
	)
);

// Background image repeat or backstretch
$wp_customize->add_setting('pipdig_background_repeats',
    array(
        'default' => 'repeat',
		'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control('pipdig_background_repeats',
    array(
        'type' => 'select',
        'label' => __('Background image layout:', 'pipdig-textdomain'),
        'section' => 'pipdig_backgrounds',
        'choices' => array(
            'repeat' => __('Tile', 'pipdig-textdomain'),
            'repeat-x' => __('Tile Horizontally', 'pipdig-textdomain'),
            'repeat-y' => __('Tile Vertically', 'pipdig-textdomain'),
			'' => __('Stretch Full Screen', 'pipdig-textdomain'),
        ),
    )
);





// Woocommerce section ==========================================================================	
if ( class_exists('Woocommerce') ) { // woocommerce active?

// number of products to display
$wp_customize->add_setting( 'number_of_products_index', array(
	'default' => 20,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control( 'number_of_products_index', array(
    'type' => 'number',
    'section' => 'pipdig_woocommerce',
    'label' => __( 'Number of Products displayed in the shop:', 'pipdig-textdomain' ),
    'input_attrs' => array(
        'min' => 4,
        'max' => 40,
        'step' => 4,
		),
	)
);

// Hide social sharing icons
$wp_customize->add_setting('hide_social_sharing_products',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('hide_social_sharing_products',
	array(
		'type' => 'checkbox',
		'label' => __( 'Remove sharing icons from products', 'pipdig-textdomain' ),
		'section' => 'pipdig_woocommerce',
	)
);

} // end if check woo



	
	// background color
	$wp_customize->add_setting('pipdig_bloglovin_widget_background_color',
		array(
			'default' => '#ffffff',
			//'transport'=>'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pipdig_bloglovin_widget_background_color',
		array(
			'label' => __( 'Background color', 'pipdig-textdomain' ),
			'section' => 'pipdig_bloglovin',
			'settings' => 'pipdig_bloglovin_widget_background_color',
		)
		)
	);

	// border color
	$wp_customize->add_setting('pipdig_bloglovin_widget_border_color',
		array(
			'default' => '#cccccc',
			//'transport'=>'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pipdig_bloglovin_widget_border_color',
		array(
			'label' => __( 'Border color', 'pipdig-textdomain' ),
			'section' => 'pipdig_bloglovin',
			'settings' => 'pipdig_bloglovin_widget_border_color',
		)
		)
	);

	// text color
	$wp_customize->add_setting('pipdig_bloglovin_widget_text_color',
		array(
			'default' => '#000000',
			//'transport'=>'postMessage',
			'sanitize_callback' => 'sanitize_hex_color',
		)
	);
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pipdig_bloglovin_widget_text_color',
		array(
			'label' => __( 'Text color', 'pipdig-textdomain' ),
			'section' => 'pipdig_bloglovin',
			'settings' => 'pipdig_bloglovin_widget_text_color',
		)
		)
	);

	$wp_customize->add_setting('pipdig_bloglovin_widget_icon',
		array(
			'default' => 'heart',
			//'sanitize_callback' => 'bloglovin_widget_sanitize_icon',
		)
	);
	 
	$wp_customize->add_control('pipdig_bloglovin_widget_icon',
		array(
			'type' => 'radio',
			'label' => __( 'Widget Icon', 'pipdig-textdomain' ),
			'section' => 'pipdig_bloglovin',
			'choices' => array(
				'heart' => __( 'Heart', 'pipdig-textdomain' ),
				'plus' => __( 'Plus', 'pipdig-textdomain' ),
				'none' => __( 'None', 'pipdig-textdomain' ),
			),
		)
	);
	


// Use Bloglovin official widget?
$wp_customize->add_setting('pipdig_bloglovin_widget_official',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('pipdig_bloglovin_widget_official',
	array(
		'type' => 'checkbox',
		'label' => __( "Use the official Bloglovin' widget", 'pipdig-textdomain' ),
		'description' => __( "Select this option if you would prefer to use the official Bloglovin' widget.", 'pipdig-textdomain' ),
		'section' => 'pipdig_bloglovin',
	)
);


// Theme colors section ==========================================================================

// Navbar background color
$wp_customize->add_setting('navbar_background_color',
	array(
		'default' => '#eeeeee',
		'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'navbar_background_color',
	array(
		'label' => __( 'Navbar background color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'navbar_background_color',
	)
	)
);

// Navbar text color
$wp_customize->add_setting('navbar_text_color',
	array(
		'default' => '#000000',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'navbar_text_color',
	array(
		'label' => __( 'Navbar text color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'navbar_text_color',
	)
	)
);

// Navbar text hover color
$wp_customize->add_setting('navbar_text_color_hover',
	array(
		'default' => '#d1bc61',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'navbar_text_color_hover',
	array(
		'label' => __( 'Navbar text hover color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'navbar_text_color_hover',
	)
	)
);

// Header text color
$wp_customize->add_setting('header_color',
	array(
		'default' => '#000000',
		'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'header_color',
	array(
		'label' => __( 'Header text color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'header_color',
	)
	)
);

/*
// Outer background color
$wp_customize->add_setting('outer_background_color',
	array(
		'default' => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'outer_background_color',
	array(
		'label' => __( 'Outer background color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'outer_background_color',
	)
	)
);

// Content background color
$wp_customize->add_setting('content_background_color',
	array(
		'default' => '#ffffff',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'content_background_color',
	array(
		'label' => __( 'Content background color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'content_background_color',
	)
	)
);
*/
	  
// Post title color
$wp_customize->add_setting('post_title_color',
	array(
		'default' => '#000000',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'post_title_color',
	array(
		'label' => __( 'Post title color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'post_title_color',
	)
	)
);


// Post title hover color
$wp_customize->add_setting('post_title_hover_color',
	array(
		'default' => '#999999',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'post_title_hover_color',
	array(
		'label' => __( 'Post title hover color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'post_title_hover_color',
	)
	)
);


// Post links color
$wp_customize->add_setting('post_links_color',
	array(
		'default' => '#999999',
		'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'post_links_color',
	array(
		'label' => __( 'Post links color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'post_links_color',
	)
	)
);


// Post links hover color
$wp_customize->add_setting('post_links_hover_color',
	array(
		'default' => '#000000',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'post_links_hover_color',
	array(
		'label' => __( 'Post links hover color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'post_links_hover_color',
	)
	)
);


// Widget title background color
$wp_customize->add_setting('pipdig_widget_title_background_color', // needs a prefix for some reason...
	array(
		'default' => '#eeeeee',
		'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pipdig_widget_title_background_color',
	array(
		'label' => __( 'Widget title background color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'pipdig_widget_title_background_color',
	)
	)
);

// Widget title text color
$wp_customize->add_setting('pipdig_widget_title_text_color',
	array(
		'default' => '#000000',
		'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pipdig_widget_title_text_color',
	array(
		'label' => __( 'Widget title text color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'pipdig_widget_title_text_color',
	)
	)
);


// read more background color
$wp_customize->add_setting('pipdig_readmore_background_color', // needs a prefix for some reason...
	array(
		'default' => '#111111',
		//'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pipdig_readmore_background_color',
	array(
		'label' => __( '"View Post" button background', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'pipdig_readmore_background_color',
	)
	)
);

// read more text color
$wp_customize->add_setting('pipdig_readmore_text_color',
	array(
		'default' => '#ffffff',
		//'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'pipdig_readmore_text_color',
	array(
		'label' => __( '"View Post" button text', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'pipdig_readmore_text_color',
	)
	)
);


// Social Icon color
$wp_customize->add_setting('social_color',
	array(
		'default' => '#111111',
		'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'social_color',
	array(
		'label' => __( 'Social Icon color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'social_color',
	)
	)
);

// Social Icon Hover color
$wp_customize->add_setting('social_hover_color',
	array(
		'default' => '#d1bc61',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'social_hover_color',
	array(
		'label' => __( 'Social Icon Hover color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'social_hover_color',
	)
	)
);

// Footer Widgets background color
$wp_customize->add_setting('footer_widgets_bg_color',
	array(
		'default' => '',
		'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_widgets_bg_color',
	array(
		'label' => __( 'Footer Widgets Background Color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'footer_widgets_bg_color',
	)
	)
);

// Footer bar background color
$wp_customize->add_setting('footer_bar_bg_color',
	array(
		'default' => '#eeeeee',
		'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_bar_bg_color',
	array(
		'label' => __( 'Footer Bar Background Color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'footer_bar_bg_color',
	)
	)
);

// Footer bar background color
$wp_customize->add_setting('footer_bar_text_color',
	array(
		'default' => '#000000',
		'transport'=>'postMessage',
		'sanitize_callback' => 'sanitize_hex_color',
	)
);
$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'footer_bar_text_color',
	array(
		'label' => __( 'Footer Bar Text Color', 'pipdig-textdomain' ),
		'section' => 'pipdig_colors',
		'settings' => 'footer_bar_text_color',
	)
	)
);



// Font sizes =====================================================================
// pipdig_fonts

$fonts_array = pipdig_get_fonts();

if (!function_exists('p3_build_cc')) {
	function p3_build_cc() {
		// de nada
	}
}

// $wp_customize, $fonts_array, $slugs, $title, $font_slug, $size, $uppercase, $italic, $bold, $example

// header
$slugs = array('p_header_font', 'header_font_size', 'p_header_font_transform', 'p_header_font_italic');
p3_build_cc($wp_customize, $fonts_array, $slugs, 'Site header/logo', 'Josefin+Sans', 72, 1, 0, false, 'https://i.imgur.com/xFTbcil.jpg');

// tagline
$slugs = array('p_tagline_font', 'p_tagline_size', 'p_tagline_font_transform', 'p_tagline_font_italic');
p3_build_cc($wp_customize, $fonts_array, $slugs, 'Site tagline', 'EB+Garamond', 15, 0, 0, false, 'https://i.imgur.com/FYMgTVY.png');

// body
$slugs = array('font_body', 'body_font_size');
p3_build_cc($wp_customize, $fonts_array, $slugs, 'Main body', 'EB+Garamond', 16, false, false, false, 'https://i.imgur.com/sK3b60I.png');

// post titles
$slugs = array('p_titles_font', 'post_title_font_size', 'p_titles_font_transform', 'p_titles_font_italic');
p3_build_cc($wp_customize, $fonts_array, $slugs, 'Post titles', 'Josefin+Sans', 30, 1, 0, false, 'https://i.imgur.com/ntE03CT.jpg');

// post meta
$slugs = array('p_meta_font', 'p_meta_font_size', 'p_meta_font_transform', 'p_meta_font_italic');
p3_build_cc($wp_customize, $fonts_array, $slugs, 'Post dates/meta', 'Montserrat', 10, 1, 0, false, 'https://i.imgur.com/zb7PBEb.png');

// navbar
$slugs = array('p_navbar_font', 'p_navbar_font_size', 'p_navbar_font_transform', 'p_navbar_font_italic');
p3_build_cc($wp_customize, $fonts_array, $slugs, 'Main menu/navbar', 'Montserrat', 11, 1, 0, false, 'https://i.imgur.com/2osSVUh.png');

// widget titles
$slugs = array('p_widget_title_font', 'pipdig_widget_title_font_size', 'p_widget_title_font_transform', 'p_widget_title_font_italic');
p3_build_cc($wp_customize, $fonts_array, $slugs, 'Widget titles', 'Montserrat', 11, 1, 0, false, 'https://i.imgur.com/gJahqeJ.png');

// read more buttons
$slugs = array('p_readmore_font', 'p_readmore_font_size', 'p_readmore_font_transform', 'p_readmore_font_italic');
p3_build_cc($wp_customize, $fonts_array, $slugs, '"View Post" buttons', 'Montserrat', 11, 1, 0, false, 'https://i.imgur.com/zGoXlY8.jpg');


// 'You may also enjoy' font
/*
$wp_customize->add_setting('pipdig_you_may_enjoy_font',
	array(
		'default' => 'Josefin+Sans',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control('pipdig_you_may_enjoy_font',
	array(
		'type' => 'select',
		'label' => '"You may also enjoy:" font',
		'section' => 'pipdig_fonts',
		'choices' => $fonts_array,
	)
);
*/
// 'You may also enjoy' font size
$wp_customize->add_setting( 'pipdig_you_may_enjoy_size', array(
	'default' => 19,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control( 'pipdig_you_may_enjoy_size', array(
	'type' => 'number',
	'section' => 'pipdig_fonts',
	'label' => '"You may also enjoy:" size',
	'input_attrs' => array(
		'min' => 4,
		'max' => 40,
		'step' => 1,
		),
	)
);

// 'You may also enjoy' post title font size
$wp_customize->add_setting( 'pipdig_related_post_title_size', array(
	'default' => 18,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control( 'pipdig_related_post_title_size', array(
	'type' => 'number',
	'section' => 'pipdig_fonts',
	'label' => '"You may also enjoy" post titles size',
	'input_attrs' => array(
		'min' => 4,
		'max' => 40,
		'step' => 1,
		),
	)
);

// post content headings font
$wp_customize->add_setting('p_content_heading_font',
	array(
		'default' => 'Josefin+Sans',
		'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control('p_content_heading_font',
	array(
		'type' => 'select',
		'label' => 'Post Content Headings Font',
		'description' => '<a href="https://i.imgur.com/NKT5JmZ.png" target="_blank" rel="noopener">'.__("What's this?", "pipdig-textdomain").'</a>',
		'section' => 'pipdig_fonts',
		'choices' => $fonts_array,
	)
);

// .entry-content h2 size
$wp_customize->add_setting( 'p_content_h2_size', array(
	'default' => 22,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control( 'p_content_h2_size', array(
	'type' => 'number',
	'section' => 'pipdig_fonts',
	'label' => 'Content Heading 2 (H2) Size',
	'input_attrs' => array(
		'min' => 4,
		'max' => 40,
		'step' => 1,
		),
	)
);
// .entry-content h3 size
$wp_customize->add_setting( 'p_content_h3_size', array(
	'default' => 19,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control( 'p_content_h3_size', array(
	'type' => 'number',
	'section' => 'pipdig_fonts',
	'label' => 'Content Heading 3 (H3) Size',
	'input_attrs' => array(
		'min' => 4,
		'max' => 40,
		'step' => 1,
		),
	)
);
// .entry-content h4 size
$wp_customize->add_setting( 'p_content_h4_size', array(
	'default' => 18,
	'capability' => 'edit_theme_options',
	'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control( 'p_content_h4_size', array(
	'type' => 'number',
	'section' => 'pipdig_fonts',
	'label' => 'Content Heading 4 (H4) Size',
	'input_attrs' => array(
		'min' => 4,
		'max' => 40,
		'step' => 1,
		),
	)
);


$wp_customize->add_setting('p_content_h_transform',
	array(
		'default' => 1,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('p_content_h_transform',
	array(
		'type' => 'checkbox',
		'label' => 'Uppercase',
		'section' => 'pipdig_fonts',
	)
);

$wp_customize->add_setting('p_content_h_italic',
	array(
		'default' => 0,
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control('p_content_h_italic',
	array(
		'type' => 'checkbox',
		'label' => 'Italic',
		'section' => 'pipdig_fonts',
	)
);



}




public static function live_preview() {
	wp_enqueue_script( 
		'pipdig-themecustomizer', // Give the script a unique ID
		get_template_directory_uri().'/inc/customizer.js', // Define the path to the JS file
		array(  'jquery', 'customize-preview' ), // Define dependencies
		'', // Define a version (optional) 
		true // Specify whether to put in footer (leave this true)
	);
	}
}

// Setup the Theme Customizer settings and controls...
add_action( 'customize_register' , array( 'pipdig_Customize' , 'register' ) );

// Enqueue live preview javascript in Theme Customizer admin screen
add_action( 'customize_preview_init' , array( 'pipdig_Customize' , 'live_preview' ) );



function pipdig_sanitize_text_html( $input ) {
    return wp_kses_post( force_balance_tags( $input ) );
}



function pipdig_customizer_head_styles() {

$styles_output = '';

	// Outer background color
	$outer_background_color = get_theme_mod( 'outer_background_color', '#ffffff' ); 
	if ($outer_background_color != '#ffffff') :
		$styles_output .= 'body{background:'.$outer_background_color.'}';
	endif;
	
	// Content background color
	$content_background_color = get_theme_mod( 'content_background_color', '#ffffff' ); 
	if ($content_background_color != '#ffffff') :
		$styles_output .= '.container,.widget-title span,.date-bar-white-bg,#trendingz h2 span{background:'.$content_background_color.'}';
	endif;
	
	// Navbar background color
	$navbar_background_color = get_theme_mod( 'navbar_background_color', '#eeeeee' ); 
	if ($navbar_background_color != '#eeeeee') :
		$styles_output .= '.site-top,.menu-bar ul ul,.slicknav_menu {background:'.$navbar_background_color.'}';
	endif;
	
	// Navbar text color
	$navbar_text_color = get_theme_mod( 'navbar_text_color', '#000000' ); 
	if ($navbar_text_color != '#000000') :
		$styles_output .= '.menu-bar ul li a,.slicknav_brand,.slicknav_brand a,.slicknav_nav a,.slicknav_menu .slicknav_menutxt{color:'.$navbar_text_color.'}';
		$styles_output .= '.pipdig_navbar_search input::-webkit-input-placeholder {color:'.$navbar_text_color.'}';
		$styles_output .= '.pipdig_navbar_search input:-moz-placeholder {color:'.$navbar_text_color.'}';
		$styles_output .= '.pipdig_navbar_search input::-moz-placeholder {color:'.$navbar_text_color.'}';
		$styles_output .= '.pipdig_navbar_search input:-ms-input-placeholder {color:'.$navbar_text_color.'}';
	endif;
	
	// Navbar text color hover
	$navbar_text_color_hover = get_theme_mod( 'navbar_text_color_hover', '#d1bc61' ); 
	if ($navbar_text_color_hover != '#d1bc61') :
		$styles_output .= '.menu-bar ul li a:hover,.menu-bar ul ul li > a:hover,.menu-bar ul ul li:hover > a{color:'.$navbar_text_color_hover.'}';
	endif;

	// Post title color
	$post_title_color = get_theme_mod( 'post_title_color', '#000000' ); 
	if ($post_title_color != '#000000') :
		$styles_output .= '.entry-title,.entry-title a,.entry-title a:active,.entry-title a:visited{color:'.$post_title_color.'}';
	endif;

	// Post title hover color
	$post_title_hover_color = get_theme_mod( 'post_title_hover_color', '#999999' ); 
	if ($post_title_hover_color != '#999999') :
		$styles_output .= '.entry-title a:hover{color:'.$post_title_hover_color.'}';
	endif;

	// Post links color
	$post_links_color = get_theme_mod( 'post_links_color', '#999999' ); 
	if ($post_links_color != '#999999') :
		$styles_output .= '.entry-content a:not(.more-link){color:'.$post_links_color.'}';
	endif;

	// Post links hover color
	$post_links_hover_color = get_theme_mod( 'post_links_hover_color', '#000000' ); 
	if ($post_links_hover_color != '#000000') :
		$styles_output .= '.entry-content a:hover{color:'.$post_links_hover_color.'}';
	endif;

	// Widget title background color
	$pipdig_widget_title_background_color = get_theme_mod( 'pipdig_widget_title_background_color', '#eeeeee' ); 
	if ($pipdig_widget_title_background_color != '#eeeeee') :
		$styles_output .= '.widget-title{background:'.$pipdig_widget_title_background_color.'}.widget-title{margin-bottom:15px;}';
	endif;
	
	// Widget title text color
	$pipdig_widget_title_text_color = get_theme_mod( 'pipdig_widget_title_text_color', '#000000' ); 
	if ($pipdig_widget_title_text_color != '#000000') :
		$styles_output .= '.widget-title{color:'.$pipdig_widget_title_text_color.'}';
	endif;

	// Header text color
	$header_color = get_theme_mod( 'header_color', '#000000' );
	if ($header_color != '#000000') :
		$styles_output .= '.site-title a{color:'.$header_color.'}';
	endif;

	// Social Icon color
	$social_color = get_theme_mod( 'social_color', '#111111' );
	if ($social_color != '#111111') :
		$styles_output .= '.socialz a{color:'.$social_color.'}';
	endif;

	// Social Icon Hover color
	$social_hover_color = get_theme_mod( 'social_hover_color', '#d1bc61' );
	if ($social_hover_color != '#d1bc61') :
		$styles_output .= '.socialz a:hover, #p3_social_sidebar a:hover{color:'.$social_hover_color.'}';
	endif;
	
	// read more background color
	$pipdig_readmore_background_color = get_theme_mod( 'pipdig_readmore_background_color', '#111111' ); 
	if ($pipdig_readmore_background_color != '#111111') :
		$styles_output .= '.more-link, .read-more, .lem_listing_content .read-more:hover {background:'.$pipdig_readmore_background_color.';border:0}';
	endif;
	
	// read more text color
	$pipdig_readmore_text_color = get_theme_mod( 'pipdig_readmore_text_color', '#ffffff' ); 
	if ($pipdig_readmore_text_color != '#ffffff') :
		$styles_output .= '.more-link, .more-link:hover, .read-more, .lem_listing_content .read-more:hover {color:'.$pipdig_readmore_text_color.'}';
	endif;
	
	$footer_widgets_bg_color = get_theme_mod( 'footer_widgets_bg_color' ); 
	if ($footer_widgets_bg_color) {
		$styles_output .= '.site-extra, .site-extra .container{background:'.$footer_widgets_bg_color.'}';
	}
	
	// Footer bar background color
	$footer_bar_bg_color = get_theme_mod( 'footer_bar_bg_color', '#eeeeee' ); 
	$footer_bar_text_color = get_theme_mod( 'footer_bar_text_color', '#000000' ); 
	if ($footer_bar_bg_color != '#eeeeee') {
		if ($footer_bar_bg_color != $footer_bar_text_color) {
			$styles_output .= '.site-footer,.social-footer-outer,.p3_instagram_footer_title_bar{background:'.$footer_bar_bg_color.'}';
		}
	}
	// Footer bar text color
	if ($footer_bar_text_color != '#000000') {
		if ($footer_bar_bg_color != $footer_bar_text_color) {
			$styles_output .= '.site-footer,.site-footer a,.site-footer a:hover,.social-footer,.social-footer a,.p3_instagram_footer_title_bar a, .p3_instagram_footer_title_bar a:hover, .p3_instagram_footer_title_bar a:focus, .p3_instagram_footer_title_bar a:visited{color:'.$footer_bar_text_color.'}';
		}
	}

	
	// FONTS ============
	
	// Body font size
	$body_font_size = get_theme_mod( 'body_font_size', 16 );
	if ($body_font_size != 16) {
		$styles_output .= 'body {font-size:'.$body_font_size.'px}';
	}
		
	// Header font size
	$header_font_size = get_theme_mod( 'header_font_size', 72 );
	if ($header_font_size != 72) {
		$styles_output .= '.site-title{font-size:'.$header_font_size.'px}@media only screen and (max-width:769px){.site-title {font-size:40px;font-size:9vw}}';
	}
		
	// Post title font size
	$post_title_font_size = get_theme_mod( 'post_title_font_size', 30 );
	if ($post_title_font_size != 30) {
		$styles_output .= '.entry-title {font-size:'.$post_title_font_size.'px} .grid-title{height:'.$post_title_font_size.'px;line-height:'.$post_title_font_size.'px}@media only screen and (max-width:719px){.grid-title{height:auto}}';
	}

	// Widget title font size
	$pipdig_widget_title_font_size = get_theme_mod( 'pipdig_widget_title_font_size', 11 );
	if ($pipdig_widget_title_font_size != 11) {
		$styles_output .= '.widget-title {font-size:'.$pipdig_widget_title_font_size.'px}';
	}
	
	if (get_theme_mod('p_widget_title_font_transform', 1) == false) {
		$styles_output .= '.widget-title {text-transform: none}';
	}
	if (get_theme_mod('p_widget_title_font_italic')) {
		$styles_output .= '.widget-title {font-style: italic}';
	}

	
	// menu font size
	$p_navbar_font_size = get_theme_mod( 'p_navbar_font_size', 11 );
	if ($p_navbar_font_size != 11) {
		$styles_output .= '.menu-bar ul li a, .slicknav_menu {font-size:'.$p_navbar_font_size.'px}';
	}
	
	// meta font
	$p_meta_font = get_theme_mod( 'p_meta_font', 'Montserrat' );
	if ($p_meta_font != 'Montserrat') {
		$p_meta_font = str_replace('+', ' ', $p_meta_font);
		$styles_output .= '.pipdig_meta, .pipdig_cat, .btn, button, input[type="button"], input[type="reset"], input[type="submit"], .entry-meta, .site-main .paging-navigation a, .site-main .post-navigation a, .site-main .post-navigation a, .site-main .post-navigation .meta-nav, .comment-meta, .comment-date, .pipdig-cats, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .pipdig-slider-cats, .commentz, .p3_share_title {font-family: "'.$p_meta_font.'"}';
	}
	
	// pipdig_meta font size
	$p_meta_font_size = get_theme_mod( 'p_meta_font_size', 10 );
	if ($p_meta_font_size != 10) {
		$styles_output .= '.pipdig_meta, .pipdig_cat, .btn, button, input[type="button"], input[type="reset"], input[type="submit"], .entry-meta, .site-main .paging-navigation a, .site-main .post-navigation a, .site-main .post-navigation a, .site-main .post-navigation .meta-nav, .comment-meta, .comment-date, .pipdig-cats, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .pipdig-slider-cats, .commentz, .p3_share_title {font-size:'.$p_meta_font_size.'px}';
	}
	
	if (get_theme_mod('p_meta_font_transform', 1) == false) {
		$styles_output .= '.blossom_meta, .listing-comments a, .pipdig_geo_tag, .pipdig_geo_tag a, .pipdig_meta, .pipdig_cat, .btn, button, input[type="button"], input[type="reset"], input[type="submit"], .entry-meta, .site-main .paging-navigation a, .site-main .post-navigation a, .site-main .post-navigation a, .site-main .post-navigation .meta-nav, .comment-meta, .comment-date, .pipdig-cats, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .pipdig-slider-cats, .commentz, .p3_share_title {text-transform: none}';
	}
	if (get_theme_mod('p_meta_font_italic')) {
		$styles_output .= '.blossom_meta, .listing-comments a, .pipdig_geo_tag, .pipdig_geo_tag a, .pipdig_meta, .pipdig_cat, .btn, button, input[type="button"], input[type="reset"], input[type="submit"], .entry-meta, .site-main .paging-navigation a, .site-main .post-navigation a, .site-main .post-navigation a, .site-main .post-navigation .meta-nav, .comment-meta, .comment-date, .pipdig-cats, .woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .pipdig-slider-cats, .commentz, .p3_share_title {font-style: italic}';
	}
	
	// read more font
	$p_readmore_font = get_theme_mod( 'p_readmore_font', 'Montserrat' );
	if ($p_readmore_font != 'Montserrat') {
		$p_readmore_font = str_replace('+', ' ', $p_readmore_font);
		$styles_output .= '.read-more, .more-link {letter-spacing: 0; font-family: "'.$p_readmore_font.'"}';
	}
	
	// read more font size
	$p_readmore_font_size = get_theme_mod( 'p_readmore_font_size', 11 );
	if ($p_readmore_font_size != 11) {
		$styles_output .= '.read-more, .more-link {font-size:'.$p_readmore_font_size.'px !important}';
	}
	
	if (get_theme_mod('p_readmore_font_transform', 1) == false) {
		$styles_output .= '.read-more, .more-link {text-transform: none}';
	}
	if (get_theme_mod('p_readmore_font_italic')) {
		$styles_output .= '.read-more, .more-link {font-style: italic}';
	}
	
	// "you may enjoy" title font size
	$pipdig_you_may_enjoy_size = get_theme_mod( 'pipdig_you_may_enjoy_size', 19 );
	if ($pipdig_you_may_enjoy_size != 19) {
		$styles_output .= '.entry-content .pipdig_p3_related_posts h3, .pipdig_p3_related_posts h3{font-size:'.$pipdig_you_may_enjoy_size.'px}';
	}
	
	// "you may enjoy" post title font size
	$pipdig_related_post_title_size = get_theme_mod( 'pipdig_related_post_title_size', 18 );
	if ($pipdig_related_post_title_size != 18) {
		$styles_output .= '.pipdig_p3_related_title a{font-size:'.$pipdig_related_post_title_size.'px}';
	}
	
	// header font
	$p_header_font = get_theme_mod( 'p_header_font', 'Josefin+Sans' );
	if ($p_header_font != 'Josefin+Sans') {
		$p_header_font = str_replace('+', ' ', $p_header_font);
		$styles_output .= '.site-title {letter-spacing: 0; font-family: "'.$p_header_font.'"}';
	}
	
	if (get_theme_mod('p_header_font_transform', 1) == false) {
		$styles_output .= '.site-title {text-transform: none}';
	}
	if (get_theme_mod('p_header_font_italic')) {
		$styles_output .= '.site-title {font-style: italic}';
	}
	
	//Tagline font
	$p_tagline_font = get_theme_mod( 'p_tagline_font', 'EB+Garamond' );
	if ($p_tagline_font != 'EB+Garamond') {
		$p_tagline_font = str_replace('+', ' ', $p_tagline_font);
		$styles_output .= '.site-description {letter-spacing: 0; font-family: "'.$p_tagline_font.'"}';
	}
	
	// Tagline font size
	$p_tagline_size = get_theme_mod( 'p_tagline_size', 15 );
	if ($p_tagline_size != 15) :
		$styles_output .= '.site-description {font-size:'.$p_tagline_size.'px}';
	endif;
	
	if (get_theme_mod('p_tagline_font_transform')) {
		$styles_output .= '.site-description {text-transform: uppercase}';
	}
	if (get_theme_mod('p_tagline_font_italic')) {
		$styles_output .= '.site-description {font-style: italic}';
	}
	
	// Main body font
	$font_body = get_theme_mod( 'font_body', 'EB+Garamond' );
	if ($font_body != 'EB+Garamond') {
		$font_body = str_replace('+', ' ', $font_body);
		$styles_output .= 'body {font-family: "'.$font_body.'"}';
	}
	
	// widget titles font
	$p_widget_title_font = get_theme_mod( 'p_widget_title_font', 'Montserrat' );
	if ($p_widget_title_font != 'Montserrat') {
		$p_widget_title_font = str_replace('+', ' ', $p_widget_title_font);
		$styles_output .= '.widget-title {letter-spacing: 0; font-family: "'.$p_widget_title_font.'"}';
	}
	
	// post title font
	$p_titles_font = get_theme_mod( 'p_titles_font', 'Josefin+Sans' );
	if ($p_titles_font != 'Josefin+Sans') {
		$p_titles_font = str_replace('+', ' ', $p_titles_font);
		$styles_output .= 'h1, h2, h3, h4, h5, h6, .p_post_titles_font, .entry-title, .page-title, .pipdig_p3_related_title a, .entry-content .pipdig_p3_related_posts h3, .pipdig_p3_related_posts h3, .p3_popular_posts_widget h4, .p3_popular_posts_widget h4, .slide-h2, .p_post_titles_font {letter-spacing: 0; font-family: "'.$p_titles_font.'"}';
	}
	
	if (get_theme_mod('p_titles_font_transform', 1) == false) {
		$styles_output .= 'h1, h2, h3, h4, h5, h6, .entry-title,.page-title,.pipdig_p3_related_title a, .entry-content .pipdig_p3_related_posts h3, .pipdig_p3_related_posts h3, .p3_popular_posts_widget h4, .comment-reply-title, #scotch-panel-blossom h5, #scotch-panel-blossom h5, .slide-h2, .p_post_titles_font {text-transform: none}';
	}
	if (get_theme_mod('p_titles_font_italic')) {
		$styles_output .= 'h1, h2, h3, h4, h5, h6, .entry-title,.page-title,.pipdig_p3_related_title a, .entry-content .pipdig_p3_related_posts h3, .pipdig_p3_related_posts h3, .p3_popular_posts_widget h4, .comment-reply-title, #scotch-panel-blossom h5, #scotch-panel-blossom h5, .slide-h2, .p_post_titles_font {font-style:italic}';
	}
	
	// Menu font
	$p_navbar_font = get_theme_mod( 'p_navbar_font', 'Montserrat' );
	if ($p_navbar_font != 'Montserrat') {
		$p_navbar_font = str_replace('+', ' ', $p_navbar_font);
		$styles_output .= '.menu-bar ul li a, .slicknav_menu{letter-spacing: 0; font-family: "'.$p_navbar_font.'"}';
	}
	
	if (get_theme_mod('p_navbar_font_transform', 1) == false) {
		$styles_output .= '.menu-bar ul li a, .slicknav_menu {text-transform: none}';
	}
	if (get_theme_mod('p_navbar_font_italic')) {
		$styles_output .= '.menu-bar ul li a, .slicknav_menu {font-style: italic}';
	}
	
	// "You may enjoy" font
	/*
	$pipdig_you_may_enjoy_font = get_theme_mod( 'pipdig_you_may_enjoy_font', 'Josefin+Sans' );
	$pipdig_you_may_enjoy_font = str_replace('+', ' ', $pipdig_you_may_enjoy_font);
	if ($pipdig_you_may_enjoy_font != 'Josefin+Sans') {
		$styles_output .= '.entry-content .pipdig_p3_related_posts h3, .pipdig_p3_related_posts h3{font-family: "'.$pipdig_you_may_enjoy_font.'"}';
	}
	*/
	
	// post content headings font
	$p_content_heading_font = get_theme_mod( 'p_content_heading_font', 'Josefin+Sans' );
	if ($p_content_heading_font != 'Josefin+Sans') {
		$p_content_heading_font = str_replace('+', ' ', $p_content_heading_font);
		$styles_output .= '.entry-content h1, .entry-content h2, .entry-content h3, .entry-content h4, .entry-content h5, .entry-content h6 {letter-spacing: 0; font-family: "'.$p_content_heading_font.'"}';
	}
	
	// H2 font size
	$p_content_h2_size = get_theme_mod( 'p_content_h2_size', 22 );
		if ($p_content_h2_size != 22) {
		$styles_output .= '.entry-content h2 {font-size:'.$p_content_h2_size.'px}';
	}
	// H3 font size
	$p_content_h3_size = get_theme_mod( 'p_content_h3_size', 19 );
	if ($p_content_h3_size != 19) {
		$styles_output .= '.entry-content h3 {font-size:'.$p_content_h3_size.'px}';
	}
	// H4 font size
	$p_content_h4_size = get_theme_mod( 'p_content_h4_size', 18 );
	if ($p_content_h4_size != 18) {
		$styles_output .= '.entry-content h4 {font-size:'.$p_content_h4_size.'px}';
	}
	
	if (get_theme_mod('p_content_h_transform', 1) == false) {
		$styles_output .= '.entry-content h1, .entry-content h2, .entry-content h3, .entry-content h4, .entry-content h5, .entry-content h6 {text-transform: none}';
	}
	if (get_theme_mod('p_content_h_italic')) {
		$styles_output .= '.entry-content h1, .entry-content h2, .entry-content h3, .entry-content h4, .entry-content h5, .entry-content h6 {font-style:italic}';
	}
	

	// Show author
	$show_author = get_theme_mod( 'show_author' );
	if ($show_author != 0) :
		$styles_output .= '.show-author{display:inline}';
	endif;
	
	// Left sidebar
	$sidebar_position = get_theme_mod( 'sidebar_position' );
	if ($sidebar_position == 'left') :
		$styles_output .= '@media only screen and (min-width: 990px){.site-sidebar{padding:0 30px 0 0;}}';
	endif;
	
	// Left align menu
	$left_align_menu = get_theme_mod( 'left_align_menu' );
	if ($left_align_menu != 0) :
		$styles_output .= '.site-top .menu-bar{text-align:left}.site-top .menu-bar ul li a{padding:0 15px}.site-top .menu-bar ul li ul a{padding:5px 15px;}';
	endif;
	
	// Bloglovin widget==========================

	// background color
	$pipdig_bloglovin_widget_background_color = get_theme_mod( 'pipdig_bloglovin_widget_background_color', '#ffffff' ); 
	if ($pipdig_bloglovin_widget_background_color != '#ffffff' ) :
		$styles_output .= '.pipdig-bloglovin-widget{background:'.$pipdig_bloglovin_widget_background_color.'}';
	endif;
	
	// border color
	$pipdig_bloglovin_widget_border_color = get_theme_mod( 'pipdig_bloglovin_widget_border_color', '#cccccc' ); 
	if ($pipdig_bloglovin_widget_border_color != '#cccccc' ) :
		$styles_output .= '.pipdig-bloglovin-widget{border:1px solid '.$pipdig_bloglovin_widget_border_color.'}';
	endif;
		
	// text color
	$pipdig_bloglovin_widget_text_color = get_theme_mod( 'pipdig_bloglovin_widget_text_color', '#000000' ); 
	if ($pipdig_bloglovin_widget_text_color != '#000000') :
		$styles_output .= '.pipdig-bloglovin-widget,.wp-bloglovin-widget .fa{color:'.$pipdig_bloglovin_widget_text_color.'!important}';
	endif;	

	//===========================================
	
	
	// background image and repeat setting (or backstretch)
	$repeat = get_theme_mod('pipdig_background_repeats', 'repeat');
	$bg_image = get_theme_mod('pipdig_background_image');
	if($bg_image) {
		if($repeat != '') { // if not set to backstretch:
			$styles_output .= 'body{background:url('.esc_url($bg_image).') '.$repeat.';}';
		}
	}
	
	// .container max-width and responsive
	$container_width = absint(get_theme_mod( 'container_width', 1080 )); 
	$container_width_single = absint(get_theme_mod( 'container_width_single', $container_width ));
	$disable_responsive = get_theme_mod( 'disable_responsive' ); 
	
	if (!$disable_responsive) {
		if ($container_width != 1080) {
			$styles_output .= '.container{max-width:'.$container_width.'px}';
		}
		if (is_singular() && ($container_width_single != $container_width)) {
			$styles_output .= '.site-main .container{max-width:'.$container_width_single.'px}';
		}
	} else {
		if ($container_width != 1080) {
			$styles_output .= '.container{width:'.$container_width.'px}';
		}
		if (is_singular() && ($container_width_single != $container_width)) {
			$styles_output .= '.site-main .container{width:'.$container_width_single.'px}';
		}
	}
	
	// remove padding if using header image
	$logo_image_pad = get_theme_mod( 'logo_image' ); 
	if ($logo_image_pad) :
		$styles_output .= '.site-header .container{padding-top:0;padding-bottom:0;}.site-description{margin-bottom:20px}';
	endif;

	// Header image top padding
	$header_image_top_padding = get_theme_mod( 'header_image_top_padding', 0 ); 
	if ($header_image_top_padding != 0) :
		$styles_output .= '@media screen and (min-width: 770px) { .site-title img{padding-top:'.$header_image_top_padding.'px} }';
	endif;
	
	// Header image top padding
	$header_image_bottom_padding = get_theme_mod( 'header_image_bottom_padding', 0 ); 
	if ($header_image_bottom_padding != 0) :
		$styles_output .= '.site-title img{padding-bottom:'.$header_image_bottom_padding.'px}';
	endif;
	
	// Header image retina
	$header_image_retina_width = get_theme_mod( 'header_image_retina_width', 0 ); 
	if ($header_image_retina_width != 0) {
		$styles_output .= '.site-title img{width:'.$header_image_retina_width.'px}';
	}
	
	// Full width slider height
	$header_full_width_slider_height = get_theme_mod( 'header_full_width_slider_height', 420 ); 
	if ($header_full_width_slider_height && $header_full_width_slider_height != 420) :
		$styles_output .= '@media only screen and (min-width: 720px) {#pipdig_full_width_slider{height:'.$header_full_width_slider_height.'px}}';
	endif;
	
	if ($styles_output) {
		echo '<!-- Cust --><style>'.strip_tags($styles_output).'</style><!-- /Cust -->';
	}
	
}
add_action( 'wp_head', 'pipdig_customizer_head_styles' );
