<?php
$sm = 'sm';
if (get_theme_mod('disable_responsive')) {
	$sm = 'xs';
}

$this_post = $wp_query->current_post;
if ($this_post % 2 == 0) {
	$col_1 = 'col-'.$sm.'-6';
	$col_2 = 'col-'.$sm.'-6';
	$left_right = 'right-date';
} else {
	$col_1 = 'col-'.$sm.'-6 col-'.$sm.'-push-6';
	$col_2 = 'col-'.$sm.'-6 col-'.$sm.'-pull-6';
	$left_right = 'left-date';
}

$the_shape = absint(get_theme_mod('equinox_image_shape'));

$shape = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAfQAAAH0AQMAAADxGE3JAAAAA1BMVEUAAACnej3aAAAAAXRSTlMAQObYZgAAADVJREFUeNrtwTEBAAAAwiD7p/ZZDGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOX0AAAEidG8rAAAAAElFTkSuQmCC'; // square

if ($the_shape == 2) {
	$shape = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAWgAAAHgAQMAAACyyGUjAAAAA1BMVEUAAACnej3aAAAAAXRSTlMAQObYZgAAACxJREFUeNrtwTEBAAAAwiD7p7bGDmAAAAAAAAAAAAAAAAAAAAAAAAAAAAAkHVZAAAFam5MDAAAAAElFTkSuQmCC'; // portrait
} elseif ($the_shape == 3) { // not actually available in customizer yet
	$shape = 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAoAAAAFoAQMAAAD9/NgSAAAAA1BMVEUAAACnej3aAAAAAXRSTlMAQObYZgAAADJJREFUeNrtwQENAAAAwiD7p3Z7DmAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA5HHoAAHnxtRqAAAAAElFTkSuQmCC'; // landscape
}

$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large' );
if ($thumb) {
	$bg = esc_url($thumb['0']);
} else {
	$bg = pipdig_catch_that_image();
}

$tugger = $geo_tag = $category = $shopr_collection = $shopr_collection_slug = $shopr_title = '';

if (get_theme_mod('show_main_cat', 1)) {
	$category = pipdig_main_cat(false);
}

if (function_exists('rwmb_meta')) {
	
	$extra_excerpt = rwmb_meta( 'pipdig_meta_extra_excerpt' );
	
	$shopr_title = esc_attr(rwmb_meta('pipdig_meta_shopr_title'));
	$shopr_collection = rwmb_meta('pipdig_meta_shopr_collection');
	if (function_exists('is_shopr_active') && !empty($shopr_collection) && !is_wp_error($shopr_collection) && !empty($shopr_collection->slug)) {
		$shopr_collection_slug = $shopr_collection->slug;
	}
	
	$geo_tag = esc_html(rwmb_meta('pipdig_meta_geographic_location'));
	if (!empty($geo_tag)) {
		$tugger = $geo_tag;
	} elseif ($category) {
		$tugger = $category;
	} else {
		$tugger = '';
	}
} elseif ($category) {
	$tugger = $category;
} else {
	$tugger = '';
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('clearfix'); ?>  itemprop="blogPost" itemscope="itemscope" itemtype="https://schema.org/BlogPosting">

	<div class="<?php echo $col_1; ?> post-listing">
		<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" >
			<?php if ($this_post != 0 && get_theme_mod('pipdig_lazy')) { ?>
				<div class="post-listing-img nopin pipdig_lazy" data-src="<?php echo $bg; ?>">
			<?php } else { ?>
				<div class="post-listing-img nopin" style="background-image:url(<?php echo $bg; ?>);">
			<?php } ?>
				<?php if (!get_theme_mod('hide_dates')) { ?>
					<div class="left-right-date <?php echo $left_right; ?> pipdig_meta"><time datetime="<?php echo get_the_date('Y-m'); ?>" itemprop="datePublished"><?php echo get_the_date(); ?></time></div>
				<?php } ?>
				<img src="<?php echo $shape; ?>" alt="<?php the_title_attribute(); ?>" class="p3_invisible" data-pin-nopin="true" data-p3-pin-img-src="<?php echo $bg; ?>" data-p3-pin-title="<?php the_title_attribute(); ?>" data-p3-pin-link="<?php the_permalink(); ?>" />
			</div>
		</a>
	</div>
		
	<div class="<?php echo $col_2; ?> post-listing lem_listing_content">
		
		<div class="entry-meta entry-line" style="display:none">
			<span class="date-bar-white-bg"><span class="vcard author show-author"><span class="fn" itemprop="name"><?php the_author_posts_link(); ?></span><span class="show-author"> / </span></span><span class="entry-date updated"><time datetime="<?php echo get_the_date('Y-m'); ?>" itemprop="datePublished"><?php echo get_the_date(); ?></time></span></span>
		</div>

		<div class="pipdig_geo_tag pipdig_meta">
			<?php if($geo_tag) { ?>
				<i class="fa fa-map-marker"></i>
			<?php } ?>
			<span <?php if ($geo_tag) echo 'style="top:-20px"'; ?>>
			<?php echo $tugger; ?>
			</span>
		</div>
		
		<h2 class="entry-title p_post_titles_font" itemprop="headline"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php echo pipdig_truncate(get_the_title(), get_theme_mod('post_title_length_limit', 7)) ?></a></h2>
		
		<?php
		if ((get_theme_mod('grid_excerpts', 1)) && (get_theme_mod('excerpt_length_num', 40) !== 0)) {
			the_excerpt();
		}
		?>
		
		<?php if (get_theme_mod('show_readmore', 1)){ ?>
			<a class="read-more" href="<?php the_permalink(); ?>" style="margin-bottom:12px;"><?php _e('View Post', 'pipdig-textdomain'); ?></a>
		<?php } ?>
		
		<?php if (!get_theme_mod('hide_comments_link')){ ?>
			<div class="listing-comments pipdig_meta"><a href="<?php the_permalink(); ?>" data-disqus-url="<?php the_permalink(); ?>"><i class="fa fa-comments"></i> <?php echo get_comments_number(); ?> <?php _e('Comments', 'pipdig-textdomain'); ?></a></div>
		<?php } ?>
		
		<?php
		if ($shopr_collection_slug) {
			echo do_shortcode('[shopr_shopthepost title="'.$shopr_title.'" collection="'.$shopr_collection_slug.'" force_carousel="true"]');
		} elseif ($extra_excerpt) {
			echo '<p>';
			echo do_shortcode($extra_excerpt);
			echo '</p>';
		} elseif(function_exists('pipdig_p3_social_shares')) { // only display social shares if no extra excerpt
			pipdig_p3_social_shares();
		}
		?>
	</div>
	
	<?php if (function_exists('p3_schema_publisher')) p3_schema_publisher(); ?>
	
</article><!-- #post-<?php the_ID(); ?> -->

<?php
if ($this_post == 0) {
	do_action( 'after_first_post' );
	if ( is_active_sidebar('after-first-post') && is_home() && !is_paged() ) { ?>
		<div id="widget_area_after_first" class="col-xs-12 textalign-center clearfix">
			<?php dynamic_sidebar( 'after-first-post' ); ?>
		</div> <?php
	}
} elseif ($this_post == 1) {
	do_action( 'after_second_post' );
	if ( is_active_sidebar('after-second-post') && is_home() && !is_paged() ) { ?>
		<div id="widget_area_after_second" class="col-xs-12 textalign-center clearfix">
			<?php dynamic_sidebar( 'after-second-post' ); ?>
		</div> <?php
	}
} elseif ($this_post == 2) {
	do_action( 'after_third_post' );
	if ( is_active_sidebar('after-third-post') && is_home() && !is_paged() ) { ?>
		<div id="widget_area_after_third" class="col-xs-12 textalign-center clearfix">
			<?php dynamic_sidebar( 'after-third-post' ); ?>
		</div> <?php
	}
} elseif ($this_post == 3) {
	if ( is_active_sidebar('after-fourth-post') && is_home() && !is_paged() ) { ?>
		<div id="widget_area_after_fourth" class="col-xs-12 textalign-center clearfix">
			<?php dynamic_sidebar( 'after-fourth-post' ); ?>
		</div> <?php
	}
} elseif ($this_post == 4) {
	if ( is_active_sidebar('after-fifth-post') && is_home() && !is_paged() ) { ?>
		<div id="widget_area_after_fifth" class="col-xs-12 textalign-center clearfix">
			<?php dynamic_sidebar( 'after-fifth-post' ); ?>
		</div> <?php
	}
} elseif ($this_post == 5) {
	if ( is_active_sidebar('after-sixth-post') && is_home() && !is_paged() ) { ?>
		<div id="widget_area_after_sixth" class="col-xs-12 textalign-center clearfix">
			<?php dynamic_sidebar( 'after-sixth-post' ); ?>
		</div> <?php
	}
}
?>