<?php
/*
Plugin Name: Shopr
Plugin URI: https://support.pipdig.co/article-topics/shopr/
Description: Link to products from your favorite websites. Also compatible with affiliate links.
Author: pipdig
Author URI: https://www.pipdig.co/
Version: 2.2.1
Text Domain: shopr
License: Copyright 2018 pipdig Ltd. All rights reserved.
*/

if (!defined('ABSPATH')) die;

define( 'SHOPR_VERSION', '2.2.1' );
define( 'SHOPR_DIR', plugin_dir_path(__FILE__) );

function shopr_php_version_notice() {
	if (strnatcmp(phpversion(),'5.3.10') >= 0) {
		return;
	}
	?>
	<div class="notice notice-error is-dismissible">
		<h2>Shopr Plugin NOT active</h2>
		<p>Hey, we've noticed that you're running an outdated version of PHP. PHP is the programming language that WordPress is built on. The version that is currently used for your site is no longer supported. Newer versions of PHP are both faster and more secure.</p>
		<p>You should update your PHP version to either 5.6 or 7.0. On a normal WordPress site, switching to PHP 5.6 should never cause issues. Please <strong>contact your web host</strong> and they will be able to update this for you.</p>
		<p>As soon as the PHP version has been updated, the Shopr plugin will start to work.</p>
	</div>
	<?php
}
add_action( 'admin_notices', 'shopr_php_version_notice' );

if (strnatcmp(phpversion(),'5.3.10') <= 0) {
	return;
}


// enqueue scripts and styles
function shopr_scripts_styles() {

	wp_register_style('shopr', plugins_url( '/public/assets/style.css',__FILE__), array(), SHOPR_VERSION);
	wp_register_script('pipdig-flickity', 'https://cdnjs.cloudflare.com/ajax/libs/flickity/2.0.10/flickity.pkgd.min.js', array('jquery'), null, false);
	wp_register_script('pipdig-imagesloaded', 'https://cdnjs.cloudflare.com/ajax/libs/jquery.imagesloaded/4.1.4/imagesloaded.pkgd.min.js', array('jquery'), null, false);
	wp_register_script('pipdig-isotope', 'https://cdnjs.cloudflare.com/ajax/libs/jquery.isotope/3.0.5/isotope.pkgd.min.js', array('jquery'), null, false);

	$enqueue_them = false;

	// Only enqueue scripts when needed
	global $post;
	if ( is_a($post, 'WP_Post') && has_shortcode($post->post_content, 'shopr') ) {
		// when the "shopr" shortcode is found in the content
		$enqueue_them = true;
	} elseif (defined('SITEORIGIN_PANELS_VERSION') && is_singular()) {
		// siteorigin panels doesn't allow the shopr shortcode to be found in the content
		$enqueue_them = true;
	} elseif (is_page()) {
		$enqueue_them = true;
	}

	if ($enqueue_them) {
		wp_enqueue_script('pipdig-imagesloaded');
		wp_enqueue_script('pipdig-isotope');
	}

}
add_action( 'wp_enqueue_scripts', 'shopr_scripts_styles');


function shopr_image_sizes() {
	add_image_size('shopr-product', 300, 9999);
}
add_action( 'init', 'shopr_image_sizes' );


include(SHOPR_DIR.'admin/cpt.php');
include(SHOPR_DIR.'admin/admin-pages.php');
include(SHOPR_DIR.'admin/customizer.php');
include(SHOPR_DIR.'public/shortcodes/grid.php');
include(SHOPR_DIR.'public/shortcodes/shopthepost.php');
include(SHOPR_DIR.'admin/blocks.php');
include(SHOPR_DIR.'admin/widget_shopthepost.php');
include(SHOPR_DIR.'admin/wpbakery.php');
include(SHOPR_DIR.'admin/editor.php');
include(SHOPR_DIR.'admin/apis.php');
include(SHOPR_DIR.'admin/dash-widget.php');

function shopr_intro_notice() {
	global $pagenow;
	if ( ($pagenow != 'index.php') && ($pagenow != 'plugins.php') ) {
		return;
	}
	if (!current_user_can('edit_theme_options')) {
		return;
	}
	if (isset($_POST['shopr_new_install_notice_dismissed'])) {
		update_option('shopr_new_install_notice', 1);
		return;
	}
	if (get_option('shopr_new_install_notice')) {
		return;
	}
	?>
	<div class="notice notice-success is-dismissible">
		<h2><span class="dashicons dashicons-cart"></span> Welcome to Shopr</h2>
		<p>Thanks for installing the Shopr plugin! Let's get you up and running:</p>
		<p>1. <a href="https://support.pipdig.co/articles/shopr-import-demo-products/" target="_blank" rel="noopener">Import some demo products</a></p>
		<p>2. <a href="<?php echo admin_url('post-new.php?post_type=shopr_product&shopr_intro'); ?>">Add a new product</a></p>
		<p>3. <a href="https://support.pipdig.co/articles/shopr-create-a-shop-page/" target="_blank" rel="noopener">Create a shop page</a></p>
		<form action="<?php echo admin_url(); ?>" method="post">
			<?php wp_nonce_field('shopr_new_install_notice_nonce'); ?>
			<input type="hidden" value="true" name="shopr_new_install_notice_dismissed" />
			<p class="submit" style="margin-top: 5px; padding-top: 5px;">
				<input name="submit" class="button" value="Hide this notice" type="submit" />
			</p>
		</form>
	</div>
	<?php
}
add_action( 'admin_notices', 'shopr_intro_notice', 2 );

function shopr_nag_notice() {
	global $pagenow;
	if ($pagenow != 'index.php') {
		return;
	}
	if (!is_super_admin()) {
		return;
	}
	if (isset($_POST['shopr_nag_notice_dismissed'])) {
		update_option('shopr_nag_notice', 1);
	}
	if (get_option('shopr_nag_notice')) {
		return;
	}
	// if new install, don't show
	if (get_transient('shopr_new_user_wait')) {
		return;
	}
	if (!is_shopr_active()) {
		return;
	}
	$products = wp_count_posts($post_type = 'shopr_product');
	$total_products = $products->publish + $products->draft;
	if (absint($total_products) < 25) {
		return;
	}
	?>
	<div class="notice notice-success is-dismissible">
		<h2><span class="dashicons dashicons-cart"></span> Shopr</h2>
		<p>It looks like you've been using the Shopr plugin a few days now. If you have found the plugin useful, we would really appreciate it if you could leave a quick review on <a href="https://www.pipdig.co/shop/shopr-wordpress-plugin/?cachebust<?php echo rand(1,100); ?>" target="_blank">this page</a>. It will help us to spread the word and keep new updates and features coming :)</p>
		<form action="<?php echo admin_url(); ?>" method="post">
			<?php wp_nonce_field('shopr_nag_notice_nonce'); ?>
			<input type="hidden" value="true" name="shopr_nag_notice_dismissed" />
			<p class="submit" style="margin-top: 5px; padding-top: 5px;">
				<input name="submit" class="button" value="Hide this notice" type="submit" />
			</p>
		</form>
	</div>
	<?php
}
add_action( 'admin_notices', 'shopr_nag_notice', 2 );


function is_shopr_active() {

	$me = get_site_url();

	if (strpos($me, '127.0.0.1') !== false) {
		return 1;
	} elseif (strpos($me, '.local') !== false) {
		return 1;
	} elseif (strpos($me, 'localhost') !== false) {
		return 1;
	} elseif (strpos($me, 'dev.') !== false) {
		return 1;
	} elseif (strpos($me, '/~') !== false) {
		return 1;
	} elseif (strpos($me, '.pipdig.co') !== false) {
		return 1;
	} elseif (is_multisite() && (get_blog_count() > 1)) {
		return 1;
	}

	if ( false === ( $active = get_transient( 'shopr_active' ) )) {

		$pipdig_id = get_option('pipdig_id');
		if (!$pipdig_id) {
			$pipdig_id = sanitize_text_field(substr(str_shuffle(MD5(microtime())), 0, 10));
			add_option('pipdig_id', $pipdig_id);
		}

		$active = 0;
		$request_array = array();

		$options = get_option('shopr_options');
		if (empty($options['license_key'])) {
			return false;
		} else {
			$key = strip_tags(trim($options['license_key']));
		}

		$request_array['domain'] = $me;
		$request_array['id'] = $pipdig_id;
		$request_array['tempToken'] = 'dcx15';
		$request_array['key'] = $key;
		$request_array['plugin_v'] = SHOPR_VERSION;

		$url = add_query_arg($request_array, 'https://www.pipdig.co/shopr_validate.php');

		$args = array(
			'timeout' => 9,
		);

		$response = wp_safe_remote_get($url, $args);

		if (!is_wp_error($response)) {
			$result = absint($response['body']);

			if ($result === 1 || $result === 2) {
				$active = 1;
				set_transient( 'shopr_active', $active, 2 * DAY_IN_SECONDS );
			} elseif ($result === 8) {
				deactivate_plugins(plugin_basename(__FILE__));
			} else {
				$active = 0;
				set_transient( 'shopr_active', $active, 12 * HOUR_IN_SECONDS );
			}
		}

	}
	return $active;
}

// license key notice
function shopr_license_notice() {
	if (!current_user_can('edit_theme_options')) {
		return;
	}
	global $pagenow;
	if ( ($pagenow != 'index.php') && ($pagenow != 'plugins.php') ) {
		return;
	}
	if (is_shopr_active()) {
		return;
	}
	?>
	<div id="shopr_not_active_notice" class="notice notice-error is-dismissible">
		<h2>Shopr Plugin License Key</h2>
		<p>Hey there! Thank you for installing the Shopr plugin. Please note that the plugin is not active due to no license key being set in the options. Please <a href="<?php echo admin_url('edit.php?post_type=shopr_product&page=settings'); ?>">add your license key</a> to ensure all features work correctly.</p>
		<p>You can find your license key in your <a href="https://support.pipdig.co/articles/shopr-license-key/" target="_blank" rel="noopener">email receipt</a>.</p>
	</div>
	<?php
}
add_action( 'admin_notices', 'shopr_license_notice', 1 );

function shopr_plugin_puc_icons( $info, $response = null ) {
	$info->icons = array('1x' => 'https://pipdigz.co.uk/p3/icon-128x128.png','2x' => 'https://pipdigz.co.uk/p3/icon-256x256.png');
	return $info;
}
//if (is_shopr_active()) {
require_once 'admin/plugin-update-checker/plugin-update-checker.php';$updater = Puc_v4_Factory::buildUpdateChecker('https://bitbucket.org/pipdig/shopr', __FILE__, 'shopr');$updater->setAuthentication(array('consumer_key' => 'AaUVwaxwZBCrBTVnCq', 'consumer_secret' => 'JbYbsgdJ5RmKzRDN9HBK7gbnpRTCezv2'));$updater->setBranch('master');$updater->addResultFilter('shopr_plugin_puc_icons');
//}
function shopr_textdomain() {
	load_plugin_textdomain( 'shopr', false, 'shopr/languages' );
}
add_action( 'plugins_loaded', 'shopr_textdomain' );


function shopr_activate() {
	// set transient for 7 days on new activation
	set_transient( 'shopr_new_user_wait', 1, 14 * DAY_IN_SECONDS );
}
register_activation_hook( __FILE__, 'shopr_activate' );


// track clicks on products
function shopr_click_counter_script() {
	?>
	<script>
	jQuery(document).ready(function($){
		// Shopr click counter
		var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
		$(".shopr_click_counter a").click(function() {
			if ($(this).attr("data-shopr-product-id")) {
				var id = $(this).data("shopr-product-id");
				if (typeof id == 'number') {
					var data = {
						action: "shopr_product_click_counter",
						"shopr_product_id": id,
					};
					$.post(ajaxurl, data, function(response) {
						//alert(response);
					});
				}
			}
		});
	});
	</script>
	<?php
}
// update counter when product is clicked
function shopr_product_click_counter() {
	$id = strip_tags($_POST['shopr_product_id']);
	$count = absint(get_post_meta($id, 'shopr_product_clicks', true));
	$count++;
	update_post_meta($id, 'shopr_product_clicks', $count);
	echo $count;
	wp_die();
}
add_action( 'wp_ajax_nopriv_shopr_product_click_counter', 'shopr_product_click_counter' );
add_action( 'wp_ajax_shopr_product_click_counter', 'shopr_product_click_counter' );


// Exclude products From Yoast SEO Sitemap
function shopr_exclude_products_yoast($value, $post_type) {
	if ($post_type == 'shopr_product') return true;
}
add_filter('wpseo_sitemap_exclude_post_type', 'shopr_exclude_products_yoast', 10, 2);

// Exclude Colelctions Yoast SEO Sitemap
function shopr_exclude_product_collections_yoast($value, $taxonomy) {
	if ($taxonomy == 'shopr_category') return true;
}
add_filter('wpseo_sitemap_exclude_taxonomy', 'shopr_exclude_product_collections_yoast', 10, 2);
