<?php
if (!defined('ABSPATH')) die;

function shopr_shopthepost_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'size' => 'small',
		'collection' => '',
		//'rows' => 1,
		'pagination' => false,
		'arrows' => true,
		'autoplay' => true,
		'title' => '',
		'show_product_title' => '',
		'show_product_subtitle' => '',
		'show_product_price' => '',
		'order' => '',
		'shopstyle' => '',
		'rewardstyle' => '',
		'wc_category' => '',
		'force_carousel' => false, // used to force carousel rather than show < 5 items as single images
	), $atts ) );

	wp_enqueue_style('shopr');
	wp_enqueue_script('pipdig-flickity');
	
	$collection = trim($collection);

	$force_carousel = filter_var( $force_carousel, FILTER_VALIDATE_BOOLEAN );

	$pagination = filter_var( $pagination, FILTER_VALIDATE_BOOLEAN );

	if ($pagination) {
		$pagination = 'true';
	} else {
		$pagination = 'false';
	}

	/*
	$rows = absint($rows);
	if ($rows > 5) {
		$rows = 5;
	} elseif ($rows < 1) {
		$rows = 1;
	}
	*/

	$arrows = filter_var( $arrows, FILTER_VALIDATE_BOOLEAN );

	if ($arrows) {
		$arrows = 'true';
	} else {
		$arrows = 'false';
	}
	
	$autoplay = filter_var( $autoplay, FILTER_VALIDATE_BOOLEAN );

	if ($autoplay) {
		$autoplay = 6000;
	} else {
		$autoplay = 'false';
	}

	$show_product_title = filter_var( $show_product_title, FILTER_VALIDATE_BOOLEAN );
	$show_product_subtitle = filter_var( $show_product_subtitle, FILTER_VALIDATE_BOOLEAN );
	$show_product_price = filter_var( $show_product_price, FILTER_VALIDATE_BOOLEAN );

	$output = '';

	$tax_query = array(
		array(
			'taxonomy' => 'shopr_category',
			'field' => 'slug',
			'terms' => $collection,
		),
	);

	$query = new WP_Query( array(
		'post_type' => 'shopr_product',
		'post_status' => 'publish',
		'posts_per_page' => '-1',
		'tax_query' => $tax_query
		)
	);

	$products = array();

	if ( $query->have_posts() ) {

		while ( $query->have_posts() ) : $query->the_post();

			$id = get_the_ID();

			$link = get_post_meta($id, 'shopr_product_link', true);

			$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'shopr-product' );
			if ($thumb) {
				$image = esc_url($thumb['0']);
			} elseif (get_post_meta($id, 'shopr_product_linked_img', true)) {
				$image = get_post_meta($id, 'shopr_product_linked_img', true);
			} else {
				continue;
			}

			$products[] = array(
				'id' => $id,
				'title' => get_the_title(),
				'thumbnail' => $image,
				'link' => $link,
				'subtitle' => get_post_meta($id, 'shopr_product_subtitle', true),
				'price' => get_post_meta($id, 'shopr_product_price', true),
			);

		endwhile; wp_reset_query();

	}
	
	$term_data = get_term_by('slug', $collection, 'shopr_category');
	if ($term_data && !is_wp_error($term_data)) {
		
		$term_id = $term_data->term_id;
		
		$shopstyle_term_id = get_term_meta($term_id, 'shopstyle', true);
		if (is_numeric($shopstyle_term_id)) {
			$shopstyle_term_products = shopr_get_shopstyle_list(trim(strip_tags($shopstyle_term_id)));
			if (is_array($shopstyle_term_products)) {
				foreach ($shopstyle_term_products as $product) {
					$products[] = array(
						'id' => '', // it's for the click tracker, so leave it empty
						'title' => $product->title,
						'thumbnail' => $product->thumbnail,
						'link' => $product->link,
						'subtitle' => '',
						'price' => '',
					);
				}
			}
		}
		
		$rewardstyle_term_id = get_term_meta($term_id, 'rewardstyle', true);
		if (is_numeric($rewardstyle_term_id)) {
			$rewardstyle_term_products = shopr_get_rewardstyle_list(trim(strip_tags($rewardstyle_term_id)));
			if (is_array($rewardstyle_term_products)) {
				foreach ($rewardstyle_term_products as $product) {
					$products[] = array(
						'id' => '', // it's for the click tracker, so leave it empty
						'title' => $product->title,
						'thumbnail' => $product->thumbnail,
						'link' => $product->link,
						'subtitle' => '',
						'price' => '',
					);
				}
			}
		}
		
		
	}

	// add shopstyle list to items
	if (is_numeric($shopstyle)) {
		
		$options = get_option('shopr_options');
		if (!empty($options['shopstyle_key'])) { // check if api key is in settings.
			
			$shopstyle_products = shopr_get_shopstyle_list(trim(strip_tags($shopstyle)));
			if (is_array($shopstyle_products)) {
				foreach ($shopstyle_products as $product) {
					$products[] = array(
						'id' => '', // it's for the click tracker, so leave it empty
						'title' => $product->title,
						'thumbnail' => $product->thumbnail,
						'link' => $product->link,
						'subtitle' => '',
						'price' => '',
					);
				}
			}
			
		} elseif (is_super_admin()) {
			
			return 'Shopr: You have entered a Shoptsyle List ID, but you still need to add your Shopstyle API key to the <a href="'.admin_url('edit.php?post_type=shopr_product&page=settings').'">settings</a>. Please do that first.';
			die;
			
		}
		
	}

	// add rewardstyle list to items
	if (is_numeric($rewardstyle)) {
		$rewardstyle_products = shopr_get_rewardstyle_list($rewardstyle);
		if (is_array($rewardstyle_products)) {
			foreach ($rewardstyle_products as $product) {
				$products[] = array(
					'id' => '',
					'title' => $product->title,
					'thumbnail' => $product->thumbnail,
					'link' => $product->link,
					'subtitle' => '',
					'price' => '',
				);
			}
		}
	}
	
	if ($wc_category && function_exists('wc_get_products')) {
		$wc_args = array(
			'category' => array(trim($wc_category)),
			//'return' => 'ids',
		);
		$wc_products = wc_get_products($wc_args);
		
		if (is_array($wc_products)) {
			foreach ($wc_products as $product) {
				$products[] = array(
					'id' => '',
					'title' => $product->get_title(),
					'thumbnail' => esc_url(reset(simplexml_import_dom(DOMDocument::loadHTML($product->get_image('shopr-product')))->xpath("//img/@src"))),
					'link' => $product->get_product_url(),
					'subtitle' => '',
					'price' => '',
				);
			}
		}
	}

	$shopthepost_id = 'shopr_shopthepost_'.rand(0,999999999);

	if ($title) {
		$output .= '<h3 class="shopr_shopthepost_title">'.esc_html($title).'</h3>';
	}

	if ($products) {

		if ($order == 'random') {
			shuffle($products);
		}

		$size_class = 'shopr_shopthepost_small';
		if ($size == 'medium') {
			$size_class = 'shopr_shopthepost_medium';
		} elseif ($size == 'large') {
			$size_class = 'shopr_shopthepost_large';
		}

		if (count($products) > 3 || $force_carousel) {

			$output .= '<div id="'.$shopthepost_id.'" class="shopr_shopthepost shopr_click_counter nopin '.$size_class.'" data-flickity=\'{ "groupCells": true, "cellSelector": ".shopr_product", "wrapAround": true, "lazyLoad": 1, "pageDots": '.$pagination.', "prevNextButtons": '.$arrows.', "autoPlay": '.$autoplay.' }\'>';

			$product_output = '';
			foreach ($products as $product) {
				if (empty($product['link']) || empty($product['thumbnail'])) {
					continue;
				}
				
				$tracker_id = '';
				if (!empty($product['id'])) {
					$tracker_id = 'data-shopr-product-id="'.esc_attr($product['id']).'"';
				}

				$ga_tracking = 'onClick=\'ga( "send", "event", { eventCategory: "Shopr", eventAction: "Shop the post widget" } );\'';
				if (!empty($product['title'])) {
					$ga_tracking = 'onClick=\'ga( "send", "event", { eventCategory: "Shopr", eventAction: "Grid Shop", eventLabel: "'.esc_attr($product['title']).'" } );\'';
				}

				$product_output .= '<div class="shopr_product">';
				$product_output .= '<a href="'.esc_url($product['link']).'" target="_blank" rel="nofollow noopener" '.$tracker_id.' '.$ga_tracking.'>';
					$product_output .= '<span class="shopr_product_img_wrap">';
						$product_output .= '<img data-flickity-lazyload="'.esc_url($product['thumbnail']).'" alt="'.esc_attr($product['title']).'" data-pin-nopin="nopin" class="skip-lazy nopin" />';
					$product_output .= '</span>';
				$product_output .= '</a>';
				if ($show_product_title || $show_product_subtitle || $show_product_price) {
					$meta_output = '';
					if ($show_product_title && $product['title']) {
						$meta_output = '<span class="shopr_shopthepost_product_title">'.$product['title'].'</span>';
					}
					if ($show_product_subtitle && $product['subtitle']) {
						$meta_output .= '<br /><span class="shopr_shopthepost_product_subtitle">'.$product['subtitle'].'</span>';
					}
					if ($show_product_price && $product['price']) {
						$meta_output .= '<br /><span class="shopr_shopthepost_product_price">'.$product['price'].'</span>';
					}
					if ($meta_output) {
						$product_output .= '<div class="shopr_shopthepost_product_meta">'.strip_tags($meta_output, '<br>,<span>').'</div>';
					}
				}
				$product_output .= '</div>';
			}
			$output .= $product_output;
			if (count($products) < 4) {
				$output .= $product_output;
				$output .= $product_output;
			}
			if (count($products) < 7) {
				$output .= $product_output;
			}
			if (count($products) < 12) {
				$output .= $product_output;
			}

			$output .= '</div>';

		} else {

			$output .= '<div class="shopr_shopthepost_static nopin '.$size_class.'">';
			foreach ($products as $product) {
				
				if (empty($product['link']) || empty($product['thumbnail'])) {
					continue;
				}
				
				$tracker_id = '';
				if (!empty($product['id'])) {
					$tracker_id = 'data-shopr-product-id="'.esc_attr($product['id']).'"';
				}

				$ga_tracking = 'onClick=\'ga( "send", "event", { eventCategory: "Shopr", eventAction: "Shop the post widget" } );\'';
				if (!empty($product['title'])) {
					$ga_tracking = 'onClick=\'ga( "send", "event", { eventCategory: "Shopr", eventAction: "Grid Shop", eventLabel: "'.esc_attr($product['title']).'" } );\'';
				}
				
				$output .= '<a href="'.esc_url($product['link']).'" target="_blank" rel="nofollow noopener" '.$tracker_id.' '.$ga_tracking.'>';
					$output .= '<img src="'.esc_url($product['thumbnail']).'" alt="'.esc_attr($product['title']).'" data-pin-nopin="nopin" class="skip-lazy nopin" />';
				$output .= '</a>';
				
			}
			$output .= '</div>';

		}

		add_action( 'wp_footer', 'shopr_click_counter_script', 99999 );

	} else {
		$output .= 'no products';
	}

	return $output;

}
add_shortcode( 'shopr_shopthepost', 'shopr_shopthepost_shortcode' );
