<?php
if (!defined('ABSPATH')) die;

function shopr_grid_shortcode( $atts, $content = null ) {
	extract( shortcode_atts( array(
		'collection' => '',
		'collections' => '', // alias
		'exclude_collection' => '',
		'exclude_collections' => '', // alias
		'initial' => '*',
		//'columns' => 4,
		'number' => '-1',
		'titles' => false,
		//'subtitles' => false,
		'filters' => '',
		//'filters_position' => 'top',
		//'shopnow' => false,
		'order' => '',
		'shopstyle' => '',
		'rewardstyle' => '',
		'wc_category' => '',
		'label_browse_collection' => __('Browse Collection', 'shopr'),
		'label_shop_now' => __('Shop Now', 'shopr'),
		'label_show_all' => __('Show all', 'shopr'),
	), $atts ) );

	//print_r(get_option('poop'));

	//show_admin_bar(false);

	//$titles = filter_var( $titles, FILTER_VALIDATE_BOOLEAN );
	//$subtitles = filter_var( $subtitles, FILTER_VALIDATE_BOOLEAN );
	//$filters = filter_var( $filters, FILTER_VALIDATE_BOOLEAN ); // don't do it for this, it messes up the mojo
	//$shopnow = filter_var( $shopnow, FILTER_VALIDATE_BOOLEAN );

	$titles = absint(get_theme_mod('shopr_show_titles'));
	$subtitles = absint(get_theme_mod('shopr_show_subtitles'));
	$prices = absint(get_theme_mod('shopr_show_prices'));
	$shopnow = absint(get_theme_mod('shopr_show_shopnow'));
	$columns = absint(get_theme_mod('shopr_columns', 4));
	$filters_cust = absint(get_theme_mod('shopr_show_filters', 1));
	$filters_position = absint(get_theme_mod('shopr_filters_position', 1));

	wp_enqueue_style('shopr');

	$output = $tax_query = '';

	$mosaic_id = 'shopr_mosaic_'.rand(0,999999999);

	// alias
	if ($collections && empty($collection)) {
		$collection = $collections;
	}

	// alias
	if ($exclude_collections && empty($exclude_collection)) {
		$exclude_collection = $exclude_collections;
	}

	if ($number == 'all') {
		$number = '-1';
	} else {
		$number = absint($number);
		if ($number < 2) {
			$number = '-1';
		}
	}

	// ==== create tax query with includes and excludes

	$tax_query = array('relation' => 'AND');

	if ($collection != 'all' && $collection != '' && $collection != 'none') {
		if (strpos($collection, ',') !== false ) { // in case user supplies list of collections
			$collection = explode(',', $collection);
		}
		$include_collections = array(
			'taxonomy' => 'shopr_category',
			'field' => 'slug',
			'terms' => $collection,
		);
		array_push($tax_query, $include_collections);
	}

	if ($exclude_collection) {
		if (strpos($exclude_collection, ',') !== false ) { // in case user supplies list of collections
			$exclude_collection = explode(',', $exclude_collection);
		}
		$exclude_collections = array(
			'taxonomy' => 'shopr_category',
			'field' => 'slug',
			'terms' => $exclude_collection,
			'operator' => 'NOT IN',
		);
		array_push($tax_query, $exclude_collections);
	}

	// ======= end tax queries

	$query_args = array(
		'post_type' => 'shopr_product',
		'post_status' => 'publish',
		'posts_per_page' => $number,
		'tax_query' => $tax_query,
	);

	/*
	echo '<pre>';
	print_r($query_args);
	echo '</pre>';
	die;
	*/

	$products = array();

	if (current_user_can('edit_theme_options') && !is_customize_preview() && empty($collection)) {
		$output .= '<p style="text-align: center" id="shopr_customizer_grid_notice">You can edit the style of this page in the <a href="'.admin_url('customize.php?autofocus[section]=shopr_section').'&url='.get_permalink().'" rel="nofollow">Customizer</a>. Only site admins can see this text.</p>';
	}

	$output .= '<div class="shopr_grid nopin">';

	// convert exclude_collection slugs into IDs so we can pass to "exclude" terms_args
	$exclude_collection_ids = array();
	if (is_array($exclude_collection)) {
		foreach ($exclude_collection as $exclude_coll) {
			$exclude_coll = trim($exclude_coll);
			$term = get_term_by('slug', $exclude_coll, 'shopr_category');
			$exclude_collection_ids[] = $term->term_id;
		}
	} elseif ($exclude_collection) {
		$term = get_term_by('slug', $exclude_collection, 'shopr_category');
		if (!empty($term->term_id)) {
			$exclude_collection_ids = $term->term_id;
		}
	}

	$terms_args = array(
		'taxonomy' => 'shopr_category',
		'exclude' => $exclude_collection_ids
	);
	$tax_terms = get_terms($terms_args);

	// check if collections have been set. If they have, is it more than one or just a single collection?
	// If single collection, remove filters. If list of collections, only display those filters
	$collections_defined = false;
	if ($collection != 'all' && $collection != '') {
		if (is_array($collection)) {
			if (count($collection) > 1) {
				$collections_defined = true;
			} else {
				$filters_cust = false;
			}
		} else {
			$filters_cust = false;
		}
	}

	// Display filters via shortode att rather than cust?
	// Purposefully set as strings so we can be more selective with defaults.
	if ($filters == 'no' || $filters == 'false' || $filters == 'off') {
		$filters_cust = false;
	} elseif ($filters == 'yes' || $filters == 'true' || $filters == 'on') {
		$filters_cust = true;
	}

	$filters_warpper_class = $mosaic_wrapper_class = $filters_title = '';
	
	if ($filters_cust) {
	
		if (($tax_terms && !is_wp_error($tax_terms)) && ($filters_position == 1)) {
			$filters_warpper_class = 'shopr_grid_layout_left_filters';
			$mosaic_wrapper_class = 'shopr_grid_layout_left_mosaic';
			$filters_title = '<div class="shopr_filters_title">'.$label_browse_collection.'</div>';
		}
		
		// collections set, probably RS or Shopstyle lists
		if ($collections_defined && is_array($collection)) {
			
			$output .= '<div id="'.$mosaic_id.'_filters" class="shopr_grid_filters '.$filters_warpper_class.'">';
			$output .= $filters_title;
			$output .= '<ul>';
				$output .= '<li class="shopr_label_show_all"><a href="#" data-option-value="*">'.$label_show_all.'</a></li>';
				foreach ($collection as $item) {
					$term_data = get_term_by('slug', $item, 'shopr_category');
					$output .= '<li><a href="#'.esc_attr($item).'" class="filter" data-option-value=".shopr_category_'.esc_attr($item).'">'.esc_html($term_data->name).'</a></li>';
				}
			$output .= '</ul>';
			$output .= '</div>';
		
		// collections set, normal products from Shopr
		} elseif ($tax_terms && !is_wp_error($tax_terms)) {
			$output .= '<div id="'.$mosaic_id.'_filters" class="shopr_grid_filters '.$filters_warpper_class.'">';
			$output .= $filters_title;
			$output .= '<ul>';
				$output .= '<li><a href="#" data-option-value="*">'.$label_show_all.'</a></li>';
				foreach ($tax_terms as $tax_term) {
					$output .= '<li><a href="#'.esc_attr($tax_term->slug).'" class="filter" data-option-value=".shopr_category_'.esc_attr($tax_term->slug).'">'.esc_html($tax_term->name).'</a></li>';
				}
			$output .= '</ul>';
			$output .= '</div>';
		}
		
	}

	$output .= '<div id="'.$mosaic_id.'" class="shopr_mosaic shopr_click_counter '.$mosaic_wrapper_class.'">';

	if ($collection != 'none') {
		$query = new WP_Query( $query_args );
		if ( $query->have_posts() ) {

			while ( $query->have_posts() ) : $query->the_post();

				$id = get_the_ID();
				
				$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'shopr-product' );
				if ($thumb) {
					$image = esc_url($thumb['0']);
				} elseif (get_post_meta($id, 'shopr_product_linked_img', true)) {
					$image = get_post_meta($id, 'shopr_product_linked_img', true);
				} else {
					continue;
				}

				$categories = '';
				$terms = get_the_terms($id, 'shopr_category');
				if ($terms && !is_wp_error($terms)) {
					foreach ($terms as $term) {
						$categories .= ' shopr_category_'.$term->slug;
					}
				}

				$products[] = array (
					'id' => $id,
					'title' => get_the_title(),
					'subtitle' => get_post_meta($id, 'shopr_product_subtitle', true),
					'thumbnail' => $image,
					'link' => get_post_meta($id, 'shopr_product_link', true),
					'categories' => $categories,
					'price' => get_post_meta($id, 'shopr_product_price', true),
				);

			endwhile; wp_reset_query();
		} // if have posts
		
		if ($collection) {
			
			if (is_array($collection)) { // already checked for string of comma separated list earlier
			
				foreach ($collection as $collection_item) {
					
					$term_data = get_term_by('slug', $collection_item, 'shopr_category');
					
					if ($term_data && !is_wp_error($term_data)) {
						
						$term_id = $term_data->term_id;
						
						// Shopstyle ID assigned to this collection
						$shopstyle_term_id = get_term_meta($term_id, 'shopstyle', true);
						if (is_numeric($shopstyle_term_id)) {
							$shopstyle_term_products = shopr_get_shopstyle_list(trim(strip_tags($shopstyle_term_id)));
							if (is_array($shopstyle_term_products)) {
								foreach ($shopstyle_term_products as $product) {
									$products[] = array (
										'id' => '', // it's for the click tracker, so leave it empty
										'title' => $product->title,
										'subtitle' => '',
										'thumbnail' => $product->thumbnail,
										'link' => $product->link,
										'categories' => ' shopr_category_'.$term_data->slug,
										'price' => '',
									);
								}
							}
						}
						
						// RS widget assigned to this collection
						$rewardstyle_term_id = get_term_meta($term_id, 'rewardstyle', true);
						if (is_numeric($rewardstyle_term_id)) {
							$rewardstyle_term_products = shopr_get_rewardstyle_list(trim(strip_tags($rewardstyle_term_id)));
							if (is_array($rewardstyle_term_products)) {
								foreach ($rewardstyle_term_products as $product) {
									$products[] = array (
										'id' => '', // it's for the click tracker, so leave it empty
										'title' => $product->title,
										'subtitle' => '',
										'thumbnail' => $product->thumbnail,
										'link' => $product->link,
										'categories' => ' shopr_category_'.$term_data->slug,
										'price' => '',
									);
								}
							}
						}
					
					}
					
				}
				
			} else {
				
				$term_data = get_term_by('slug', $collection, 'shopr_category');
				
				if ($term_data && !is_wp_error($term_data)) {
				
					$term_id = $term_data->term_id;
					
					// Shopstyle ID assigned to this collection
					$shopstyle_term_id = get_term_meta( $term_id, 'shopstyle', true );
					$shopstyle_term_products = shopr_get_shopstyle_list(trim(strip_tags($shopstyle_term_id)));
					if (is_array($shopstyle_term_products)) {
						foreach ($shopstyle_term_products as $product) {
							$products[] = array (
								'id' => '', // it's for the click tracker, so leave it empty
								'title' => $product->title,
								'subtitle' => '',
								'thumbnail' => $product->thumbnail,
								'link' => $product->link,
								'categories' => ' shopr_category_'.$term_data->slug,
								'price' => '',
							);
						}
					}
					
					// RS widget assigned to this collection
					$rewardstyle_term_id = get_term_meta( $term_id, 'rewardstyle', true );
					$rewardstyle_term_products = shopr_get_rewardstyle_list(trim(strip_tags($rewardstyle_term_id)));
					if (is_array($rewardstyle_term_products)) {
						foreach ($rewardstyle_term_products as $product) {
							$products[] = array (
								'id' => '', // it's for the click tracker, so leave it empty
								'title' => $product->title,
								'subtitle' => '',
								'thumbnail' => $product->thumbnail,
								'link' => $product->link,
								'categories' => ' shopr_category_'.$term_data->slug,
								'price' => '',
							);
						}
					}
				
				}
				
			}
			
		}
		
	/*
	echo '<pre>';
	print_r($products);
	echo '</pre>';
	die;
	*/
	}

	// add shopstyle list to items
	if (is_numeric($shopstyle)) {
		
		$options = get_option('shopr_options');
		if (!empty($options['shopstyle_key'])) { // check if api key is in settings.
			
			$shopstyle_products = shopr_get_shopstyle_list(trim(strip_tags($shopstyle)));
			if (is_array($shopstyle_products)) {
				foreach ($shopstyle_products as $product) {
					$products[] = array (
						'id' => '', // it's for the click tracker, so leave it empty
						'title' => $product->title,
						'subtitle' => '',
						'thumbnail' => $product->thumbnail,
						'link' => $product->link,
						'categories' => '',
						'price' => '',
					);
				}
			}
			
		} elseif (is_super_admin()) {
			
			return 'Shopr: You have entered a Shoptsyle List ID, but you still need to add your Shopstyle API key to the <a href="'.admin_url('edit.php?post_type=shopr_product&page=settings').'">settings</a>. Please do that first.';
			die;
			
		}
		
	}

	// add rewardstyle list to items
	if (is_numeric($rewardstyle)) {
		$rewardstyle_products = shopr_get_rewardstyle_list(trim(strip_tags($rewardstyle)));
		if (is_array($rewardstyle_products)) {
			foreach ($rewardstyle_products as $product) {
				$products[] = array (
					'id' => '', // it's for the click tracker, so leave it empty
					'title' => $product->title,
					'subtitle' => '',
					'thumbnail' => $product->thumbnail,
					'link' => $product->link,
					'categories' => '',
					'price' => '',
				);
			}
		}
	}
	
	if ($wc_category && function_exists('wc_get_products')) {
		$wc_args = array(
			'category' => array(trim($wc_category)),
			//'return' => 'ids',
		);
		$wc_products = wc_get_products($wc_args);
		
		if (is_array($wc_products)) {
			foreach ($wc_products as $product) {
				$products[] = array(
					'id' => '',
					'title' => $product->get_title(),
					'subtitle' => '',
					'thumbnail' => esc_url(reset(simplexml_import_dom(DOMDocument::loadHTML($product->get_image('shopr-product')))->xpath("//img/@src"))),
					'link' => $product->get_product_url(),
					'categories' => '',
					'price' => $product->get_price(),
				);
			}
		}
	}
	
	if ($products) {

		if ($order == 'random') {
			shuffle($products);
		}

		foreach ($products as $product) {

			if (empty($product['link']) || empty($product['thumbnail'])) {
				continue;
			}

			$ga_tracking = 'onClick=\'ga( "send", "event", { eventCategory: "Shopr", eventAction: "Grid Shop" } );\'';
			if (!empty($product['title'])) {
				$ga_tracking = 'onClick=\'ga( "send", "event", { eventCategory: "Shopr", eventAction: "Grid Shop", eventLabel: "'.esc_attr($product['title']).'" } );\'';
			}

			$tracker_id = '';
			if (!empty($product['id'])) {
				$tracker_id = 'data-shopr-product-id="'.esc_attr($product['id']).'"';
			}

			$output .= '<div class="shopr_product'.esc_attr($product['categories']).'">';
			$output .= '<a href="'.esc_url($product['link']).'" target="_blank" rel="nofollow noopener" '.$tracker_id.' '.$ga_tracking.'>';

				$output .= '<div class="shopr_product_img_wrap">';
					$output .= '<img src="'.esc_url($product['thumbnail']).'" alt="'.esc_attr($product['title']).'" data-pin-nopin="nopin" class="skip-lazy nopin" />';
					if ($shopnow) {
						$output .= '<div class="shopr_shopnow">'.$label_shop_now.'</div>';
					}
				$output .= '</div>';
				if (($titles && $product['title']) || ($subtitles && $product['subtitle']) || ($prices && $product['price'])) {
					$output .= '<div class="shopr_product_details">';
						if ($titles && !empty($product['title'])) {
							$output .= '<h4 class="shopr_product_title">'.strip_tags($product['title']).'</h4>';
						}
						if ($subtitles && !empty($product['subtitle'])) {
							$output .= '<div class="shopr_product_subtitle">'.strip_tags($product['subtitle']).'</div>';
						}
						if ($prices && !empty($product['price'])) {
							$output .= '<div class="shopr_product_price">'.strip_tags($product['price']).'</div>';
						}
					$output .= '</div>';
				}
			$output .= '</a>';
			$output .= '</div>';
		}

	$initial_out = '';
	if (!empty($initial) && $initial != '*') {
		$initial_out = '.shopr_category_'.$initial;
	}

	$output .= '</div>'; // .shopr_isotope

	$output .= '<div style="clear: both;"></div>';

	$output .= '</div>'; // .shopr_grid

	$item_width = (100 / $columns) - 2;

	$output .= '
	<style>
	body .shopr_mosaic .shopr_product {
		width: '.$item_width.'%;
	}
	@media screen and (max-width: 719px) {
		body .shopr_mosaic .shopr_product {
			width: 31%;
		}
	}
	@media screen and (max-width: 500px) {
		body .shopr_mosaic .shopr_product {
			width: 48%
		}
	}
	</style>
	';
	
	add_action( 'wp_footer', 'shopr_grid_shortcode_footer_script', 9999 );
	add_action( 'wp_footer', 'shopr_click_counter_script', 99999 );

	$output .= '
	<script>
		shopr_mosaic_ids.push(jQuery("#'.$mosaic_id.'"));
		shopr_mosaic_filters.push(jQuery("#'.$mosaic_id.'_filters"));
		//var shopr_initial_out = "'.$initial_out.'";
	</script>
	';

	} else {
		$output = 'Shopr: No products to show.';
	}

	return $output;

}
add_shortcode( 'shopr', 'shopr_grid_shortcode' );


function shopr_grid_shortcode_head_script() {
	?>
	<!-- <?php echo 'Shopr '.SHOPR_VERSION; ?> -->
	<script>
		var shopr_mosaic_ids = [], shopr_mosaic_filters = [], shopr_columns = <?php echo absint(get_theme_mod('shopr_columns', 4)); ?>;
	</script>
	<?php
}
add_action('wp_head', 'shopr_grid_shortcode_head_script', 99999);


function shopr_grid_shortcode_footer_script() {
	?>
	<script>
	jQuery(document).ready(function($){	

		// init isotope on each container
		// wait for images to load in all grid containers
		$('.shopr_mosaic').imagesLoaded( function(){
			$.each(shopr_mosaic_ids, function (j) {
				if (this.width() < 500) {
					var shopr_columns = 2;
				}
				this.isotope({
					//filter: shopr_initial_out,
					itemSelector: '.shopr_product',
					masonry: {
						columnWidth: this.width() / shopr_columns,
					}
				});
				this.addClass('shopr_mosaic_loaded');
			});
		});
		
		// wait 3 seconds after full page load then set isotope again. Helps with some 3rd party theme issues.
		$(window).load(function(){
			setTimeout(function() {
				$.each(shopr_mosaic_ids, function (j) {
					if (this.width() < 500) {
						var shopr_columns = 2;
					}
					this.isotope({
						//filter: shopr_initial_out,
						itemSelector: '.shopr_product',
						masonry: {
							columnWidth: this.width() / shopr_columns,
						}
					});
					this.addClass('shopr_mosaic_loaded');
				});
			}, 3000);
		});
		
		// init filter links for each instance
		$.each(shopr_mosaic_filters, function (index, object) {
			
			var filter_links = object.find('a');
			
			filter_links.click(function () {
				
				var this_item = $(this),
				filters = this_item.parents('.shopr_grid_filters'),
				options = {},
				value = this_item.attr('data-option-value');
				
				// make option object dynamically
				options['filter'] = value;
				shopr_mosaic_ids[index].isotope(options);
				
				// scroll to products on smaller screens
				if (document.documentElement.clientWidth < 720 ) {
					$("html, body").animate({
						scrollTop: $(shopr_mosaic_ids[index]).offset().top
					}, 200);
				}
				
				return false;
				
			});
			
		});
		
		// set columns on window resize
		window.addEventListener("resize", function(event) {
			$.each(shopr_mosaic_ids, function (j) {
				if (this.width() < 500) {
					var shopr_columns = 2;
				} else if (this.width() < 720) {
					var shopr_columns = 3;
				}
				this.isotope({
					//filter: shopr_initial_out,
					itemSelector: '.shopr_product',
					masonry: {
						columnWidth: this.width() / shopr_columns,
					}
				});
			});
		});
		
		// scroll to products on mobiles
		/*
		if (document.documentElement.clientWidth < 770 ) {
			$(".shopr_grid_filters li a").click(function(){
				$("html, body").animate({
					scrollTop: $(shopr_mosaic_id).offset().top
				}, 300);
			});
		}
		*/

	});
	</script>
	<?php
}
