<?php
if (!defined('ABSPATH')) die;

function vc_shopr_shopthepost() {
	
	$tax_terms = get_terms( array(
		'taxonomy' => 'shopr_category',
		'hide_empty' => false,
	) );
	
	$collections = array();
	if ($tax_terms && !is_wp_error($tax_terms)) {
		foreach ($tax_terms as $tax_term) {
			$collections[$tax_term->name] = $tax_term->slug;
		}
	}
	
	vc_map( 
		array(
			"name" => "Shopr Carousel",
			"base" => "shopr_shopthepost",
			"class" => "",
			"category" => "Content",
			"params" => array(
				array(
					"type" => "textfield",
					"holder" => "div",
					"class" => "",
					"heading" => "Title",
					"param_name" => "title"
				),
				array(
					"type" => "dropdown",
					"heading" => "Collection",
					"param_name" => "collection",
					"admin_label" => true,
					"value" => $collections,
				),
				array(
					"type" => "dropdown",
					"heading" => "Size",
					"param_name" => "size",
					"admin_label" => true,
					"value" => array(
						"Small" => "small",
						"Medium" => "medium",
						"Large" => "large"
					)
				),
				array(
					"type" => "dropdown",
					"heading" => "Order",
					"param_name" => "order",
					"admin_label" => true,
					"value" => array(
						"Normal" => "",
						"Random" => "random",
					)
				),
				array(
					"type" => "checkbox",
					"heading" => "Show product titles on hover",
					"param_name" => "show_product_title",
					"admin_label" => true,
				),
				array(
					"type" => "checkbox",
					"heading" => "Show product subtitles on hover",
					"param_name" => "show_product_subtitle",
					"admin_label" => true,
				),
				array(
					"type" => "checkbox",
					"heading" => "Show product price on hover",
					"param_name" => "show_product_price",
					"admin_label" => true,
				),
			)
		)
	);
}
add_action( 'vc_before_init', 'vc_shopr_shopthepost' );