<?php
if (!defined('ABSPATH')) die;

class Shopr_Shopthepost_Widget extends WP_Widget {

	// Holds widget settings defaults, populated in constructor.
	protected $defaults;

	// Constructor. Set the default widget options and create widget.
	function __construct() {

		$this->defaults = array(
			'title' => '',
			'collection' => '',
			'show_pagination' => false,
			'show_arrows' => true,
			'product_titles' => '',
			'product_subtitles' => '',
			'shopstyle' => '',
			'rewardstyle' => '',
			'wc_category' => '',
			'shop_link' => '',
		);

		$widget_ops = array(
			'classname' => 'shopr_widget_shopthepost',
			'description' => __('Show a carousel of Shopr products.', 'shopr'),
		);

		$control_ops = array(
			'id_base' => 'shopr_widget_shopthepost',
		);

		parent::__construct('shopr_widget_shopthepost', 'Shopr Carousel', $widget_ops, $control_ops);

	}

	// The widget content.
	function widget($args, $instance) {

		//* Merge with defaults
		$instance = wp_parse_args((array) $instance, $this->defaults);

		echo $args['before_widget'];

			if (!empty($instance['title'])) {
				echo $args['before_title'] . apply_filters('widget_title', $instance['title'], $instance, $this->id_base) . $args['after_title'];
			}
			
			$collection = $rewardstyle = $shopstyle = $wc_category = $shop_link = '';
			
			if (!empty($instance['collection'])) {
				$collection = $instance['collection'];
			}
			if (!empty($instance['rewardstyle']) && is_numeric($instance['shopstyle'])) {
				$rewardstyle = $instance['rewardstyle'];
			}
			if (!empty($instance['shopstyle']) && is_numeric($instance['shopstyle'])) {
				$shopstyle = $instance['shopstyle'];
			}
			if (!empty($instance['wc_category'])) {
				$wc_category = $instance['wc_category'];
			}
			if (!empty($instance['shop_link'])) {
				$shop_link = $instance['shop_link'];
			}
			
			$pagination = 'true';
			if (empty($instance['show_pagination'])) {
				$pagination = 'false';
			}

			$arrows = 'true';
			if (empty($instance['show_arrows'])) {
				$arrows = 'false';
			}

			$product_titles = 'true';
			if (empty($instance['product_titles'])) {
				$product_titles = 'false';
			}
			
			$product_subtitles = 'true';
			if (empty($instance['product_subtitles'])) {
				$product_subtitles = 'false';
			}
			
			if (isset($instance['size'])) { 
				$size = $instance['size'];
			} else {
				$size = 'small';
			}
			
			echo do_shortcode('[shopr_shopthepost collection="'.sanitize_text_field($collection).'" size="'.$size.'" rewardstyle="'.sanitize_text_field($rewardstyle).'" shopstyle="'.sanitize_text_field($shopstyle).'" wc_category="'.sanitize_text_field($wc_category).'" arrows="'.$arrows.'" pagination="'.$pagination.'" show_product_title="'.$product_titles.'" show_product_subtitle="'.$product_subtitles.'" force_carousel="true"]');
			
			if ($shop_link) {
				echo '<a href="'.esc_url($shop_link).'" target="_blank" rel="nofollow" class="shopr_carousel_widget_button">'.__('Shop Now', 'shopr').'</a>';
			}
			

		echo $args['after_widget'];

	}

	// Update a particular instance.
	function update($new_instance, $old_instance) {
		$new_instance['title'] = strip_tags($new_instance['title']);
		$new_instance['collection'] = strip_tags($new_instance['collection']);
		$new_instance['show_pagination'] = strip_tags($new_instance['show_pagination']);
		$new_instance['show_arrows'] = strip_tags($new_instance['show_arrows']);
		$new_instance['product_titles'] = strip_tags($new_instance['product_titles']);
		$new_instance['product_subtitles'] = strip_tags($new_instance['product_subtitles']);
		$new_instance['shopstyle'] = strip_tags($new_instance['shopstyle']);
		$new_instance['rewardstyle'] = strip_tags($new_instance['rewardstyle']);
		$new_instance['shop_link'] = strip_tags($new_instance['shop_link']);
		$new_instance['wc_category'] = strip_tags($new_instance['wc_category']);
		$new_instance['size'] =  strip_tags($new_instance['size']);
		return $new_instance;
	}

	// The settings update form.
	function form($instance) {

		// Merge with defaults
		$instance = wp_parse_args((array) $instance, $this->defaults);

		if (isset($instance['collection'])) {
			$collection = $instance['collection'];
		} else {
			$collection = '';
		}

		$tags_available = false;
		$tax_terms = get_terms( array(
			'taxonomy' => 'shopr_category',
			'hide_empty' => false,
		) );
		if ($tax_terms && !is_wp_error($tax_terms)) {
			$tags_available = true;
		}
		
		$wc_available = false;
		if (function_exists('wc_get_products')) {
			$wc_tax_terms = get_terms( array(
				'taxonomy' => 'product_cat',
				'hide_empty' => true,
			) );
			if ($wc_tax_terms && !is_wp_error($wc_tax_terms)) {
				$wc_available = true;
			}
		}
		
		if (isset($instance['size'])) { 
			$size = strip_tags($instance['size']);
		} else {
			$size = 'small';
		}

		?>
		<p>
			<label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:'); ?></label>
			<input type="text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" value="<?php if (isset($instance['title'])) echo esc_attr($instance['title']); ?>" class="widefat" />
		</p>
		
		<p><a href="https://support.pipdig.co/articles/shopr-carousel-widget/" rel="noopener" target="_blank">Click here</a> for information about how to use this widget.</p>

		<p>
		<?php if ($tags_available) { ?>
			<label for="<?php echo $this->get_field_id('collection'); ?>">Product Collecton:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'collection' ); ?>" name="<?php echo $this->get_field_name( 'collection' ); ?>">
				<option value="" <?php if ( '' == $collection ) echo 'selected="selected"'; ?>><?php echo esc_html__('None', 'shopr'); ?></option>
				<?php
				foreach ($tax_terms as $tax_term) { ?>
					<option value="<?php echo esc_attr($tax_term->slug); ?>" <?php if ( $tax_term->slug == $collection ) echo 'selected="selected"'; ?>><?php echo $tax_term->name; ?></option>
				<?php } ?>
			</select>
		<?php } else { ?>
			You have not yet setup any <a href="https://support.pipdig.co/articles/shopr-product-collections/" target="_blank">Product Collections</a>. You must add some products to a Collection before you can display it in this widget.
		<?php } ?>
		</p>
		
		<?php if ($wc_available) { ?>
		<p>
			<label for="<?php echo $this->get_field_id('wc_category'); ?>">WooCommerce Category:</label>
			<select class="widefat" id="<?php echo $this->get_field_id( 'wc_category' ); ?>" name="<?php echo $this->get_field_name( 'wc_category' ); ?>">
				<option value="" <?php if ( '' == $wc_category ) echo 'selected="selected"'; ?>><?php echo esc_html__('None', 'shopr'); ?></option>
				<?php
				foreach ($wc_tax_terms as $tax_term) { ?>
					<option value="<?php echo esc_attr($tax_term->slug); ?>" <?php if ( $tax_term->slug == $wc_category ) echo 'selected="selected"'; ?>><?php echo $tax_term->name; ?></option>
				<?php } ?>
			</select>
		</p>
		<?php } ?>
		
		<p>
			<label for="<?php echo $this->get_field_id('size'); ?>">Image Size:</label>
			<select id="<?php echo $this->get_field_id( 'size' ); ?>" name="<?php echo $this->get_field_name( 'size' ); ?>">
				<option <?php if ( 'small' == $size ) echo 'selected="selected"'; ?> value="small"><?php _e('Small', 'shopr') ?></option>
				<option <?php if ( 'medium' == $size ) echo 'selected="selected"'; ?> value="medium"><?php _e('Medium', 'shopr') ?></option>
				<option <?php if ( 'large' == $size ) echo 'selected="selected"'; ?> value="large"><?php _e('Large', 'shopr') ?></option>
			</select>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('product_titles'); ?>">
			<input type="checkbox" id="<?php echo $this->get_field_id('product_titles'); ?>" name="<?php echo $this->get_field_name('product_titles'); ?>" <?php if (isset($instance['product_titles'])) { checked((bool) $instance['product_titles'], true); } ?> /><?php _e('Show product titles on hover', 'shopr'); ?></label>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id('product_subtitles'); ?>">
			<input type="checkbox" id="<?php echo $this->get_field_id('product_subtitles'); ?>" name="<?php echo $this->get_field_name('product_subtitles'); ?>" <?php if (isset($instance['product_subtitles'])) { checked((bool) $instance['product_subtitles'], true); } ?> /><?php _e('Show product subtitles on hover', 'shopr'); ?></label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('show_pagination'); ?>">
			<input type="checkbox" id="<?php echo $this->get_field_id('show_pagination'); ?>" name="<?php echo $this->get_field_name('show_pagination'); ?>" <?php if (isset($instance['show_pagination'])) { checked((bool) $instance['show_pagination'], true); } ?> /><?php _e('Show pagination', 'shopr'); ?></label>
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('show_arrows'); ?>">
			<input type="checkbox" id="<?php echo $this->get_field_id('show_arrows'); ?>" name="<?php echo $this->get_field_name('show_arrows'); ?>" <?php if (isset($instance['show_arrows'])) { checked((bool) $instance['show_arrows'], true); } ?> /><?php _e('Show next/previous buttons', 'shopr'); ?></label>
		</p>
		
		<p style="margin-top: 30px;">
			<label for="<?php echo $this->get_field_id('shopstyle'); ?>">Shopstyle Collective List ID <a href="https://support.pipdig.co/articles/shopr-shopstyle-collective-list/" target="_blank" rel="noopener" style="text-decoration: none"><span class="dashicons dashicons-editor-help"></span></a></label>
			<input type="text" id="<?php echo $this->get_field_id('shopstyle'); ?>" name="<?php echo $this->get_field_name('shopstyle'); ?>" value="<?php if (isset($instance['shopstyle'])) echo esc_attr($instance['shopstyle']); ?>" class="widefat" />
		</p>

		<p>
			<label for="<?php echo $this->get_field_id('rewardstyle'); ?>">rewardStyle Boutique Widget ID <a href="https://support.pipdig.co/articles/shopr-rewardstyle-products/" target="_blank" rel="noopener" style="text-decoration: none"><span class="dashicons dashicons-editor-help"></span></a></label>
			<input type="text" id="<?php echo $this->get_field_id('rewardstyle'); ?>" name="<?php echo $this->get_field_name('rewardstyle'); ?>" value="<?php if (isset($instance['rewardstyle'])) echo esc_attr($instance['rewardstyle']); ?>" class="widefat" />
		</p>

		<p style="margin-bottom: 30px;">
			<label for="<?php echo $this->get_field_id('shop_link'); ?>">"Shop Now" link <a href="https://i.imgur.com/JvUr9Dl.png" target="_blank" rel="noopener" style="text-decoration: none"><span class="dashicons dashicons-editor-help"></span></a></label>
			<input type="text" id="<?php echo $this->get_field_id('shop_link'); ?>" name="<?php echo $this->get_field_name('shop_link'); ?>" value="<?php if (isset($instance['shop_link'])) echo esc_attr($instance['shop_link']); ?>" placeholder="<?php echo esc_url( home_url( '/' ) ); ?>shop/" class="widefat" />
		</p>

		<?php
		
	}

}


// register the widget
function shopr_register_widget() {
	register_widget('Shopr_Shopthepost_Widget');
}
add_action('widgets_init', 'shopr_register_widget');
