<?php
if (!defined('ABSPATH')) die;

function shopr_dash_widget() {
	add_meta_box( 
		'shopr_dash_widget',
		'Shopr - Top 10 product clicks',
		'shopr_dash_widget_func',
		'dashboard',
		'side',
		'low'
	);
}
add_action( 'wp_dashboard_setup', 'shopr_dash_widget' );

function shopr_dash_widget_func() {
	
	if (false === ($products = get_transient( 'shopr_dash_widget_data'))) {
		
		$products = array();
		
		$args = array(
			'post_type' => 'shopr_product',
			'posts_per_page' => 10,
			'meta_key' => 'shopr_product_clicks',
			'orderby' => 'meta_value_num',
			'order' => 'DESC'
		);

		$query = new WP_Query($args);
		
		if ($query->have_posts()) {
			while ( $query->have_posts() ) : $query->the_post();
				$id = get_the_ID();
				$products[] = array (
					'id' => $id,
					'title' => get_the_title(),
					'clicks' => get_post_meta($id, 'shopr_product_clicks', true),
				);
			endwhile; wp_reset_query();
		}
		
		set_transient('shopr_dash_widget_data', $products, 24 * HOUR_IN_SECONDS);
	
	}
	
	$output = '';
	$output .= '<p>This widget will display the top 10 most clicked products.</p>';
	if ($products) {
		$output .= '<ul>';
		foreach ($products as $product) {
			$output .= '<li>'.absint($product['clicks']).' clicks - <a href="'.admin_url('post.php?post='.absint($product['id']).'&action=edit').'">'.strip_tags($product['title']).'</a></li>';
		}
		$output .= '</ul>';
	} else {
		$output .= '<p style="font-style:italic">No data yet...</p>';
	}
	
	$output .= '<p>Stats are updated once every 24 hours.</p>';
	
	echo $output;
	
}