<?php
if (!defined('ABSPATH')) die;

// Enqueue scripts for the editor
function shopr_gutenberg_scripts() {
	
	// grab terms in a quick and dirty way. Waiting for official function in GB to be confirmed.
	$terms_list = array(array('value' => '', 'label' => __('Select a collection', 'shopr')) );
	$tax_terms = get_terms( array(
		'taxonomy' => 'shopr_category',
		'hide_empty' => false,
	) );
	if ($tax_terms && !is_wp_error($tax_terms)) {
		foreach ($tax_terms as $tax_term) {
			// build our own basic array to send to editor.js
			$terms_list[] = array(
				'label' => $tax_term->name,
				'value' => $tax_term->slug,
			);
		}
	}
	?>
	<script>
	var shopr_gb_data = {
		'terms': <?php echo json_encode($terms_list); ?>
	};
	</script>
   <?php
	
	wp_enqueue_script(
		'shopr-blocks',
		plugins_url( '/assets/blocks.js', __FILE__ ),
		[ 'wp-i18n', 'wp-blocks', 'wp-edit-post', 'wp-element', 'wp-editor', 'wp-components', 'wp-data', 'wp-plugins', 'wp-edit-post', 'wp-api' ],
		filemtime( plugin_dir_path(__FILE__).'/assets/blocks.js' )
	);
}
add_action( 'enqueue_block_assets', 'shopr_gutenberg_scripts' );

// Register the block and set callback
function shopr_blocks_init() {
	if (!function_exists('register_block_type')) {
		return;
	}
	// Carousel block
	register_block_type(
		'shopr/carousel', array(
			'render_callback' => 'shopr_carousel_block_callback',
			'attributes' => array(
				'title' => array(
					'type' => 'string',
				),
				'collection' => array(
					'type' => 'string',
				),
				'size' => array(
					'type' => 'string',
				),
			),
		)
	);
	
	// Grid block
	register_block_type(
		'shopr/grid', array(
			'render_callback' => 'shopr_grid_block_callback',
			'attributes' => array(
				'labelBrowseCollection' => array(
					'type' => 'string',
				),
				'labelShopNow' => array(
					'type' => 'string',
				),
				'labelShowAll' => array(
					'type' => 'string',
				),
				'collection' => array(
					'type' => 'string',
				),
				'exclude' => array(
					'type' => 'string',
				),
			),
		)
	);
}
add_action( 'plugins_loaded', 'shopr_blocks_init' );


function shopr_carousel_block_callback($attr) {
	extract($attr);
	
	//wp_enqueue_style('shopr');
	//wp_enqueue_script('pipdig-flickity');
	
	if (isset($collection)) {
		return do_shortcode('[shopr_shopthepost title="'.esc_html($title).'" collection="'.sanitize_text_field($collection).'" size="'.sanitize_text_field($size).'"]');
	}
}

function shopr_grid_block_callback($attr) {
	extract($attr);
	
	wp_enqueue_script('pipdig-imagesloaded');
	wp_enqueue_script('pipdig-isotope');
	
	$shortcode_atts = '';
	
	if ($labelBrowseCollection) {
		$shortcode_atts .= ' label_browse_collection="'.esc_html($labelBrowseCollection).'"';
	}
	if ($labelShopNow) {
		$shortcode_atts .= ' label_shop_now="'.esc_html($labelShopNow).'"';
	}
	if ($labelShowAll) {
		$shortcode_atts .= ' label_show_all="'.esc_html($labelShowAll).'"';
	}
	
	return do_shortcode('[shopr collection="'.sanitize_text_field($collection).'" exclude="'.sanitize_text_field($exclude).'" '.$shortcode_atts.']');
}
