jQuery(document).ready(function($) {
	
	// check if url is valid
	function shoprTestUrl(url) {
		return /^(https?|s?ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i.test(url);
	}
	
	/* START merge meta boxes */
	// https://wordpress.stackexchange.com/questions/2474/disable-dragging-of-meta-boxes
	$('.meta-box-sortables').sortable({
		disabled: true
	});
	$('.postbox .hndle').css('cursor', 'initial');
	
	// https://wordpress.stackexchange.com/questions/31941/disable-collapse-of-admin-meta-boxes
	$('.postbox .hndle').unbind('click.postboxes');
	$('.postbox .handlediv').remove();
	$('.postbox').removeClass('closed');
	/* END merge meta boxes */
	
	
	$('#postimagediv h2.hndle').html('Product Image <em>(required)</em>');
	
	if (shopr_data.thumbnail_set == 1) {
		$('#shopr_new_image_button').hide();
	} else {
		$('#set-post-thumbnail').addClass('button').html('Upload Custom Image').after('<div id="shopr_new_image_button" class="button">Search Link for Images</div><br /><div id="shopr_scrape_img_result"></div>');
	}
	
	// Hide date and visibility options from Publish meta box. TODO: We should do this with css.
	$('.misc-pub-curtime,.misc-pub-visibility').hide();
	
	$('#new-tag-shopr_category-desc').hide();
	$('#tagsdiv-shopr_category .inside').prepend('<p>Use this option to add this product to a Collection. <a href=" https://support.pipdig.co/articles/shopr-product-collections/" target="_blank">Click here</a> to read more about how to use Collections.</div>');
	
	/*
	$('#new-tag-shopr_tag-desc').hide();
	$('#tagsdiv-shopr_tag .inside').prepend('<p>Use this option to assign Tags to this product. <a href=" https://support.pipdig.co/articles/shopr-product-tags/" target="_blank">Click here</a> to read more about how to use Tags.</div>');
	*/
	
	// add text to featured image meta box.
	$('#postimagediv .inside').prepend('<p>Here you can upload an image for the product. Alternatively, you can search the Product Link for images automatically.</p>');
	
	//var setFeaturedImgLink = $('#set-post-thumbnail').attr('href');
	//$('#shopr_product_linked_img_custom_btn').attr('href', setFeaturedImgLink);
	
	// check fields have a value when user tries to publish product =======================
	$('#publish, #save-post').click(function(e){
		
		//var tagsOrCats = $('#tagsdiv-shopr_tag .tagchecklist span').length + $('#tagsdiv-shopr_category .tagchecklist span').length;
		
		if (!$('#shopr_product_link').val()) {
			alert('You must add a link to the product before publishing it.');
			$('#shopr_product_link').css('background-color', '#fffbe8');
			e.stopImmediatePropagation();
			return false;
		} else if ( (shopr_data.thumbnail_set == 0 && $('.attachment-post-thumbnail').attr('src').length < 1) && !$('#shopr_product_linked_img').val() ) {
			alert('You must set a Product Image before publishing it.');
			$('#postimagediv').css('background-color', '#fffbe8');
			e.stopImmediatePropagation();
			return false;
		/* } else if (tagsOrCats == 0) {
			alert('You must add this product to a Tag and/or Collection before publishing it.');
			$('#tagsdiv-shopr_tag, #tagsdiv-shopr_category').css('background-color', '#fffbe8');
			e.stopImmediatePropagation();
			return false;
			*/
		} else {
			return true;
		}
	});
	var publish_click_events = $('#publish').data('events').click;
	if (publish_click_events){
		if (publish_click_events.length > 1) {
			publish_click_events.unshift(publish_click_events.pop());
		}
	}
	if ($('#save-post').data('events') != null) {
		var save_click_events = $('#save-post').data('events').click;
		if (save_click_events) {
		  if (save_click_events.length > 1) {
			  save_click_events.unshift(save_click_events.pop());
		  }
		}
	}
	
	// =========================================
	
	
	// copy custom title field to actual title (which is hidden)
	$('#shopr_product_title').change(function() {
		$('#title').val($(this).val());
	});
	
	// reset product link field back to white when it's changed
	$('#shopr_product_link').change(function() {
		$(this).css('background-color', '#ffffff');
	});	
	
	$('#set-post-thumbnail').click(function() {
		$('#postimagediv').css('background-color', '#ffffff');
	});
	
	// On initial page load, check if image is already set
	var imgSrcThere = $('#shopr_product_linked_img').val();
	if ((shopr_data.thumbnail_set != 1) && shoprTestUrl(imgSrcThere)) {
		$('#shopr_scrape_img_result').html('<p>You have selected the following image for this product:</p><img src="'+imgSrcThere+'" alt="" class="shopr_scraped_img shopr_scraped_img_active"/>');
		$('#shopr_image_buttons').show();
	}
	
	// click "upload custom image" button to show featured image meta box
	$('#shopr_custom_image_button').click(function() {
		var postimagediv = $('#postimagediv');
		postimagediv.slideDown(300);
		$(this).fadeOut(300);
		postimagediv.css('background-color', '#fffdf4');
		//postimagediv.delay(3000).css('background-color', '#ffffff');
	});
	
	// scrape for new image when button clicked
	$('#shopr_new_image_button').click(function() {
		$('#postimagediv').css('background-color', '#ffffff');
		var link = $('#shopr_product_link').val();
		if (shoprTestUrl(link)) {
			$('#shopr_scrape_img_result').html('<p><span class="dashicons dashicons-update spin"></span> Loading images. This may take a moment...</p>');
			//$('#shopr_new_image_button').hide();
		} else {
			$('#shopr_scrape_img_result').html('<p><span class="dashicons dashicons-no"></span> The Product Link is not a valid URL. Please check it follows a normal format such as "https://www.google.com"</p>');
			$('#shopr_product_link').css('background-color', '#fffbe8');
		}
		var data = {
			action: 'shopr_product_link_scrape',
			'link': link,
		};
		$.post(ajaxurl, data, function(response) {
			//alert(response);
			if ((shopr_data.thumbnail_set != 1) && (response.length > 5)) {
				$('#shopr_scrape_img_result').html(response);
				var imgSrc = $('.shopr_scraped_img_active').attr('src');
				$('#shopr_product_linked_img').val(imgSrc);
			}
		});
	});
		
	// find clicked image and set as hidden value for post meta.
	$('#shopr_scrape_img_result').on('click', '.shopr_scraped_img', function(event) {
		$('.shopr_scraped_img_active').removeClass('shopr_scraped_img_active');
		$(this).addClass('shopr_scraped_img_active');
		var imgSrc = $(this).attr('src');
		$('#shopr_product_linked_img').val(imgSrc);
	});
	
	// on page load, if link is valid and an image isn't already set
	/*
	if ((shopr_data.thumbnail_set != 1) && shoprTestUrl(link) && !$('#shopr_product_linked_img').val()) {
		
		$('#shopr_scrape_img_result').html('<p><span class="dashicons dashicons-update spin"></span> Loading images. This may take a moment...</p>');
		
		var data = {
			action: 'shopr_product_link_scrape',
			'link': $('#shopr_product_link').val(),
		};
		$.post(ajaxurl, data, function(response) {
			//alert(response);
			if (response.length > 5) {
				$('#shopr_scrape_img_result').html(response);
			}
		});
	
	}
	*/
	
	/*
	var linkCheckTimer;
	
	// on changes to input
	$('#shopr_product_link').on('input', function() {
		
		// check every 1 seconds
		clearTimeout(linkCheckTimer);
		linkCheckTimer = setTimeout(function() {
				
			var link = $('#shopr_product_link').val();
			if (shoprTestUrl(link)) {
				$('#shopr_scrape_img_result').html('<p><span class="dashicons dashicons-update spin"></span> Loading images. This may take a moment...</p>');
				$('#shopr_image_buttons').show();
			} else {
				$('#shopr_scrape_img_result').html('<p><span class="dashicons dashicons-no"></span> This is not a valid URL. Please check it follows a normal format such as "http://www.google.com"</p>');
			}
			var data = {
				action: 'shopr_product_link_scrape',
				'link': link,
			};
			$.post(ajaxurl, data, function(response) {
				//alert(response);
				if ((shopr_data.thumbnail_set != 1) && (response.length > 5)) {
					$('#shopr_scrape_img_result').html(response);
					var imgSrc = $('.shopr_scraped_img_active').attr('src');
					$('#shopr_product_linked_img').val(imgSrc);
					$('#shopr_image_buttons').show();
				}
			});
				
		}, 1000);
	
	});
	*/
	
});