<?php
if (!defined('ABSPATH')) die;

// store a transient key so we can flush them later
function shopr_save_transient_key($new_transient_key) {
	$transient_keys = get_option('shopr_transient_keys');
	$transient_keys[]= $new_transient_key;
	update_option('shopr_transient_keys', $transient_keys);
}

// call this function to purge transients
function shopr_purge_transients() {
	$transient_keys = get_option('shopr_transient_keys');
	foreach ($transient_keys as $transient) {
		delete_transient($transient);
	}
	// reset the list of saved transients
	update_option( 'shopr_transient_keys', array() );
}

function shopr_get_shopstyle_list($list_id) {

	//$list_id = '47383839';

	if ( false === ( $products = get_transient( 'shopr_ss_'.$list_id ) )) {

		$queries = array(
			'domain' => get_site_url(),
			'tempToken' => 'dcx15',
			'list_id' => $list_id
		);

		$options = get_option('shopr_options');
		if (isset($options['shopstyle_key'])) {
			$queries['key'] = sanitize_text_field($options['shopstyle_key']);
		}

		$url = add_query_arg($queries, 'https://pipdig.rocks/shopr/ss/');

		$args = array(
			'timeout' => 9,
		);
		$response = wp_remote_get($url, $args);

		if (is_wp_error($response)) {
			return false;
		}

		$products = json_decode($response['body']);

		set_transient( 'shopr_ss_'.$list_id, $products, 10 * MINUTE_IN_SECONDS );
		shopr_save_transient_key('shopr_ss_'.$list_id);
	}

	if (is_array($products) && count($products) > 0) {
		return $products;
	}

	delete_transient('shopr_ss_'.$list_id);
	return false;

}


function shopr_get_rewardstyle_list($list_id) {

	//$list_id = '2509992';

	if ( false === ( $products = get_transient( 'shopr_rs_'.$list_id ) )) {

		$queries = array(
			'domain' => get_site_url(),
			'tempToken' => 'dcx15',
			'list_id' => $list_id
		);

		$url = add_query_arg($queries, 'https://pipdig.rocks/shopr/rs/');

		$args = array(
			'timeout' => 9,
		);
		$response = wp_remote_get($url, $args);

		if (is_wp_error($response)) {
			return false;
		}

		$products = json_decode($response['body']);

		set_transient( 'shopr_rs_'.$list_id, $products, 10 * MINUTE_IN_SECONDS );
		shopr_save_transient_key('shopr_rs_'.$list_id);
	}

	if (is_array($products) && count($products) > 0) {
		return $products;
	}

	delete_transient('shopr_rs_'.$list_id);
	return false;

}
