<?php
if (!defined('ABSPATH')) die;

function shopr_shortcode_generator_func() {
	if (!current_user_can('edit_theme_options')) {
		wp_die();
	}
	?>
	
	<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css" rel="stylesheet" />
	<script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/js/select2.min.js"></script>
	
	<div class="wrap">
	
	<div id="shortcode_generator_card" class="shopr-card">
	
		<p>You can use this page to display your products in a shopping grid. Simply select the from the options below, then copy and paste the shortcode into a page/post.</p>
		
		<h3 style="margin-bottom: 0">Options:</h3>
		
		<table class="form-table">

			<tr>
				<th scope="row"><label for="shopr_collections">Product Collection(s)</label></th>
				<td>
					<?php
					$collections_output = 'No collections available. Would you like to create one?';
					$tax_terms = get_terms('shopr_category');
					if ($tax_terms && !is_wp_error($tax_terms)) {
						$collections_output = '<select id="shopr_collections" multiple="multiple">';
						foreach ($tax_terms as $tax_term) {
							$collections_output .= '<option value="'.esc_attr($tax_term->slug).'">'.esc_html($tax_term->name).'</option>';
						}
						$collections_output .= '</select>';
					}
					echo $collections_output;
					?>
					<p class="howto">You can select multiple Collections. If you do not select a Collection, all products will be displayed.</p>
				</td>
			</tr>
			
			<tr>
				<th scope="row"><label for="shopr_shopstyle_id">Shopstyle List ID</label></th>
				<td><input type="number" class="large-text" id="shopr_shopstyle_id" name="shopr_shopstyle_id" value=""></td>
			</tr>
			
			<tr>
				<th scope="row"><label for="shopr_rewardstyle_id">rewardStyle Widget ID</label></th>
				<td><input type="number" class="large-text" id="shopr_rewardstyle_id" name="shopr_rewardstyle_id" value=""></td>
			</tr>

			<tr>
				<th scope="row"><label for="shopr_random">Display products in a random order?</label></th>
				<td><input type="checkbox" id="shopr_random" name="shopr_random" value="true"></td>
			</tr>

		</table>
		
		<h3>Result:</h3>
		
		<div id="shopr_result_isotope"></div>
		
		<div id="shopr_result_msg"><p>When you have finished changing the options above, copy this shortcode into a page/post:</p></div>
		
		<textarea id="shopr_shortcode_result" class="large-text" onClick="this.select();" readonly>[shopr]</textarea>
		
		<p>You can edit the style of the widget in the <a href="<?php echo admin_url('customize.php?autofocus[section]=shopr_section'); ?>">Customizer</a>.</p>
		
	</div> <!--// .card -->
	
	<div class="shopr-card shopr-card-preview">
		<img src="https://pipdigz.co.uk/shopr/shopr_gird_overview.png" alt="" />
	</div>
	
	</div> <!--// .wrap -->
	
	<style>
	.shopr-card {
		margin-top: 10px;
		padding: 20px;
		background: #fff;
		border: 1px solid #ddd;
		float: left;
		width: 550px;
		max-width: 100%;
	}
	.shopr-card img {
		max-width: 100%;
		height: auto;
	}
	.shopr-card-preview {
		margin-left: 20px;
		width: 700px;
	}
	@media screen and (max-width: 1680px) {
		.shopr-card {
			width: 42%;
		}
		.shopr-card-preview {
			margin-left: 10px;
		}
	}
	@media screen and (max-width: 900px) {
		.shopr-card {
			float: none;
			width: auto;
		}
		.shopr-card-preview {
			margin-left: 0;
		}
	}
	</style>
	
	<script>
	jQuery(document).ready(function($) {
		
		$('#shopr_collections').select2();
		
		$('#shortcode_generator_card .form-table').change('input', function() {
			
			var output = '[shopr';
				
			if ( (!$('#shopr_collection_all').is(":checked")) && (typeof collections_array !== 'undefined' && collections_array.length > 0) ) {
				var collectons = collections_array.join(',');
				output += ' collection="'+collectons+'"';
			}
			
			if ($("#shopr_collections").val()) {
				output += ' collection="'+$("#shopr_collections").val()+'"';
			}	
			if ($("#shopr_shopstyle_id").val()) {
				output += ' shopstyle="'+$("#shopr_shopstyle_id").val()+'"';
			}
			if ($("#shopr_rewardstyle_id").val()) {
				output += ' rewardstyle="'+$("#shopr_rewardstyle_id").val()+'"';
			}
			if ($("#shopr_random").is(":checked")) {
				output += ' order="random"';
			}
			
			output += ']';
			
			$('#shopr_shortcode_result').val(output);
	
		});
	});
	</script>
	
	<?php
}